/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.metrics.api.MetricsConfig;
import io.helidon.metrics.api.SystemTagsManagerImpl;
import io.helidon.metrics.api.Tag;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;

public interface SystemTagsManager {
    public static SystemTagsManager create(MetricsConfig metricsConfig) {
        return SystemTagsManagerImpl.create(metricsConfig);
    }

    public static SystemTagsManager instance() {
        return SystemTagsManagerImpl.instance();
    }

    public static SystemTagsManager instance(MetricsConfig metricsConfig) {
        return SystemTagsManagerImpl.instance(metricsConfig);
    }

    public static void onChange(Consumer<SystemTagsManager> changeListener) {
        SystemTagsManagerImpl.onChange(changeListener);
    }

    public Optional<Tag> scopeTag(Optional<String> var1);

    public Iterable<Map.Entry<String, String>> withScopeTag(Iterable<Map.Entry<String, String>> var1, String var2);

    public Iterable<Tag> withScopeTag(Iterable<Tag> var1, Optional<String> var2);

    public Iterable<Tag> withoutSystemTags(Iterable<Tag> var1);

    public Iterable<Tag> withoutSystemOrScopeTags(Iterable<Tag> var1);

    public Iterable<Tag> displayTags();

    default public Map<String, String> displayTagPairs() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        this.displayTags().forEach(tag -> result.put(tag.key(), tag.value()));
        return result;
    }

    public Collection<String> reservedTagNamesUsed(Collection<String> var1);

    public void assignScope(String var1, Function<Tag, ?> var2);

    public Optional<String> effectiveScope(Optional<String> var1);

    public Optional<String> effectiveScope(Optional<String> var1, Iterable<Tag> var2);

    public Optional<String> scopeTagName();
}

