/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metadata.reflection;

import io.helidon.common.types.Annotation;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.metadata.reflection.TypeFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class AnnotationFactory {
    private AnnotationFactory() {
    }

    public static List<io.helidon.common.types.Annotation> create(AnnotatedElement annotated) {
        Annotation[] declared;
        ArrayList<io.helidon.common.types.Annotation> annotations = new ArrayList<io.helidon.common.types.Annotation>();
        for (Annotation annotation : declared = annotated.getDeclaredAnnotations()) {
            annotations.add(AnnotationFactory.create(annotation));
        }
        return List.copyOf(annotations);
    }

    public static io.helidon.common.types.Annotation create(Annotation annotation) {
        TypeName type = TypeName.create(annotation.annotationType());
        HashSet<TypeName> set = new HashSet<TypeName>();
        set.add(TypeNames.INHERITED);
        set.add(TypeNames.TARGET);
        set.add(TypeNames.RETENTION);
        set.add(TypeNames.DOCUMENTED);
        set.remove(type);
        return AnnotationFactory.createAnnotation(annotation, set).orElseThrow();
    }

    public static <T extends Annotation> Optional<T> synthesize(io.helidon.common.types.Annotation annotation) {
        Class<?> annotationType;
        try {
            annotationType = TypeFactory.toClass(annotation.typeName());
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
        return Optional.of((Annotation)Proxy.newProxyInstance(AnnotationFactory.classLoader(), new Class[]{annotationType}, (InvocationHandler)new AnnotationInvocationHandler(annotationType, annotation)));
    }

    private static ClassLoader classLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            return loader;
        }
        return AnnotationFactory.class.getClassLoader();
    }

    private static Optional<io.helidon.common.types.Annotation> createAnnotation(Annotation annotation, Set<TypeName> processedTypes) {
        TypeName type = TypeName.create(annotation.annotationType());
        if (processedTypes.contains(type)) {
            return Optional.empty();
        }
        Annotation.Builder builder = io.helidon.common.types.Annotation.builder();
        Stream.of(annotation.annotationType().getDeclaredAnnotations()).map(it -> {
            HashSet<TypeName> newProcessed = new HashSet<TypeName>(processedTypes);
            newProcessed.add(type);
            return AnnotationFactory.createAnnotation(it, newProcessed);
        }).flatMap(Optional::stream).forEach(arg_0 -> ((Annotation.Builder)builder).addMetaAnnotation(arg_0));
        return Optional.of(((Annotation.Builder)((Annotation.Builder)builder.typeName(type)).values(AnnotationFactory.extractAnnotationValues(annotation))).build());
    }

    private static List<Method> valueMethods(Class<? extends Annotation> annotationType) {
        return Stream.of(annotationType.getDeclaredMethods()).filter(it -> Modifier.isPublic(it.getModifiers())).collect(Collectors.toUnmodifiableList());
    }

    private static Map<String, Object> extractAnnotationValues(Annotation annotation) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        AnnotationFactory.valueMethods(annotation.annotationType()).forEach(method -> {
            Object value;
            String name = method.getName();
            try {
                value = method.invoke((Object)annotation, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to invoke annotation method, cannot analyze it", e);
            }
            if (value instanceof Annotation) {
                Annotation annot = (Annotation)value;
                result.put(name, AnnotationFactory.create(annot));
            } else if (value.getClass().isArray()) {
                Class<?> componentType = value.getClass().getComponentType();
                if (componentType.isPrimitive()) {
                    result.put(name, AnnotationFactory.toPrimitiveArray(componentType, value));
                } else if (Annotation.class.isAssignableFrom(componentType)) {
                    result.put(name, Stream.of((Annotation[])value).map(AnnotationFactory::create).collect(Collectors.toUnmodifiableList()));
                } else {
                    result.put(name, List.of((Object[])value));
                }
            } else {
                result.put(name, value);
            }
        });
        return result;
    }

    private static Object toPrimitiveArray(Class<?> componentType, Object value) {
        if (componentType.equals(Integer.TYPE)) {
            return Arrays.stream((int[])value).boxed().collect(Collectors.toUnmodifiableList());
        }
        if (componentType.equals(Long.TYPE)) {
            return Arrays.stream((long[])value).boxed().collect(Collectors.toUnmodifiableList());
        }
        if (componentType.equals(Double.TYPE)) {
            return Arrays.stream((double[])value).boxed().collect(Collectors.toUnmodifiableList());
        }
        if (componentType.equals(Short.TYPE)) {
            short[] array;
            ArrayList<Short> result = new ArrayList<Short>();
            for (short i : array = (short[])value) {
                result.add(i);
            }
            return result;
        }
        if (componentType.equals(Byte.TYPE)) {
            byte[] array;
            ArrayList<Byte> result = new ArrayList<Byte>();
            for (byte i : array = (byte[])value) {
                result.add(i);
            }
            return result;
        }
        if (componentType.equals(Character.TYPE)) {
            char[] array;
            ArrayList<Character> result = new ArrayList<Character>();
            for (char i : array = (char[])value) {
                result.add(Character.valueOf(i));
            }
            return result;
        }
        if (componentType.equals(Float.TYPE)) {
            float[] array;
            ArrayList<Float> result = new ArrayList<Float>();
            for (float i : array = (float[])value) {
                result.add(Float.valueOf(i));
            }
            return result;
        }
        if (componentType.equals(Boolean.TYPE)) {
            boolean[] array;
            ArrayList<Boolean> result = new ArrayList<Boolean>();
            for (boolean i : array = (boolean[])value) {
                result.add(i);
            }
            return result;
        }
        throw new IllegalArgumentException("Unknown primitive type: " + componentType.getName());
    }

    private static class AnnotationInvocationHandler
    implements InvocationHandler {
        private final Class<? extends Annotation> annotationType;
        private final io.helidon.common.types.Annotation annotation;
        private int cachedHash;

        private AnnotationInvocationHandler(Class<? extends Annotation> annotationType, io.helidon.common.types.Annotation annotation) {
            this.annotationType = annotationType;
            this.annotation = annotation;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            String name = method.getName();
            if (args == null || args.length == 0) {
                switch (name) {
                    case "annotationType": {
                        return this.annotationType;
                    }
                    case "hashCode": {
                        return this.handleHashCode(proxy);
                    }
                    case "toString": {
                        return this.annotation.toString();
                    }
                }
                Class<?> returnType = method.getReturnType();
                if (returnType.equals(Void.TYPE) || returnType.equals(Void.class)) {
                    return null;
                }
                return this.invokeProperty(method, name, returnType);
            }
            if (args.length == 1 && "equals".equals(name)) {
                return this.handleEquals(args[0]);
            }
            return method.getDefaultValue();
        }

        private Object invokeProperty(Method method, String name, Class<?> returnType) {
            if (Class.class.equals(returnType)) {
                return this.annotation.typeValue(name).map(TypeFactory::toClass).orElseGet(() -> (Class)method.getDefaultValue());
            }
            if (String.class.equals(returnType)) {
                return this.annotation.stringValue(name).orElseGet(() -> (String)method.getDefaultValue());
            }
            if (Integer.TYPE.equals(returnType)) {
                return this.annotation.intValue(name).orElseGet(() -> (Integer)method.getDefaultValue());
            }
            if (Long.TYPE.equals(returnType)) {
                return this.annotation.longValue(name).orElseGet(() -> (Long)method.getDefaultValue());
            }
            if (Boolean.TYPE.equals(returnType)) {
                return this.annotation.booleanValue(name).orElseGet(() -> (Boolean)method.getDefaultValue());
            }
            if (Double.TYPE.equals(returnType)) {
                return this.annotation.doubleValue(name).orElseGet(() -> (Double)method.getDefaultValue());
            }
            if (Float.TYPE.equals(returnType)) {
                return this.annotation.floatValue(name).orElseGet(() -> (Float)method.getDefaultValue());
            }
            if (Byte.TYPE.equals(returnType)) {
                return this.annotation.byteValue(name).orElseGet(() -> (Byte)method.getDefaultValue());
            }
            if (Character.TYPE.equals(returnType)) {
                return this.annotation.charValue(name).orElseGet(() -> (Character)method.getDefaultValue());
            }
            if (Short.TYPE.equals(returnType)) {
                return this.annotation.shortValue(name).orElseGet(() -> (Short)method.getDefaultValue());
            }
            if (returnType.isEnum()) {
                return this.annotation.enumValue(name, returnType).orElseGet(method::getDefaultValue);
            }
            if (Annotation.class.isAssignableFrom(returnType)) {
                return this.annotation.annotationValue(name).flatMap(AnnotationFactory::synthesize).orElseGet(method::getDefaultValue);
            }
            if (!returnType.isArray()) {
                return method.getDefaultValue();
            }
            return this.invokeArrayProperty(method, name, returnType.getComponentType());
        }

        private Object invokeArrayProperty(Method method, String name, Class<?> componentType) {
            if (Class.class.equals(componentType)) {
                Optional values = this.annotation.typeValues(name);
                if (values.isEmpty()) {
                    return method.getDefaultValue();
                }
                return ((List)values.get()).stream().map(TypeFactory::toClass).toArray(Class[]::new);
            }
            if (String.class.equals(componentType)) {
                return this.annotation.stringValues(name).orElseGet(List::of).stream().toArray(String[]::new);
            }
            if (Integer.TYPE.equals(componentType)) {
                List values = this.annotation.intValues(name).orElseGet(List::of);
                int[] response = new int[values.size()];
                for (int i = 0; i < response.length; ++i) {
                    response[i] = (Integer)values.get(i);
                }
                return response;
            }
            if (Short.TYPE.equals(componentType)) {
                List values = this.annotation.shortValues(name).orElseGet(List::of);
                short[] response = new short[values.size()];
                for (int i = 0; i < response.length; ++i) {
                    response[i] = (Short)values.get(i);
                }
                return response;
            }
            if (Long.TYPE.equals(componentType)) {
                List values = this.annotation.longValues(name).orElseGet(List::of);
                long[] response = new long[values.size()];
                for (int i = 0; i < response.length; ++i) {
                    response[i] = (Long)values.get(i);
                }
                return response;
            }
            if (Boolean.TYPE.equals(componentType)) {
                List values = this.annotation.booleanValues(name).orElseGet(List::of);
                boolean[] response = new boolean[values.size()];
                for (int i = 0; i < response.length; ++i) {
                    response[i] = (Boolean)values.get(i);
                }
                return response;
            }
            if (Double.TYPE.equals(componentType)) {
                List values = this.annotation.doubleValues(name).orElseGet(List::of);
                double[] response = new double[values.size()];
                for (int i = 0; i < response.length; ++i) {
                    response[i] = (Double)values.get(i);
                }
                return response;
            }
            if (Float.TYPE.equals(componentType)) {
                List values = this.annotation.floatValues(name).orElseGet(List::of);
                float[] response = new float[values.size()];
                for (int i = 0; i < response.length; ++i) {
                    response[i] = ((Float)values.get(i)).floatValue();
                }
                return response;
            }
            if (Byte.TYPE.equals(componentType)) {
                List values = this.annotation.byteValues(name).orElseGet(List::of);
                byte[] response = new byte[values.size()];
                for (int i = 0; i < response.length; ++i) {
                    response[i] = (Byte)values.get(i);
                }
                return response;
            }
            if (Character.TYPE.equals(componentType)) {
                List values = this.annotation.charValues(name).orElseGet(List::of);
                char[] response = new char[values.size()];
                for (int i = 0; i < response.length; ++i) {
                    response[i] = ((Character)values.get(i)).charValue();
                }
                return response;
            }
            if (componentType.isEnum()) {
                Optional values = this.annotation.enumValues(name, componentType);
                return values.orElseGet(List::of).stream().toArray(length -> (Object[])Array.newInstance(componentType, length));
            }
            if (Annotation.class.isAssignableFrom(componentType)) {
                return this.annotation.annotationValues(name).orElseGet(List::of).stream().map(AnnotationFactory::synthesize).flatMap(Optional::stream).toArray(it -> (Object[])Array.newInstance(componentType, it));
            }
            return method.getDefaultValue();
        }

        private static int hashValue(Object value) {
            if (value instanceof boolean[]) {
                return Arrays.hashCode((boolean[])value);
            }
            if (value instanceof short[]) {
                return Arrays.hashCode((short[])value);
            }
            if (value instanceof int[]) {
                return Arrays.hashCode((int[])value);
            }
            if (value instanceof long[]) {
                return Arrays.hashCode((long[])value);
            }
            if (value instanceof float[]) {
                return Arrays.hashCode((float[])value);
            }
            if (value instanceof double[]) {
                return Arrays.hashCode((double[])value);
            }
            if (value instanceof byte[]) {
                return Arrays.hashCode((byte[])value);
            }
            if (value instanceof char[]) {
                return Arrays.hashCode((char[])value);
            }
            if (value instanceof Object[]) {
                return Arrays.hashCode((Object[])value);
            }
            return value.hashCode();
        }

        private boolean handleEquals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (!this.annotationType.isInstance(other)) {
                return false;
            }
            io.helidon.common.types.Annotation otherAnnotation = AnnotationFactory.create((Annotation)other);
            return this.annotation.equals((Object)otherAnnotation);
        }

        private int handleHashCode(Object proxy) {
            if (this.cachedHash != 0) {
                return this.cachedHash;
            }
            int hashCode = 0;
            List<Method> methods = AnnotationFactory.valueMethods(this.annotationType);
            for (Method method : methods) {
                Object value = this.invoke(proxy, method, null);
                int nameHash = 127 * method.getName().hashCode();
                int valueHash = AnnotationInvocationHandler.hashValue(value);
                hashCode += nameHash ^ valueHash;
            }
            this.cachedHash = hashCode;
            return hashCode;
        }
    }
}

