/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.logging.jul;

import io.helidon.logging.common.HelidonMdc;
import io.helidon.logging.jul.HelidonFormatter;
import io.helidon.metadata.hson.Hson;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HelidonJsonFormatter
extends Formatter {
    static final String DEFAULT_FORMAT = "ts:%1$tQ,date:%1$tY.%1$tm.%1$td,time:%1$tH:%1$tM:%1$tS.%1$tL,level:%4$s,message:%5$s,exception:%6$s,thread:!thread!,logger:%3$s";
    private static final String JSON_FORMAT_PROP_KEY = "io.helidon.logging.jul.HelidonJsonFormatter.fields";
    private static final String EPOCH_MILLIS_FORMAT = "%1$tQ";
    private static final String YEAR_FORMAT = "%1$tY";
    private static final String MONTH_FORMAT = "%1$tm";
    private static final String DAY_FORMAT = "%1$td";
    private static final String HOUR_FORMAT = "%1$tH";
    private static final String MINUTE_FORMAT = "%1$tM";
    private static final String SECOND_FORMAT = "%1$tS";
    private static final String SOURCE_FORMAT = "%2$s";
    private static final String LOGGER_FORMAT = "%3$s";
    private static final String LEVEL_FORMAT = "%4$s";
    private static final String MESSAGE_FORMAT = "%5$s";
    private static final String EXCEPTION_FORMAT = "%6$s";
    private final List<ValueFormatter> formatters;

    public HelidonJsonFormatter() {
        String jsonFormat = LogManager.getLogManager().getProperty(JSON_FORMAT_PROP_KEY);
        String julFormat = LogManager.getLogManager().getProperty("java.util.logging.SimpleFormatter.format");
        if (jsonFormat == null && julFormat == null) {
            jsonFormat = DEFAULT_FORMAT;
        }
        this.formatters = jsonFormat == null ? this.guessFromSimpleFormat(julFormat) : this.fromJsonFormat(jsonFormat);
    }

    HelidonJsonFormatter(String format, boolean jsonFormat) {
        this.formatters = jsonFormat ? this.fromJsonFormat(format) : this.guessFromSimpleFormat(format);
    }

    @Override
    public String format(LogRecord record) {
        Hson.Struct.Builder builder = Hson.Struct.builder();
        Object[] params = HelidonFormatter.parameters(record, super.formatMessage(record));
        this.formatters.forEach(formatter -> formatter.update(builder, params));
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ((Hson.Struct)builder.build()).write(pw);
        pw.println();
        pw.close();
        return sw.toString();
    }

    private List<ValueFormatter> fromJsonFormat(String jsonFormat) {
        return Stream.of(jsonFormat.split(",")).map(it -> new ValueFormatter(Field.create(jsonFormat, it))).collect(Collectors.toUnmodifiableList());
    }

    private List<ValueFormatter> guessFromSimpleFormat(String julFormat) {
        ArrayList<ValueFormatter> result = new ArrayList<ValueFormatter>();
        HashMap<String, AtomicInteger> counters = new HashMap<String, AtomicInteger>();
        String usedFormat = julFormat.replaceAll("%n", " ");
        for (String block : usedFormat.split(" ")) {
            if (block.isBlank()) continue;
            if (block.contains(YEAR_FORMAT) && block.contains(MONTH_FORMAT) && block.contains(DAY_FORMAT)) {
                if (block.contains(HOUR_FORMAT)) {
                    result.add(new ValueFormatter(new Field(this.name(counters, "timestamp"), block)));
                    continue;
                }
                result.add(new ValueFormatter(new Field(this.name(counters, "date"), block)));
                continue;
            }
            if (block.contains(HOUR_FORMAT) && block.contains(MINUTE_FORMAT)) {
                result.add(new ValueFormatter(new Field(this.name(counters, "time"), block)));
                continue;
            }
            if (block.contains(SOURCE_FORMAT) && block.length() < 7) {
                result.add(new ValueFormatter(new Field(this.name(counters, "source"), block)));
                continue;
            }
            if (block.contains(LOGGER_FORMAT) && block.length() < 7) {
                result.add(new ValueFormatter(new Field(this.name(counters, "logger"), block)));
                continue;
            }
            if (block.contains(LEVEL_FORMAT) && block.length() < 7) {
                result.add(new ValueFormatter(new Field(this.name(counters, "level"), block)));
                continue;
            }
            if (block.contains(MESSAGE_FORMAT) && block.length() < 7) {
                result.add(new ValueFormatter(new Field(this.name(counters, "message"), block)));
                continue;
            }
            if (block.contains(EXCEPTION_FORMAT) && block.length() < 7) {
                result.add(new ValueFormatter(new Field(this.name(counters, "exception"), block)));
                continue;
            }
            if (block.contains("!thread!") && block.length() < "!thread!".length() + 3) {
                result.add(new ValueFormatter(new Field(this.name(counters, "thread"), block)));
                continue;
            }
            if (block.contains(EPOCH_MILLIS_FORMAT)) {
                result.add(new ValueFormatter(new Field(this.name(counters, "ts"), EPOCH_MILLIS_FORMAT)));
            }
            if (block.contains(YEAR_FORMAT)) {
                result.add(new ValueFormatter(new Field(this.name(counters, "year"), YEAR_FORMAT)));
            }
            if (block.contains(MONTH_FORMAT)) {
                result.add(new ValueFormatter(new Field(this.name(counters, "month"), MONTH_FORMAT)));
            }
            if (block.contains(DAY_FORMAT)) {
                result.add(new ValueFormatter(new Field(this.name(counters, "day"), DAY_FORMAT)));
            }
            if (block.contains(HOUR_FORMAT)) {
                result.add(new ValueFormatter(new Field(this.name(counters, "hour"), HOUR_FORMAT)));
            }
            if (block.contains(MINUTE_FORMAT)) {
                result.add(new ValueFormatter(new Field(this.name(counters, "minute"), MINUTE_FORMAT)));
            }
            if (block.contains(SECOND_FORMAT)) {
                result.add(new ValueFormatter(new Field(this.name(counters, "second"), SECOND_FORMAT)));
            }
            if (block.contains(SOURCE_FORMAT)) {
                result.add(new ValueFormatter(new Field(this.name(counters, "source"), SOURCE_FORMAT)));
            }
            if (block.contains(LOGGER_FORMAT)) {
                result.add(new ValueFormatter(new Field(this.name(counters, "logger"), LOGGER_FORMAT)));
            }
            if (block.contains(LEVEL_FORMAT)) {
                result.add(new ValueFormatter(new Field(this.name(counters, "level"), LEVEL_FORMAT)));
            }
            if (block.contains(MESSAGE_FORMAT)) {
                result.add(new ValueFormatter(new Field(this.name(counters, "message"), MESSAGE_FORMAT)));
            }
            if (block.contains(EXCEPTION_FORMAT)) {
                result.add(new ValueFormatter(new Field(this.name(counters, "exception"), EXCEPTION_FORMAT)));
            }
            if (block.contains("!thread!") || block.contains("%X{thread}")) {
                result.add(new ValueFormatter(new Field(this.name(counters, "thread"), "!thread!")));
            }
            Matcher matcher = HelidonFormatter.X_VALUE.matcher(usedFormat);
            while (matcher.find()) {
                String name = matcher.group(2);
                if (name.equals("thread")) continue;
                result.add(new ValueFormatter(new Field(this.name(counters, "X." + name), "%X{" + name + "}")));
            }
        }
        return result;
    }

    private String name(Map<String, AtomicInteger> counters, String name) {
        if (counters.containsKey(name)) {
            return name + "_" + counters.get(name).incrementAndGet();
        }
        counters.put(name, new AtomicInteger());
        return name;
    }

    private static class ValueFormatter {
        private final Set<String> parsedProps = new HashSet<String>();
        private final String jsonName;
        private final String format;
        private final boolean thread;

        private ValueFormatter(Field field) {
            this.jsonName = field.name();
            this.format = field.format();
            this.thread = this.format.contains("!thread!") || this.format.contains("%X{thread}");
            Matcher matcher = HelidonFormatter.X_VALUE.matcher(this.format);
            while (matcher.find()) {
                this.parsedProps.add(matcher.group(2));
            }
        }

        private void update(Hson.Struct.Builder jsonBuilder, Object ... parameters) {
            String message = this.thread ? HelidonFormatter.thread(this.format) : this.format;
            for (String parsedKey : this.parsedProps) {
                String value = HelidonMdc.get((String)parsedKey).orElse("");
                message = HelidonFormatter.PATTERN_CACHE.computeIfAbsent(parsedKey, key -> Pattern.compile("%X\\{" + key + "}")).matcher(message).replaceAll(value);
            }
            String formattedValue = String.format(message, parameters);
            if (!formattedValue.isBlank()) {
                jsonBuilder.set(this.jsonName, formattedValue);
            }
        }
    }

    private record Field(String name, String format) {
        private static Field create(String format, String field) {
            int index = field.indexOf(58);
            if (index == -1) {
                throw new IllegalArgumentException("Invalid format definition for " + HelidonJsonFormatter.class.getSimpleName() + ", each field must have field name followed by a colon with field value, such as 'message:%5$s', but got: '" + field + "'. Full format: " + format);
            }
            return new Field(field.substring(0, index), field.substring(index + 1));
        }
    }
}

