/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.langchain4j;

import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.store.embedding.EmbeddingStore;
import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.common.config.ConfigBuilderSupport;
import io.helidon.integrations.langchain4j.EmbeddingStoreContentRetrieverConfigBlueprint;
import java.util.Objects;
import java.util.Optional;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.integrations.langchain4j.EmbeddingStoreContentRetrieverConfigBlueprint")
public interface EmbeddingStoreContentRetrieverConfig
extends EmbeddingStoreContentRetrieverConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(EmbeddingStoreContentRetrieverConfig instance) {
        return (Builder)EmbeddingStoreContentRetrieverConfig.builder().from(instance);
    }

    public static EmbeddingStoreContentRetrieverConfig create(Config config) {
        return ((Builder)EmbeddingStoreContentRetrieverConfig.builder().config(config)).buildPrototype();
    }

    public static EmbeddingStoreContentRetrieverConfig create() {
        return EmbeddingStoreContentRetrieverConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, EmbeddingStoreContentRetrieverConfig>
    implements io.helidon.common.Builder<Builder, EmbeddingStoreContentRetrieverConfig> {
        private Builder() {
        }

        public EmbeddingStoreContentRetrieverConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.EmbeddingStoreContentRetrieverConfigImpl(this);
        }

        public EmbeddingStoreContentRetrieverConfig build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends EmbeddingStoreContentRetrieverConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private boolean enabled;
        private Config config;
        private Double minScore;
        private EmbeddingModel embeddingModel;
        private EmbeddingStore<TextSegment> embeddingStore;
        private Integer maxResults;
        private String displayName;

        protected BuilderBase() {
        }

        public BUILDER from(EmbeddingStoreContentRetrieverConfig prototype) {
            this.enabled(prototype.enabled());
            this.embeddingStore(prototype.embeddingStore());
            this.embeddingModel(prototype.embeddingModel());
            this.displayName(prototype.displayName());
            this.maxResults(prototype.maxResults());
            this.minScore(prototype.minScore());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.enabled(builder.enabled());
            builder.embeddingStore().ifPresent(this::embeddingStore);
            builder.embeddingModel().ifPresent(this::embeddingModel);
            builder.displayName().ifPresent(this::displayName);
            builder.maxResults().ifPresent(this::maxResults);
            builder.minScore().ifPresent(this::minScore);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("enabled").as(Boolean.class).ifPresent(this::enabled);
            config.get("display-name").as(String.class).ifPresent(this::displayName);
            config.get("max-results").as(Integer.class).ifPresent(this::maxResults);
            config.get("min-score").as(Double.class).ifPresent(this::minScore);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER enabled(boolean enabled) {
            this.enabled = enabled;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER embeddingStore(EmbeddingStore<TextSegment> embeddingStore) {
            Objects.requireNonNull(embeddingStore);
            this.embeddingStore = embeddingStore;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearEmbeddingModel() {
            this.embeddingModel = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER embeddingModel(EmbeddingModel embeddingModel) {
            Objects.requireNonNull(embeddingModel);
            this.embeddingModel = embeddingModel;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearDisplayName() {
            this.displayName = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER displayName(String displayName) {
            Objects.requireNonNull(displayName);
            this.displayName = displayName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearMaxResults() {
            this.maxResults = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER maxResults(int maxResults) {
            Objects.requireNonNull(maxResults);
            this.maxResults = maxResults;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearMinScore() {
            this.minScore = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER minScore(double minScore) {
            Objects.requireNonNull(minScore);
            this.minScore = minScore;
            return (BUILDER)((BuilderBase)this.self());
        }

        public boolean enabled() {
            return this.enabled;
        }

        public Optional<EmbeddingStore<TextSegment>> embeddingStore() {
            return Optional.ofNullable(this.embeddingStore);
        }

        public Optional<EmbeddingModel> embeddingModel() {
            return Optional.ofNullable(this.embeddingModel);
        }

        public Optional<String> displayName() {
            return Optional.ofNullable(this.displayName);
        }

        public Optional<Integer> maxResults() {
            return Optional.ofNullable(this.maxResults);
        }

        public Optional<Double> minScore() {
            return Optional.ofNullable(this.minScore);
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "EmbeddingStoreContentRetrieverConfigBuilder{enabled=" + this.enabled + ",embeddingStore=" + String.valueOf(this.embeddingStore) + ",embeddingModel=" + String.valueOf(this.embeddingModel) + ",displayName=" + this.displayName + ",maxResults=" + this.maxResults + ",minScore=" + this.minScore + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.embeddingStore == null) {
                collector.fatal(this.getClass(), "Property \"embeddingStore\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER embeddingModel(Optional<? extends EmbeddingModel> embeddingModel) {
            Objects.requireNonNull(embeddingModel);
            this.embeddingModel = embeddingModel.map(EmbeddingModel.class::cast).orElse(this.embeddingModel);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER displayName(Optional<String> displayName) {
            Objects.requireNonNull(displayName);
            this.displayName = displayName.map(String.class::cast).orElse(this.displayName);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER maxResults(Optional<Integer> maxResults) {
            Objects.requireNonNull(maxResults);
            this.maxResults = maxResults.map(Integer.class::cast).orElse(this.maxResults);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER minScore(Optional<Double> minScore) {
            Objects.requireNonNull(minScore);
            this.minScore = minScore.map(Double.class::cast).orElse(this.minScore);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class EmbeddingStoreContentRetrieverConfigImpl
        implements EmbeddingStoreContentRetrieverConfig {
            private final boolean enabled;
            private final EmbeddingStore<TextSegment> embeddingStore;
            private final Optional<EmbeddingModel> embeddingModel;
            private final Optional<Double> minScore;
            private final Optional<Integer> maxResults;
            private final Optional<String> displayName;

            protected EmbeddingStoreContentRetrieverConfigImpl(BuilderBase<?, ?> builder) {
                this.enabled = builder.enabled();
                this.embeddingStore = builder.embeddingStore().get();
                this.embeddingModel = builder.embeddingModel();
                this.displayName = builder.displayName();
                this.maxResults = builder.maxResults();
                this.minScore = builder.minScore();
            }

            @Override
            public boolean enabled() {
                return this.enabled;
            }

            @Override
            public EmbeddingStore<TextSegment> embeddingStore() {
                return this.embeddingStore;
            }

            @Override
            public Optional<EmbeddingModel> embeddingModel() {
                return this.embeddingModel;
            }

            @Override
            public Optional<String> displayName() {
                return this.displayName;
            }

            @Override
            public Optional<Integer> maxResults() {
                return this.maxResults;
            }

            @Override
            public Optional<Double> minScore() {
                return this.minScore;
            }

            public String toString() {
                return "EmbeddingStoreContentRetrieverConfig{enabled=" + this.enabled + ",embeddingStore=" + String.valueOf(this.embeddingStore) + ",embeddingModel=" + String.valueOf(this.embeddingModel) + ",displayName=" + String.valueOf(this.displayName) + ",maxResults=" + String.valueOf(this.maxResults) + ",minScore=" + String.valueOf(this.minScore) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof EmbeddingStoreContentRetrieverConfig)) {
                    return false;
                }
                EmbeddingStoreContentRetrieverConfig other = (EmbeddingStoreContentRetrieverConfig)o;
                return this.enabled == other.enabled() && Objects.equals(this.embeddingStore, other.embeddingStore()) && Objects.equals(this.embeddingModel, other.embeddingModel()) && Objects.equals(this.displayName, other.displayName()) && Objects.equals(this.maxResults, other.maxResults()) && Objects.equals(this.minScore, other.minScore());
            }

            public int hashCode() {
                return Objects.hash(this.enabled, this.embeddingStore, this.embeddingModel, this.displayName, this.maxResults, this.minScore);
            }
        }
    }
}

