/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.media.jsonb;

import io.helidon.common.GenericType;
import io.helidon.common.config.Config;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValues;
import io.helidon.http.Headers;
import io.helidon.http.HttpMediaType;
import io.helidon.http.WritableHeaders;
import io.helidon.http.media.EntityReader;
import io.helidon.http.media.EntityWriter;
import io.helidon.http.media.MediaSupport;
import io.helidon.http.media.jsonb.JsonbReader;
import io.helidon.http.media.jsonb.JsonbWriter;
import jakarta.json.JsonObject;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import java.util.Objects;

public class JsonbSupport
implements MediaSupport {
    private static final GenericType<JsonObject> JSON_OBJECT_TYPE = GenericType.create(JsonObject.class);
    private static final Jsonb JSON_B = JsonbBuilder.create();
    private final JsonbReader reader = new JsonbReader(JSON_B);
    private final JsonbWriter writer = new JsonbWriter(JSON_B);
    private final String name;

    private JsonbSupport(String name) {
        this.name = name;
    }

    public static MediaSupport create(Config config) {
        return JsonbSupport.create(config, "jsonb");
    }

    public static MediaSupport create(Config config, String name) {
        Objects.requireNonNull(config);
        Objects.requireNonNull(name);
        return new JsonbSupport(name);
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return "jsonb";
    }

    public <T> MediaSupport.ReaderResponse<T> reader(GenericType<T> type, Headers requestHeaders) {
        if (requestHeaders.contentType().map(it -> it.test(MediaTypes.APPLICATION_JSON)).orElse(true).booleanValue()) {
            if (type.equals(JSON_OBJECT_TYPE)) {
                return MediaSupport.ReaderResponse.unsupported();
            }
            return new MediaSupport.ReaderResponse(MediaSupport.SupportLevel.COMPATIBLE, this::reader);
        }
        return MediaSupport.ReaderResponse.unsupported();
    }

    public <T> MediaSupport.WriterResponse<T> writer(GenericType<T> type, Headers requestHeaders, WritableHeaders<?> responseHeaders) {
        if (JSON_OBJECT_TYPE.equals(type)) {
            return MediaSupport.WriterResponse.unsupported();
        }
        for (HttpMediaType acceptedType : requestHeaders.acceptedTypes()) {
            if (!acceptedType.test(MediaTypes.APPLICATION_JSON)) continue;
            return new MediaSupport.WriterResponse(MediaSupport.SupportLevel.COMPATIBLE, this::writer);
        }
        if (requestHeaders.acceptedTypes().isEmpty()) {
            return new MediaSupport.WriterResponse(MediaSupport.SupportLevel.COMPATIBLE, this::writer);
        }
        return MediaSupport.WriterResponse.unsupported();
    }

    public <T> MediaSupport.ReaderResponse<T> reader(GenericType<T> type, Headers requestHeaders, Headers responseHeaders) {
        if (JSON_OBJECT_TYPE.equals(type)) {
            return MediaSupport.ReaderResponse.unsupported();
        }
        for (HttpMediaType acceptedType : requestHeaders.acceptedTypes()) {
            if (!acceptedType.test(MediaTypes.APPLICATION_JSON) && !acceptedType.mediaType().isWildcardType()) continue;
            return new MediaSupport.ReaderResponse(MediaSupport.SupportLevel.COMPATIBLE, this::reader);
        }
        if (requestHeaders.acceptedTypes().isEmpty()) {
            return new MediaSupport.ReaderResponse(MediaSupport.SupportLevel.COMPATIBLE, this::reader);
        }
        return MediaSupport.ReaderResponse.unsupported();
    }

    public <T> MediaSupport.WriterResponse<T> writer(GenericType<T> type, WritableHeaders<?> requestHeaders) {
        if (type.equals(JSON_OBJECT_TYPE)) {
            return MediaSupport.WriterResponse.unsupported();
        }
        if (requestHeaders.contains(HeaderNames.CONTENT_TYPE)) {
            if (requestHeaders.contains(HeaderValues.CONTENT_TYPE_JSON)) {
                return new MediaSupport.WriterResponse(MediaSupport.SupportLevel.COMPATIBLE, this::writer);
            }
        } else {
            return new MediaSupport.WriterResponse(MediaSupport.SupportLevel.SUPPORTED, this::writer);
        }
        return MediaSupport.WriterResponse.unsupported();
    }

    <T> EntityReader<T> reader() {
        return this.reader;
    }

    <T> EntityWriter<T> writer() {
        return this.writer;
    }
}

