/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import io.helidon.http.Header;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNameEnum;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValueCopy;
import io.helidon.http.HeaderValueLazy;
import io.helidon.http.HeaderWriteable;
import io.helidon.http.Headers;
import io.helidon.http.HttpMediaType;
import io.helidon.http.IntSet;
import io.helidon.http.WritableHeaders;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Supplier;

class HeadersImpl<T extends WritableHeaders<T>>
implements WritableHeaders<T> {
    static final int KNOWN_HEADER_SIZE = HeaderNameEnum.values().length;
    private final Header[] knownHeaders = new Header[KNOWN_HEADER_SIZE];
    private IntSet knownHeaderIndices = new IntSet(KNOWN_HEADER_SIZE);
    private Map<HeaderName, Header> customHeaders = null;

    HeadersImpl() {
    }

    HeadersImpl(Headers headers) {
        for (Header header : headers) {
            this.set(header);
        }
    }

    @Override
    public List<String> all(HeaderName name, Supplier<List<String>> defaultSupplier) {
        Header headerValue = this.find(name);
        if (headerValue == null) {
            return defaultSupplier.get();
        }
        return headerValue.allValues();
    }

    @Override
    public boolean contains(HeaderName name) {
        return this.find(name) != null;
    }

    @Override
    public boolean contains(Header headerWithValue) {
        Header headerValue = this.find(headerWithValue.headerName());
        if (headerValue == null) {
            return false;
        }
        if (headerWithValue.valueCount() == 1 && headerValue.valueCount() == 1) {
            return ((String)headerWithValue.get()).equals(headerValue.get());
        }
        return headerWithValue.allValues().equals(headerValue.allValues());
    }

    @Override
    public Header get(HeaderName name) {
        Header headerValue = this.find(name);
        if (headerValue == null) {
            throw new NoSuchElementException("Header " + String.valueOf(name) + " is not present in these headers");
        }
        return headerValue;
    }

    @Override
    public int size() {
        return (this.customHeaders == null ? 0 : this.customHeaders.size()) + this.knownHeaderIndices.size();
    }

    @Override
    public List<HttpMediaType> acceptedTypes() {
        if (this.contains(HeaderNames.ACCEPT)) {
            List<String> accepts = this.get(HeaderNames.ACCEPT).allValues(true);
            ArrayList<HttpMediaType> mediaTypes = new ArrayList<HttpMediaType>(accepts.size());
            for (String accept : accepts) {
                mediaTypes.add(HttpMediaType.create(accept));
            }
            Collections.sort(mediaTypes);
            return mediaTypes;
        }
        return List.of();
    }

    @Override
    public Iterator<Header> iterator() {
        return new HeaderIterator();
    }

    @Override
    public T setIfAbsent(Header header) {
        Header found = this.find(header.headerName());
        if (found == null) {
            this.set(header);
        }
        return (T)this;
    }

    @Override
    public T add(Header header) {
        HeaderName name = header.headerName();
        Header headerValue = this.find(name);
        if (headerValue == null) {
            this.set(header);
        } else {
            HeaderWriteable hvw;
            HeaderWriteable writable = headerValue instanceof HeaderWriteable ? (hvw = (HeaderWriteable)headerValue) : HeaderWriteable.create(header);
            for (String value : header.allValues()) {
                writable.addValue(value);
            }
            this.set(writable);
        }
        return (T)this;
    }

    @Override
    public T remove(HeaderName name) {
        this.doRemove(name);
        return (T)this;
    }

    @Override
    public T remove(HeaderName name, Consumer<Header> removedConsumer) {
        Header remove = this.doRemove(name);
        if (remove != null) {
            removedConsumer.accept(remove);
        }
        return (T)this;
    }

    @Override
    public T set(Header header) {
        int index;
        HeaderName name = header.headerName();
        Header usedHeader = header;
        if (!(header instanceof HeaderValueLazy) && header instanceof HeaderWriteable) {
            usedHeader = new HeaderValueCopy(header);
        }
        if ((index = name.index()) == -1) {
            this.customHeaders().put(name, usedHeader);
        } else {
            this.knownHeaders[index] = usedHeader;
            this.knownHeaderIndices.add(index);
        }
        return (T)this;
    }

    @Override
    public T clear() {
        Arrays.fill(this.knownHeaders, null);
        this.knownHeaderIndices = new IntSet(KNOWN_HEADER_SIZE);
        this.customHeaders().clear();
        return (T)this;
    }

    @Override
    public T from(Headers headers) {
        for (Header header : headers) {
            this.set(header);
        }
        return (T)this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Header headerValue : this) {
            for (String value : headerValue.allValues()) {
                builder.append(headerValue.name()).append(": ");
                if (headerValue.sensitive()) {
                    builder.append("*".repeat(value.length()));
                } else {
                    builder.append(value);
                }
                ArrayList<String> details = new ArrayList<String>(2);
                if (headerValue.sensitive()) {
                    details.add("sensitive");
                }
                if (headerValue.changing()) {
                    details.add("changing");
                }
                if (!details.isEmpty()) {
                    builder.append(" (");
                    builder.append(String.join((CharSequence)", ", details));
                    builder.append(")");
                }
                builder.append("\n");
            }
        }
        return builder.toString();
    }

    public Header doRemove(HeaderName name) {
        if (name instanceof HeaderNameEnum) {
            int index = ((HeaderNameEnum)name).ordinal();
            Header value = this.knownHeaders[index];
            this.knownHeaders[index] = null;
            this.knownHeaderIndices.remove(index);
            return value;
        }
        return this.customHeaders().remove(name);
    }

    private Header find(HeaderName name) {
        int index = name.index();
        if (index > -1) {
            return this.knownHeaders[index];
        }
        return this.customHeaders().get(name);
    }

    private Map<HeaderName, Header> customHeaders() {
        if (this.customHeaders == null) {
            this.customHeaders = new HashMap<HeaderName, Header>();
        }
        return this.customHeaders;
    }

    private class HeaderIterator
    implements Iterator<Header> {
        private final boolean noCustom;
        private boolean inKnown;
        private int last;
        private Iterator<Header> customHeadersIterator;

        private HeaderIterator() {
            this.noCustom = HeadersImpl.this.customHeaders == null || HeadersImpl.this.customHeaders.isEmpty();
            this.inKnown = true;
            this.last = -1;
        }

        @Override
        public boolean hasNext() {
            if (this.inKnown) {
                this.last = HeadersImpl.this.knownHeaderIndices.nextSetBit(this.last + 1);
                if (this.last >= 0) {
                    return true;
                }
                this.inKnown = false;
                if (this.noCustom) {
                    return false;
                }
                this.ensureCustom();
            }
            return this.customHeadersIterator.hasNext();
        }

        @Override
        public Header next() {
            if (this.last >= 0) {
                return HeadersImpl.this.knownHeaders[this.last];
            }
            this.ensureCustom();
            return this.customHeadersIterator.next();
        }

        private void ensureCustom() {
            if (this.customHeadersIterator == null) {
                this.customHeadersIterator = HeadersImpl.this.customHeaders.values().iterator();
            }
        }
    }
}

