/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import java.util.ArrayList;
import java.util.List;

final class HeaderHelper {
    private static final char QUOTE = '\"';

    private HeaderHelper() {
    }

    public static List<String> tokenize(char separator, String text) {
        StringBuilder token = new StringBuilder();
        ArrayList<String> result = new ArrayList<String>();
        boolean quoted = false;
        char lastQuoteCharacter = ' ';
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (quoted) {
                if (ch == lastQuoteCharacter) {
                    quoted = false;
                }
                token.append(ch);
                continue;
            }
            if (ch == separator) {
                if (token.length() > 0) {
                    result.add(token.toString());
                }
                token.setLength(0);
                continue;
            }
            if (ch == '\"') {
                quoted = true;
                lastQuoteCharacter = ch;
            }
            token.append(ch);
        }
        if (token.length() > 0) {
            result.add(token.toString());
        }
        return result;
    }

    public static String unwrap(String str) {
        if (str.length() >= 2 && '\"' == str.charAt(0) && '\"' == str.charAt(str.length() - 1)) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }
}

