/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.faulttolerance;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.common.config.ConfigBuilderSupport;
import io.helidon.faulttolerance.Timeout;
import io.helidon.faulttolerance.TimeoutConfigBlueprint;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.faulttolerance.TimeoutConfigBlueprint")
public interface TimeoutConfig
extends TimeoutConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(TimeoutConfig instance) {
        return (Builder)TimeoutConfig.builder().from(instance);
    }

    public static TimeoutConfig create(Config config) {
        return ((Builder)TimeoutConfig.builder().config(config)).buildPrototype();
    }

    public static TimeoutConfig create() {
        return TimeoutConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, TimeoutConfig>
    implements io.helidon.common.Builder<Builder, Timeout> {
        private Builder() {
        }

        public TimeoutConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.TimeoutConfigImpl(this);
        }

        public Timeout build() {
            return Timeout.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends TimeoutConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private boolean currentThread = false;
        private boolean enableMetrics = false;
        private Config config;
        private Duration timeout = Duration.parse("PT10S");
        private ExecutorService executor;
        private String name;

        protected BuilderBase() {
        }

        public BUILDER from(TimeoutConfig prototype) {
            this.name(prototype.name());
            this.timeout(prototype.timeout());
            this.currentThread(prototype.currentThread());
            this.executor(prototype.executor());
            this.enableMetrics(prototype.enableMetrics());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.name().ifPresent(this::name);
            this.timeout(builder.timeout());
            this.currentThread(builder.currentThread());
            builder.executor().ifPresent(this::executor);
            this.enableMetrics(builder.enableMetrics());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("timeout").as(Duration.class).ifPresent(this::timeout);
            config.get("current-thread").as(Boolean.class).ifPresent(this::currentThread);
            config.get("enable-metrics").as(Boolean.class).ifPresent(this::enableMetrics);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearName() {
            this.name = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER timeout(Duration timeout) {
            Objects.requireNonNull(timeout);
            this.timeout = timeout;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER currentThread(boolean currentThread) {
            this.currentThread = currentThread;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearExecutor() {
            this.executor = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER executor(ExecutorService executor) {
            Objects.requireNonNull(executor);
            this.executor = executor;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER enableMetrics(boolean enableMetrics) {
            this.enableMetrics = enableMetrics;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<String> name() {
            return Optional.ofNullable(this.name);
        }

        public Duration timeout() {
            return this.timeout;
        }

        public boolean currentThread() {
            return this.currentThread;
        }

        public Optional<ExecutorService> executor() {
            return Optional.ofNullable(this.executor);
        }

        public boolean enableMetrics() {
            return this.enableMetrics;
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "TimeoutConfigBuilder{name=" + this.name + ",timeout=" + String.valueOf(this.timeout) + ",currentThread=" + this.currentThread + ",executor=" + String.valueOf(this.executor) + ",enableMetrics=" + this.enableMetrics + "}";
        }

        protected void preBuildPrototype() {
            new TimeoutConfigBlueprint.BuilderDecorator().decorate(this);
        }

        protected void validatePrototype() {
        }

        BUILDER name(Optional<String> name) {
            Objects.requireNonNull(name);
            this.name = name.map(String.class::cast).orElse(this.name);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER executor(Optional<? extends ExecutorService> executor) {
            Objects.requireNonNull(executor);
            this.executor = executor.map(ExecutorService.class::cast).orElse(this.executor);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class TimeoutConfigImpl
        implements TimeoutConfig,
        Supplier<Timeout> {
            private final boolean currentThread;
            private final boolean enableMetrics;
            private final Duration timeout;
            private final Optional<String> name;
            private final Optional<ExecutorService> executor;

            protected TimeoutConfigImpl(BuilderBase<?, ?> builder) {
                this.name = builder.name();
                this.timeout = builder.timeout();
                this.currentThread = builder.currentThread();
                this.executor = builder.executor();
                this.enableMetrics = builder.enableMetrics();
            }

            public Timeout build() {
                return Timeout.create(this);
            }

            @Override
            public Timeout get() {
                return this.build();
            }

            @Override
            public Optional<String> name() {
                return this.name;
            }

            @Override
            public Duration timeout() {
                return this.timeout;
            }

            @Override
            public boolean currentThread() {
                return this.currentThread;
            }

            @Override
            public Optional<ExecutorService> executor() {
                return this.executor;
            }

            @Override
            public boolean enableMetrics() {
                return this.enableMetrics;
            }

            public String toString() {
                return "TimeoutConfig{name=" + String.valueOf(this.name) + ",timeout=" + String.valueOf(this.timeout) + ",currentThread=" + this.currentThread + ",executor=" + String.valueOf(this.executor) + ",enableMetrics=" + this.enableMetrics + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TimeoutConfig)) {
                    return false;
                }
                TimeoutConfig other = (TimeoutConfig)o;
                return Objects.equals(this.name, other.name()) && Objects.equals(this.timeout, other.timeout()) && this.currentThread == other.currentThread() && Objects.equals(this.executor, other.executor()) && this.enableMetrics == other.enableMetrics();
            }

            public int hashCode() {
                return Objects.hash(this.name, this.timeout, this.currentThread, this.executor, this.enableMetrics);
            }
        }
    }
}

