/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.faulttolerance;

import io.helidon.builder.api.RuntimeType;
import io.helidon.common.Builder;
import io.helidon.faulttolerance.FtHandler;
import io.helidon.faulttolerance.RetryConfig;
import io.helidon.faulttolerance.RetryImpl;
import java.time.Duration;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Supplier;

@RuntimeType.PrototypedBy(value=RetryConfig.class)
public interface Retry
extends FtHandler,
RuntimeType.Api<RetryConfig> {
    public static final String FT_RETRY_CALLS_TOTAL = "ft.retry.calls.total";
    public static final String FT_RETRY_RETRIES_TOTAL = "ft.retry.retries.total";

    public static Retry create(RetryConfig retryConfig) {
        return new RetryImpl(retryConfig);
    }

    public static Retry create(Consumer<RetryConfig.Builder> builderConsumer) {
        return Retry.create(((RetryConfig.Builder)RetryConfig.builder().update(builderConsumer)).buildPrototype());
    }

    public static RetryConfig.Builder builder() {
        return RetryConfig.builder();
    }

    public long retryCounter();

    public static class JitterRetryPolicy
    implements RetryPolicy {
        private final int calls;
        private final long delayMillis;
        private final Supplier<Integer> randomJitter;

        private JitterRetryPolicy(Builder builder) {
            int jitterMillis;
            this.calls = builder.calls;
            this.delayMillis = builder.delay.toMillis();
            long jitter = builder.jitter.toMillis();
            int n = jitterMillis = jitter > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)jitter;
            if (jitterMillis == 0) {
                this.randomJitter = () -> 0;
            } else {
                Random random = new Random();
                this.randomJitter = () -> random.nextInt(jitterMillis * 2) - jitterMillis;
            }
        }

        public static Builder builder() {
            return new Builder();
        }

        @Override
        public Optional<Long> nextDelayMillis(long firstCallNanos, long lastDelay, int call) {
            if (call >= this.calls) {
                return Optional.empty();
            }
            long delay = this.delayMillis;
            int jitterRandom = this.randomJitter.get();
            delay += (long)jitterRandom;
            delay = Math.max(0L, delay);
            return Optional.of(delay);
        }

        public static class Builder
        implements io.helidon.common.Builder<Builder, JitterRetryPolicy> {
            private int calls = 3;
            private Duration delay = Duration.ofMillis(200L);
            private Duration jitter = Duration.ofMillis(50L);

            private Builder() {
            }

            public JitterRetryPolicy build() {
                return new JitterRetryPolicy(this);
            }

            public Builder calls(int calls) {
                this.calls = calls;
                return this;
            }

            public Builder delay(Duration delay) {
                this.delay = delay;
                return this;
            }

            public Builder jitter(Duration jitter) {
                this.jitter = jitter;
                return this;
            }
        }
    }

    public static class DelayingRetryPolicy
    implements RetryPolicy {
        private final int calls;
        private final long delayMillis;
        private final double delayFactor;

        private DelayingRetryPolicy(Builder builder) {
            this.calls = builder.calls;
            this.delayMillis = builder.delay.toMillis();
            this.delayFactor = builder.delayFactor;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static DelayingRetryPolicy noDelay(int calls) {
            return DelayingRetryPolicy.builder().delay(Duration.ZERO).delayFactor(0.0).calls(calls).build();
        }

        @Override
        public Optional<Long> nextDelayMillis(long firstCallMillis, long lastDelay, int call) {
            if (call >= this.calls) {
                return Optional.empty();
            }
            if (call == 0 || lastDelay == 0L) {
                return Optional.of(this.delayMillis);
            }
            return Optional.of((long)((double)lastDelay * this.delayFactor));
        }

        public static class Builder
        implements io.helidon.common.Builder<Builder, DelayingRetryPolicy> {
            private int calls = 3;
            private double delayFactor = 2.0;
            private Duration delay = Duration.ofMillis(200L);

            private Builder() {
            }

            public DelayingRetryPolicy build() {
                return new DelayingRetryPolicy(this);
            }

            public Builder calls(int calls) {
                this.calls = calls;
                return this;
            }

            public Builder delay(Duration delay) {
                this.delay = delay;
                return this;
            }

            public Builder delayFactor(double delayFactor) {
                this.delayFactor = delayFactor;
                return this;
            }
        }
    }

    public static interface RetryPolicy {
        public Optional<Long> nextDelayMillis(long var1, long var3, int var5);
    }
}

