/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.faulttolerance;

import io.helidon.common.LazyValue;
import io.helidon.config.Config;
import io.helidon.faulttolerance.FaultTolerance;
import io.helidon.metrics.api.Counter;
import io.helidon.metrics.api.Gauge;
import io.helidon.metrics.api.Meter;
import io.helidon.metrics.api.MeterRegistry;
import io.helidon.metrics.api.Metrics;
import io.helidon.metrics.api.MetricsFactory;
import io.helidon.metrics.api.Tag;
import io.helidon.metrics.api.Timer;
import java.util.List;
import java.util.function.Supplier;

class MetricsUtils {
    private static final LazyValue<MetricsFactory> METRICS_FACTORY = LazyValue.create(MetricsFactory::getInstance);
    private static final LazyValue<MeterRegistry> METRICS_REGISTRY = LazyValue.create(Metrics::globalRegistry);
    private static volatile Boolean defaultEnabled;

    private MetricsUtils() {
    }

    static boolean defaultEnabled() {
        if (defaultEnabled == null) {
            Config config = FaultTolerance.config();
            defaultEnabled = (Boolean)config.get("ft.metrics.default-enabled").asBoolean().orElse((Object)false);
        }
        return defaultEnabled;
    }

    static <T extends Number> void gaugeBuilder(String name, Supplier<T> supplier, Tag ... tags) {
        Gauge.Builder builder = (Gauge.Builder)((MetricsFactory)METRICS_FACTORY.get()).gaugeBuilder(name, supplier).scope("vendor");
        List<Tag> tagList = List.of(tags);
        builder.tags(tagList);
        ((MeterRegistry)METRICS_REGISTRY.get()).getOrCreate((Meter.Builder)builder);
        ((MeterRegistry)METRICS_REGISTRY.get()).gauge(name, tagList).orElseThrow();
    }

    static Counter counterBuilder(String name, Tag ... tags) {
        Counter.Builder builder = (Counter.Builder)((MetricsFactory)METRICS_FACTORY.get()).counterBuilder(name).scope("vendor");
        List<Tag> tagList = List.of(tags);
        builder.tags(tagList);
        ((MeterRegistry)METRICS_REGISTRY.get()).getOrCreate((Meter.Builder)builder);
        return (Counter)((MeterRegistry)METRICS_REGISTRY.get()).counter(name, tagList).orElseThrow();
    }

    static Timer timerBuilder(String name, Tag ... tags) {
        Timer.Builder builder = (Timer.Builder)((MetricsFactory)METRICS_FACTORY.get()).timerBuilder(name).scope("vendor");
        List<Tag> tagList = List.of(tags);
        builder.tags(tagList);
        ((MeterRegistry)METRICS_REGISTRY.get()).getOrCreate((Meter.Builder)builder);
        return (Timer)((MeterRegistry)METRICS_REGISTRY.get()).timer(name, tagList).orElseThrow();
    }

    static <T extends Number> Gauge<T> gauge(String name, Tag ... tags) {
        return (Gauge)((MeterRegistry)METRICS_REGISTRY.get()).gauge(name, List.of(tags)).orElseThrow();
    }

    static Counter counter(String name, Tag ... tags) {
        return (Counter)((MeterRegistry)METRICS_REGISTRY.get()).counter(name, List.of(tags)).orElseThrow();
    }

    static Timer timer(String name, Tag ... tags) {
        return (Timer)((MeterRegistry)METRICS_REGISTRY.get()).timer(name, List.of(tags)).orElseThrow();
    }
}

