/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.faulttolerance;

import io.helidon.faulttolerance.Async;
import io.helidon.faulttolerance.AsyncConfig;
import io.helidon.faulttolerance.FaultTolerance;
import io.helidon.faulttolerance.SupplierHelper;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

class AsyncImpl
implements Async {
    private static final System.Logger LOGGER = System.getLogger(AsyncImpl.class.getName());
    private final ExecutorService executor;
    private final CompletableFuture<Async> onStart;
    private final AsyncConfig config;

    AsyncImpl(AsyncConfig config) {
        this.executor = config.executor().orElseGet(() -> (ExecutorService)FaultTolerance.executor().get());
        this.onStart = config.onStart().orElseGet(CompletableFuture::new);
        this.config = config;
    }

    public AsyncConfig prototype() {
        return this.config;
    }

    @Override
    public <T> CompletableFuture<T> invoke(Supplier<T> supplier) {
        final AtomicReference ourFuture = new AtomicReference();
        CompletableFuture result = new CompletableFuture<T>(this){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                Future toCancel = (Future)ourFuture.get();
                if (toCancel == null) {
                    LOGGER.log(System.Logger.Level.WARNING, "Failed to cancel future, it is not yet available.");
                    return false;
                }
                return toCancel.cancel(mayInterruptIfRunning);
            }
        };
        Future<?> future = this.executor.submit(() -> {
            Thread thread = Thread.currentThread();
            thread.setName(thread.getName() + ": async");
            if (this.onStart != null) {
                this.onStart.complete(this);
            }
            try {
                Object t = supplier.get();
                result.complete(t);
            }
            catch (Throwable t) {
                Throwable throwable = SupplierHelper.unwrapThrowable(t);
                result.completeExceptionally(throwable);
            }
        });
        ourFuture.set(future);
        return result;
    }
}

