/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.testing.junit5;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class InMemoryLoggingHandler
extends Handler
implements AutoCloseable {
    private final Logger logger;
    private final List<LogRecord> logRecords = new ArrayList<LogRecord>();
    private final List<LogRecord> unmodifiableLogRecords = Collections.unmodifiableList(this.logRecords);

    public static InMemoryLoggingHandler create(Logger logger) {
        return new InMemoryLoggingHandler(logger);
    }

    public static InMemoryLoggingHandler create(Object objectWithNamedLogger) {
        return InMemoryLoggingHandler.create(Logger.getLogger(objectWithNamedLogger.getClass().getName()));
    }

    private InMemoryLoggingHandler(Logger logger) {
        this.logger = logger;
        logger.addHandler(this);
    }

    @Override
    public void publish(LogRecord record) {
        this.logRecords.add(record);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
        this.logRecords.clear();
        this.logger.removeHandler(this);
    }

    public List<LogRecord> logRecords() {
        return this.unmodifiableLogRecords;
    }
}

