/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.buffers;

import io.helidon.common.buffers.BufferData;
import io.helidon.common.buffers.BufferUtil;
import io.helidon.common.buffers.ReadOnlyBufferData;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

class ReadOnlyArrayData
extends ReadOnlyBufferData {
    private final byte[] bytes;
    private final int offset;
    private final int length;
    private int position;

    ReadOnlyArrayData(byte[] bytes, int offset, int length) {
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
        this.position = 0;
    }

    @Override
    public BufferData rewind() {
        this.position = 0;
        return this;
    }

    @Override
    public void writeTo(OutputStream out) {
        try {
            out.write(this.bytes, this.offset + this.position, this.length);
            this.position = this.length;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public int readFrom(InputStream in) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read() {
        if (this.position >= this.length) {
            throw new ArrayIndexOutOfBoundsException("This buffer has " + this.length + " bytes, requested to read at " + this.position);
        }
        return this.bytes[this.offset + this.position++] & 0xFF;
    }

    @Override
    public int read(byte[] bytes, int position, int length) {
        int available = this.length - this.position;
        int toRead = Math.min(length, available);
        System.arraycopy(this.bytes, this.offset + this.position, bytes, position, toRead);
        this.position += toRead;
        return toRead;
    }

    @Override
    public String readString(int length, Charset charset) {
        String result = new String(this.bytes, this.offset + this.position, length, charset);
        this.position += length;
        return result;
    }

    @Override
    public boolean consumed() {
        return this.position == this.length;
    }

    @Override
    public int writeTo(ByteBuffer writeBuffer, int length) {
        int toWrite = Math.min(writeBuffer.limit() - writeBuffer.position(), this.length - this.position);
        if ((toWrite = Math.min(toWrite, length)) == 0) {
            return 0;
        }
        writeBuffer.put(this.bytes, this.offset + this.position, toWrite);
        this.position += toWrite;
        return toWrite;
    }

    @Override
    public String debugDataBinary() {
        return BufferUtil.debugDataBinary(this.bytes, this.offset + this.position, this.length - this.position);
    }

    @Override
    public String debugDataHex(boolean fullBuffer) {
        if (fullBuffer) {
            return BufferUtil.debugDataHex(this.bytes, this.offset, this.offset + this.length);
        }
        return BufferUtil.debugDataHex(this.bytes, this.offset + this.position, this.offset + this.length - this.position);
    }

    @Override
    public int available() {
        return this.length - this.position;
    }

    @Override
    public void skip(int length) {
        this.position = Math.min(this.length, this.position + length);
    }

    @Override
    public int indexOf(byte aByte) {
        for (int i = this.position; i < this.length; ++i) {
            if (aByte != this.bytes[this.offset + i]) continue;
            return i - this.position;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(byte aByte, int length) {
        for (int i = length - 1; i >= this.position; --i) {
            byte b = this.bytes[this.offset + i];
            if (b != aByte) continue;
            return i - this.position;
        }
        return -1;
    }

    @Override
    public BufferData trim(int x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int get(int index) {
        return this.bytes[this.offset + this.position + index] & 0xFF;
    }
}

