/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.security.certprovider;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.Status;
import io.grpc.xds.internal.security.certprovider.CertificateProvider;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class IgnoreUpdatesWatcher
implements CertificateProvider.Watcher {
    private final CertificateProvider.Watcher delegate;
    private final boolean ignoreRootCertUpdates;

    public IgnoreUpdatesWatcher(CertificateProvider.Watcher delegate, boolean ignoreRootCertUpdates) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.ignoreRootCertUpdates = ignoreRootCertUpdates;
    }

    @Override
    public void updateCertificate(PrivateKey key, List<X509Certificate> certChain) {
        if (this.ignoreRootCertUpdates) {
            this.delegate.updateCertificate(key, certChain);
        }
    }

    @Override
    public void updateTrustedRoots(List<X509Certificate> trustedRoots) {
        if (!this.ignoreRootCertUpdates) {
            this.delegate.updateTrustedRoots(trustedRoots);
        }
    }

    @Override
    public void updateSpiffeTrustMap(Map<String, List<X509Certificate>> spiffeTrustMap) {
        if (!this.ignoreRootCertUpdates) {
            this.delegate.updateSpiffeTrustMap(spiffeTrustMap);
        }
    }

    @Override
    public void onError(Status errorStatus) {
        this.delegate.onError(errorStatus);
    }

    @VisibleForTesting
    public CertificateProvider.Watcher getDelegate() {
        return this.delegate;
    }
}

