/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.grpc.Internal;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.ServiceConfigUtil;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.ClusterResolverLoadBalancer;
import io.grpc.xds.EnvoyServerProtoData;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@Internal
public final class ClusterResolverLoadBalancerProvider
extends LoadBalancerProvider {
    public boolean isAvailable() {
        return true;
    }

    public int getPriority() {
        return 5;
    }

    public String getPolicyName() {
        return "cluster_resolver_experimental";
    }

    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLoadBalancingPolicyConfig) {
        return NameResolver.ConfigOrError.fromError((Status)Status.INTERNAL.withDescription(this.getPolicyName() + " cannot be used from service config"));
    }

    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new ClusterResolverLoadBalancer(helper);
    }

    static final class ClusterResolverConfig {
        final List<DiscoveryMechanism> discoveryMechanisms;
        final ServiceConfigUtil.PolicySelection lbPolicy;

        ClusterResolverConfig(List<DiscoveryMechanism> discoveryMechanisms, ServiceConfigUtil.PolicySelection lbPolicy) {
            this.discoveryMechanisms = (List)Preconditions.checkNotNull(discoveryMechanisms, (Object)"discoveryMechanisms");
            this.lbPolicy = (ServiceConfigUtil.PolicySelection)Preconditions.checkNotNull((Object)lbPolicy, (Object)"lbPolicy");
        }

        public int hashCode() {
            return Objects.hash(this.discoveryMechanisms, this.lbPolicy);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClusterResolverConfig that = (ClusterResolverConfig)o;
            return this.discoveryMechanisms.equals(that.discoveryMechanisms) && this.lbPolicy.equals((Object)that.lbPolicy);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("discoveryMechanisms", this.discoveryMechanisms).add("lbPolicy", (Object)this.lbPolicy).toString();
        }

        static final class DiscoveryMechanism {
            final String cluster;
            final Type type;
            @Nullable
            final Bootstrapper.ServerInfo lrsServerInfo;
            @Nullable
            final Long maxConcurrentRequests;
            @Nullable
            final EnvoyServerProtoData.UpstreamTlsContext tlsContext;
            @Nullable
            final String edsServiceName;
            @Nullable
            final String dnsHostName;
            @Nullable
            final EnvoyServerProtoData.OutlierDetection outlierDetection;

            private DiscoveryMechanism(String cluster, Type type, @Nullable String edsServiceName, @Nullable String dnsHostName, @Nullable Bootstrapper.ServerInfo lrsServerInfo, @Nullable Long maxConcurrentRequests, @Nullable EnvoyServerProtoData.UpstreamTlsContext tlsContext, @Nullable EnvoyServerProtoData.OutlierDetection outlierDetection) {
                this.cluster = (String)Preconditions.checkNotNull((Object)cluster, (Object)"cluster");
                this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type"));
                this.edsServiceName = edsServiceName;
                this.dnsHostName = dnsHostName;
                this.lrsServerInfo = lrsServerInfo;
                this.maxConcurrentRequests = maxConcurrentRequests;
                this.tlsContext = tlsContext;
                this.outlierDetection = outlierDetection;
            }

            static DiscoveryMechanism forEds(String cluster, @Nullable String edsServiceName, @Nullable Bootstrapper.ServerInfo lrsServerInfo, @Nullable Long maxConcurrentRequests, @Nullable EnvoyServerProtoData.UpstreamTlsContext tlsContext, EnvoyServerProtoData.OutlierDetection outlierDetection) {
                return new DiscoveryMechanism(cluster, Type.EDS, edsServiceName, null, lrsServerInfo, maxConcurrentRequests, tlsContext, outlierDetection);
            }

            static DiscoveryMechanism forLogicalDns(String cluster, String dnsHostName, @Nullable Bootstrapper.ServerInfo lrsServerInfo, @Nullable Long maxConcurrentRequests, @Nullable EnvoyServerProtoData.UpstreamTlsContext tlsContext) {
                return new DiscoveryMechanism(cluster, Type.LOGICAL_DNS, null, dnsHostName, lrsServerInfo, maxConcurrentRequests, tlsContext, null);
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.cluster, this.type, this.lrsServerInfo, this.maxConcurrentRequests, this.tlsContext, this.edsServiceName, this.dnsHostName});
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                DiscoveryMechanism that = (DiscoveryMechanism)o;
                return this.cluster.equals(that.cluster) && this.type == that.type && Objects.equals(this.edsServiceName, that.edsServiceName) && Objects.equals(this.dnsHostName, that.dnsHostName) && Objects.equals(this.lrsServerInfo, that.lrsServerInfo) && Objects.equals(this.maxConcurrentRequests, that.maxConcurrentRequests) && Objects.equals(this.tlsContext, that.tlsContext);
            }

            public String toString() {
                MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this).add("cluster", (Object)this.cluster).add("type", (Object)this.type).add("edsServiceName", (Object)this.edsServiceName).add("dnsHostName", (Object)this.dnsHostName).add("lrsServerInfo", (Object)this.lrsServerInfo).add("maxConcurrentRequests", (Object)this.maxConcurrentRequests);
                return toStringHelper.toString();
            }

            static enum Type {
                EDS,
                LOGICAL_DNS;

            }
        }
    }
}

