/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.grpc.Internal;
import io.grpc.xds.HttpConnectionManager;
import io.grpc.xds.TlsContextManager;
import io.grpc.xds.internal.sds.SslContextProviderSupplier;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CommonTlsContext;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@Internal
public final class EnvoyServerProtoData {
    private EnvoyServerProtoData() {
    }

    public static final class Listener {
        private final String name;
        @Nullable
        private final String address;
        private final List<FilterChain> filterChains;
        @Nullable
        private final FilterChain defaultFilterChain;

        public Listener(String name, @Nullable String address, List<FilterChain> filterChains, @Nullable FilterChain defaultFilterChain) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            this.address = address;
            this.filterChains = Collections.unmodifiableList((List)Preconditions.checkNotNull(filterChains, (Object)"filterChains"));
            this.defaultFilterChain = defaultFilterChain;
        }

        public String getName() {
            return this.name;
        }

        @Nullable
        public String getAddress() {
            return this.address;
        }

        public List<FilterChain> getFilterChains() {
            return this.filterChains;
        }

        @Nullable
        public FilterChain getDefaultFilterChain() {
            return this.defaultFilterChain;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Listener listener = (Listener)o;
            return Objects.equals(this.name, listener.name) && Objects.equals(this.address, listener.address) && Objects.equals(this.filterChains, listener.filterChains) && Objects.equals(this.defaultFilterChain, listener.defaultFilterChain);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.address, this.filterChains, this.defaultFilterChain);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("address", (Object)this.address).add("filterChains", this.filterChains).add("defaultFilterChain", (Object)this.defaultFilterChain).toString();
        }
    }

    static final class FilterChain {
        private final String name;
        private final FilterChainMatch filterChainMatch;
        private final HttpConnectionManager httpConnectionManager;
        @Nullable
        private final SslContextProviderSupplier sslContextProviderSupplier;

        FilterChain(String name, FilterChainMatch filterChainMatch, HttpConnectionManager httpConnectionManager, @Nullable DownstreamTlsContext downstreamTlsContext, TlsContextManager tlsContextManager) {
            SslContextProviderSupplier sslContextProviderSupplier1 = downstreamTlsContext == null ? null : new SslContextProviderSupplier(downstreamTlsContext, tlsContextManager);
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            this.filterChainMatch = filterChainMatch;
            this.sslContextProviderSupplier = sslContextProviderSupplier1;
            this.httpConnectionManager = (HttpConnectionManager)Preconditions.checkNotNull((Object)httpConnectionManager, (Object)"httpConnectionManager");
        }

        String getName() {
            return this.name;
        }

        public FilterChainMatch getFilterChainMatch() {
            return this.filterChainMatch;
        }

        HttpConnectionManager getHttpConnectionManager() {
            return this.httpConnectionManager;
        }

        @Nullable
        public SslContextProviderSupplier getSslContextProviderSupplier() {
            return this.sslContextProviderSupplier;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FilterChain that = (FilterChain)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.filterChainMatch, that.filterChainMatch) && Objects.equals(this.httpConnectionManager, that.httpConnectionManager) && Objects.equals(this.sslContextProviderSupplier, that.sslContextProviderSupplier);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.filterChainMatch, this.httpConnectionManager, this.sslContextProviderSupplier);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("filterChainMatch", (Object)this.filterChainMatch).add("httpConnectionManager", (Object)this.httpConnectionManager).add("sslContextProviderSupplier", (Object)this.sslContextProviderSupplier).toString();
        }
    }

    static final class FilterChainMatch {
        private final int destinationPort;
        private final List<CidrRange> prefixRanges;
        private final List<String> applicationProtocols;
        private final List<CidrRange> sourcePrefixRanges;
        private final ConnectionSourceType sourceType;
        private final List<Integer> sourcePorts;
        private final List<String> serverNames;
        private final String transportProtocol;

        @VisibleForTesting
        FilterChainMatch(int destinationPort, List<CidrRange> prefixRanges, List<String> applicationProtocols, List<CidrRange> sourcePrefixRanges, ConnectionSourceType sourceType, List<Integer> sourcePorts, List<String> serverNames, String transportProtocol) {
            this.destinationPort = destinationPort;
            this.prefixRanges = Collections.unmodifiableList(prefixRanges);
            this.applicationProtocols = Collections.unmodifiableList(applicationProtocols);
            this.sourcePrefixRanges = sourcePrefixRanges;
            this.sourceType = sourceType;
            this.sourcePorts = sourcePorts;
            this.serverNames = Collections.unmodifiableList(serverNames);
            this.transportProtocol = transportProtocol;
        }

        public int getDestinationPort() {
            return this.destinationPort;
        }

        public List<CidrRange> getPrefixRanges() {
            return this.prefixRanges;
        }

        public List<String> getApplicationProtocols() {
            return this.applicationProtocols;
        }

        public List<CidrRange> getSourcePrefixRanges() {
            return this.sourcePrefixRanges;
        }

        public ConnectionSourceType getConnectionSourceType() {
            return this.sourceType;
        }

        public List<Integer> getSourcePorts() {
            return this.sourcePorts;
        }

        public List<String> getServerNames() {
            return this.serverNames;
        }

        public String getTransportProtocol() {
            return this.transportProtocol;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FilterChainMatch that = (FilterChainMatch)o;
            return this.destinationPort == that.destinationPort && Objects.equals(this.prefixRanges, that.prefixRanges) && Objects.equals(this.applicationProtocols, that.applicationProtocols) && Objects.equals(this.sourcePrefixRanges, that.sourcePrefixRanges) && this.sourceType == that.sourceType && Objects.equals(this.sourcePorts, that.sourcePorts) && Objects.equals(this.serverNames, that.serverNames) && Objects.equals(this.transportProtocol, that.transportProtocol);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.destinationPort, this.prefixRanges, this.applicationProtocols, this.sourcePrefixRanges, this.sourceType, this.sourcePorts, this.serverNames, this.transportProtocol});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("destinationPort", this.destinationPort).add("prefixRanges", this.prefixRanges).add("applicationProtocols", this.applicationProtocols).add("sourcePrefixRanges", this.sourcePrefixRanges).add("sourceType", (Object)this.sourceType).add("sourcePorts", this.sourcePorts).add("serverNames", this.serverNames).add("transportProtocol", (Object)this.transportProtocol).toString();
        }
    }

    static enum ConnectionSourceType {
        ANY,
        SAME_IP_OR_LOOPBACK,
        EXTERNAL;

    }

    static final class CidrRange {
        private final InetAddress addressPrefix;
        private final int prefixLen;

        CidrRange(String addressPrefix, int prefixLen) throws UnknownHostException {
            this.addressPrefix = InetAddress.getByName(addressPrefix);
            this.prefixLen = prefixLen;
        }

        public InetAddress getAddressPrefix() {
            return this.addressPrefix;
        }

        public int getPrefixLen() {
            return this.prefixLen;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CidrRange cidrRange = (CidrRange)o;
            return this.prefixLen == cidrRange.prefixLen && Objects.equals(this.addressPrefix, cidrRange.addressPrefix);
        }

        public int hashCode() {
            return Objects.hash(this.addressPrefix, this.prefixLen);
        }

        public String toString() {
            return "CidrRange{addressPrefix='" + this.addressPrefix + '\'' + ", prefixLen=" + this.prefixLen + '}';
        }
    }

    public static final class DownstreamTlsContext
    extends BaseTlsContext {
        private final boolean requireClientCertificate;

        @VisibleForTesting
        public DownstreamTlsContext(CommonTlsContext commonTlsContext, boolean requireClientCertificate) {
            super(commonTlsContext);
            this.requireClientCertificate = requireClientCertificate;
        }

        public static DownstreamTlsContext fromEnvoyProtoDownstreamTlsContext(io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.DownstreamTlsContext downstreamTlsContext) {
            return new DownstreamTlsContext(downstreamTlsContext.getCommonTlsContext(), downstreamTlsContext.hasRequireClientCertificate());
        }

        public boolean isRequireClientCertificate() {
            return this.requireClientCertificate;
        }

        public String toString() {
            return "DownstreamTlsContext{commonTlsContext=" + this.commonTlsContext + ", requireClientCertificate=" + this.requireClientCertificate + '}';
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DownstreamTlsContext that = (DownstreamTlsContext)o;
            return this.requireClientCertificate == that.requireClientCertificate;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.requireClientCertificate);
        }
    }

    public static final class UpstreamTlsContext
    extends BaseTlsContext {
        @VisibleForTesting
        public UpstreamTlsContext(CommonTlsContext commonTlsContext) {
            super(commonTlsContext);
        }

        public static UpstreamTlsContext fromEnvoyProtoUpstreamTlsContext(io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.UpstreamTlsContext upstreamTlsContext) {
            return new UpstreamTlsContext(upstreamTlsContext.getCommonTlsContext());
        }

        public String toString() {
            return "UpstreamTlsContext{commonTlsContext=" + this.commonTlsContext + '}';
        }
    }

    public static abstract class BaseTlsContext {
        @Nullable
        protected final CommonTlsContext commonTlsContext;

        protected BaseTlsContext(@Nullable CommonTlsContext commonTlsContext) {
            this.commonTlsContext = commonTlsContext;
        }

        @Nullable
        public CommonTlsContext getCommonTlsContext() {
            return this.commonTlsContext;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BaseTlsContext)) {
                return false;
            }
            BaseTlsContext that = (BaseTlsContext)o;
            return Objects.equals(this.commonTlsContext, that.commonTlsContext);
        }

        public int hashCode() {
            return Objects.hashCode(this.commonTlsContext);
        }
    }
}

