/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.servlet;

import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import io.grpc.Attributes;
import io.grpc.ExperimentalApi;
import io.grpc.Grpc;
import io.grpc.InternalLogId;
import io.grpc.InternalMetadata;
import io.grpc.Metadata;
import io.grpc.ServerStreamTracer;
import io.grpc.Status;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ReadableBuffers;
import io.grpc.internal.ServerStream;
import io.grpc.internal.ServerTransportListener;
import io.grpc.internal.StatsTraceContext;
import io.grpc.servlet.ServletServerStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/5066")
public final class ServletAdapter {
    static final Logger logger = Logger.getLogger(ServletAdapter.class.getName());
    private final ServerTransportListener transportListener;
    private final List<? extends ServerStreamTracer.Factory> streamTracerFactories;
    private final int maxInboundMessageSize;
    private final Attributes attributes;

    ServletAdapter(ServerTransportListener transportListener, List<? extends ServerStreamTracer.Factory> streamTracerFactories, int maxInboundMessageSize) {
        this.transportListener = transportListener;
        this.streamTracerFactories = streamTracerFactories;
        this.maxInboundMessageSize = maxInboundMessageSize;
        this.attributes = transportListener.transportReady(Attributes.EMPTY);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.sendError(405, "GET method not supported");
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Long timeoutNanos;
        Preconditions.checkArgument((boolean)req.isAsyncSupported(), (Object)"servlet does not support asynchronous operation");
        Preconditions.checkArgument((boolean)ServletAdapter.isGrpc(req), (Object)"the request is not a gRPC request");
        InternalLogId logId = InternalLogId.allocate(ServletAdapter.class, null);
        logger.log(Level.FINE, "[{0}] RPC started", logId);
        AsyncContext asyncCtx = req.startAsync((ServletRequest)req, (ServletResponse)resp);
        String method = req.getRequestURI().substring(1);
        Metadata headers = ServletAdapter.getHeaders(req);
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "[{0}] method: {1}", new Object[]{logId, method});
            logger.log(Level.FINEST, "[{0}] headers: {1}", new Object[]{logId, headers});
        }
        if ((timeoutNanos = (Long)headers.get(GrpcUtil.TIMEOUT_KEY)) == null) {
            timeoutNanos = 0L;
        }
        asyncCtx.setTimeout(TimeUnit.NANOSECONDS.toMillis(timeoutNanos));
        StatsTraceContext statsTraceCtx = StatsTraceContext.newServerContext(this.streamTracerFactories, (String)method, (Metadata)headers);
        ServletServerStream stream = new ServletServerStream(asyncCtx, statsTraceCtx, this.maxInboundMessageSize, this.attributes.toBuilder().set(Grpc.TRANSPORT_ATTR_REMOTE_ADDR, (Object)new InetSocketAddress(req.getRemoteHost(), req.getRemotePort())).set(Grpc.TRANSPORT_ATTR_LOCAL_ADDR, (Object)new InetSocketAddress(req.getLocalAddr(), req.getLocalPort())).build(), ServletAdapter.getAuthority(req), logId);
        this.transportListener.streamCreated((ServerStream)stream, method, headers);
        stream.transportState().runOnTransportThread(() -> ServletAdapter.lambda$doPost$0(stream.transportState()));
        asyncCtx.getRequest().getInputStream().setReadListener((ReadListener)new GrpcReadListener(stream, asyncCtx, logId));
        asyncCtx.addListener((AsyncListener)new GrpcAsyncListener(stream, logId));
    }

    private static Metadata getHeaders(HttpServletRequest req) {
        Enumeration headerNames = req.getHeaderNames();
        Preconditions.checkNotNull((Object)headerNames, (Object)"Servlet container does not allow HttpServletRequest.getHeaderNames()");
        ArrayList<byte[]> byteArrays = new ArrayList<byte[]>();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            Enumeration values = req.getHeaders(headerName);
            if (values == null) continue;
            while (values.hasMoreElements()) {
                String value = (String)values.nextElement();
                if (headerName.endsWith("-bin")) {
                    byteArrays.add(headerName.getBytes(StandardCharsets.US_ASCII));
                    byteArrays.add(BaseEncoding.base64().decode((CharSequence)value));
                    continue;
                }
                byteArrays.add(headerName.getBytes(StandardCharsets.US_ASCII));
                byteArrays.add(value.getBytes(StandardCharsets.US_ASCII));
            }
        }
        return InternalMetadata.newMetadata((byte[][])((byte[][])byteArrays.toArray((T[])new byte[0][])));
    }

    private static String getAuthority(HttpServletRequest req) {
        try {
            return new URI(req.getRequestURL().toString()).getAuthority();
        }
        catch (URISyntaxException e) {
            logger.log(Level.FINE, "Error getting authority from the request URL {0}", req.getRequestURL());
            return req.getServerName() + ":" + req.getServerPort();
        }
    }

    public void destroy() {
        this.transportListener.transportTerminated();
    }

    public static boolean isGrpc(HttpServletRequest request) {
        return request.getContentType() != null && request.getContentType().contains("application/grpc");
    }

    private static /* synthetic */ void lambda$doPost$0(ServletServerStream.ServletTransportState rec$) {
        rec$.onStreamAllocated();
    }

    private static final class GrpcReadListener
    implements ReadListener {
        final ServletServerStream stream;
        final AsyncContext asyncCtx;
        final ServletInputStream input;
        final InternalLogId logId;
        final byte[] buffer = new byte[4096];

        GrpcReadListener(ServletServerStream stream, AsyncContext asyncCtx, InternalLogId logId) throws IOException {
            this.stream = stream;
            this.asyncCtx = asyncCtx;
            this.input = asyncCtx.getRequest().getInputStream();
            this.logId = logId;
        }

        public void onDataAvailable() throws IOException {
            logger.log(Level.FINEST, "[{0}] onDataAvailable: ENTRY", this.logId);
            while (this.input.isReady()) {
                int length = this.input.read(this.buffer);
                if (length == -1) {
                    logger.log(Level.FINEST, "[{0}] inbound data: read end of stream", this.logId);
                    return;
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "[{0}] inbound data: length = {1}, bytes = {2}", new Object[]{this.logId, length, ServletServerStream.toHexString(this.buffer, length)});
                }
                byte[] copy = Arrays.copyOf(this.buffer, length);
                this.stream.transportState().runOnTransportThread(() -> this.stream.transportState().inboundDataReceived(ReadableBuffers.wrap((byte[])copy), false));
            }
            logger.log(Level.FINEST, "[{0}] onDataAvailable: EXIT", this.logId);
        }

        public void onAllDataRead() {
            logger.log(Level.FINE, "[{0}] onAllDataRead", this.logId);
            this.stream.transportState().runOnTransportThread(() -> this.stream.transportState().inboundDataReceived(ReadableBuffers.empty(), true));
        }

        public void onError(Throwable t) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, String.format("[{%s}] Error: ", this.logId), t);
            }
            if (!this.asyncCtx.getResponse().isCommitted()) {
                this.stream.cancel(Status.fromThrowable((Throwable)t));
            } else {
                this.stream.transportState().runOnTransportThread(() -> this.stream.transportState().transportReportStatus(Status.fromThrowable((Throwable)t)));
            }
        }
    }

    private static final class GrpcAsyncListener
    implements AsyncListener {
        final InternalLogId logId;
        final ServletServerStream stream;

        GrpcAsyncListener(ServletServerStream stream, InternalLogId logId) {
            this.stream = stream;
            this.logId = logId;
        }

        public void onComplete(AsyncEvent event) {
        }

        public void onTimeout(AsyncEvent event) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, String.format("[{%s}] Timeout: ", this.logId), event.getThrowable());
            }
            if (!event.getAsyncContext().getResponse().isCommitted()) {
                this.stream.cancel(Status.DEADLINE_EXCEEDED);
            } else {
                this.stream.transportState().runOnTransportThread(() -> this.stream.transportState().transportReportStatus(Status.DEADLINE_EXCEEDED));
            }
        }

        public void onError(AsyncEvent event) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, String.format("[{%s}] Error: ", this.logId), event.getThrowable());
            }
            if (!event.getAsyncContext().getResponse().isCommitted()) {
                this.stream.cancel(Status.fromThrowable((Throwable)event.getThrowable()));
            } else {
                this.stream.transportState().runOnTransportThread(() -> this.stream.transportState().transportReportStatus(Status.fromThrowable((Throwable)event.getThrowable())));
            }
        }

        public void onStartAsync(AsyncEvent event) {
        }
    }
}

