/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.rls;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.grpc.ChannelLogger;
import io.grpc.ConnectivityState;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.LoadBalancerRegistry;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.ObjectPool;
import io.grpc.rls.ChildLoadBalancerHelper;
import io.grpc.rls.ResolvedAddressFactory;
import io.grpc.rls.RlsProtoData;
import io.grpc.util.ForwardingLoadBalancerHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

final class LbPolicyConfiguration {
    private final RlsProtoData.RouteLookupConfig routeLookupConfig;
    @Nullable
    private final Map<String, ?> routeLookupChannelServiceConfig;
    private final ChildLoadBalancingPolicy policy;

    LbPolicyConfiguration(RlsProtoData.RouteLookupConfig routeLookupConfig, @Nullable Map<String, ?> routeLookupChannelServiceConfig, ChildLoadBalancingPolicy policy) {
        this.routeLookupConfig = (RlsProtoData.RouteLookupConfig)Preconditions.checkNotNull((Object)routeLookupConfig, (Object)"routeLookupConfig");
        this.routeLookupChannelServiceConfig = routeLookupChannelServiceConfig;
        this.policy = (ChildLoadBalancingPolicy)Preconditions.checkNotNull((Object)policy, (Object)"policy");
    }

    RlsProtoData.RouteLookupConfig getRouteLookupConfig() {
        return this.routeLookupConfig;
    }

    @Nullable
    Map<String, ?> getRouteLookupChannelServiceConfig() {
        return this.routeLookupChannelServiceConfig;
    }

    ChildLoadBalancingPolicy getLoadBalancingPolicy() {
        return this.policy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LbPolicyConfiguration that = (LbPolicyConfiguration)o;
        return Objects.equals(this.routeLookupConfig, that.routeLookupConfig) && Objects.equals(this.routeLookupChannelServiceConfig, that.routeLookupChannelServiceConfig) && Objects.equals(this.policy, that.policy);
    }

    public int hashCode() {
        return Objects.hash(this.routeLookupConfig, this.routeLookupChannelServiceConfig, this.policy);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("routeLookupConfig", (Object)this.routeLookupConfig).add("routeLookupChannelServiceConfig", this.routeLookupChannelServiceConfig).add("policy", (Object)this.policy).toString();
    }

    static final class InvalidChildPolicyConfigException
    extends Exception {
        private static final long serialVersionUID = 0L;

        InvalidChildPolicyConfigException(String message) {
            super(message);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    private static final class RefCountedChildPolicyWrapper
    implements ObjectPool<ChildPolicyWrapper> {
        private long refCnt;
        @Nullable
        private ChildPolicyWrapper childPolicyWrapper;

        private RefCountedChildPolicyWrapper(ChildPolicyWrapper childPolicyWrapper) {
            this.childPolicyWrapper = (ChildPolicyWrapper)Preconditions.checkNotNull((Object)childPolicyWrapper, (Object)"childPolicyWrapper");
        }

        public ChildPolicyWrapper getObject() {
            Preconditions.checkState((!this.isReleased() ? 1 : 0) != 0, (Object)"ChildPolicyWrapper is already released");
            ++this.refCnt;
            return this.childPolicyWrapper;
        }

        @Nullable
        public ChildPolicyWrapper returnObject(Object object) {
            Preconditions.checkState((!this.isReleased() ? 1 : 0) != 0, (Object)"cannot return already released ChildPolicyWrapper, this is possibly a bug.");
            Preconditions.checkState((this.childPolicyWrapper == object ? 1 : 0) != 0, (Object)"returned object doesn't match the pooled childPolicyWrapper");
            long newCnt = --this.refCnt;
            Preconditions.checkState((newCnt != -1L ? 1 : 0) != 0, (Object)"Cannot return never pooled childPolicyWrapper");
            if (newCnt == 0L) {
                this.childPolicyWrapper.shutdown();
                this.childPolicyWrapper = null;
            }
            return null;
        }

        boolean isReleased() {
            return this.childPolicyWrapper == null;
        }

        static RefCountedChildPolicyWrapper of(ChildPolicyWrapper childPolicyWrapper) {
            return new RefCountedChildPolicyWrapper(childPolicyWrapper);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("object", (Object)this.childPolicyWrapper).add("refCnt", this.refCnt).toString();
        }
    }

    static interface ChildLbStatusListener {
        public void onStatusChanged(ConnectivityState var1);
    }

    static final class ChildPolicyWrapper {
        private final String target;
        private final ChildPolicyReportingHelper helper;
        private final LoadBalancer lb;
        private final Object childLbConfig;
        private volatile LoadBalancer.SubchannelPicker picker;
        private ConnectivityState state;

        public ChildPolicyWrapper(String target, ChildLoadBalancingPolicy childPolicy, final ResolvedAddressFactory childLbResolvedAddressFactory, ChildLoadBalancerHelper.ChildLoadBalancerHelperProvider childLbHelperProvider, ChildLbStatusListener childLbStatusListener) {
            this.target = target;
            this.helper = new ChildPolicyReportingHelper(childLbHelperProvider, childLbStatusListener);
            LoadBalancerProvider lbProvider = childPolicy.getEffectiveLbProvider();
            NameResolver.ConfigOrError lbConfig = lbProvider.parseLoadBalancingPolicyConfig(childPolicy.getEffectiveChildPolicy(target));
            this.lb = lbProvider.newLoadBalancer((LoadBalancer.Helper)this.helper);
            this.childLbConfig = lbConfig.getConfig();
            this.helper.getChannelLogger().log(ChannelLogger.ChannelLogLevel.DEBUG, "RLS child lb created. config: {0}", new Object[]{this.childLbConfig});
            this.helper.getSynchronizationContext().execute(new Runnable(){

                @Override
                public void run() {
                    if (!this.acceptResolvedAddressFactory(childLbResolvedAddressFactory).isOk()) {
                        helper.refreshNameResolution();
                    }
                    lb.requestConnection();
                }
            });
        }

        Status acceptResolvedAddressFactory(ResolvedAddressFactory childLbResolvedAddressFactory) {
            this.helper.getSynchronizationContext().throwIfNotInThisSynchronizationContext();
            return this.lb.acceptResolvedAddresses(childLbResolvedAddressFactory.create(this.childLbConfig));
        }

        String getTarget() {
            return this.target;
        }

        LoadBalancer.SubchannelPicker getPicker() {
            return this.picker;
        }

        ChildPolicyReportingHelper getHelper() {
            return this.helper;
        }

        public ConnectivityState getState() {
            return this.state;
        }

        void refreshState() {
            this.helper.getSynchronizationContext().execute(new Runnable(){

                @Override
                public void run() {
                    helper.updateBalancingState(state, picker);
                }
            });
        }

        void shutdown() {
            this.helper.getSynchronizationContext().execute(new Runnable(){

                @Override
                public void run() {
                    lb.shutdown();
                }
            });
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("target", (Object)this.target).add("picker", (Object)this.picker).add("state", (Object)this.state).toString();
        }

        final class ChildPolicyReportingHelper
        extends ForwardingLoadBalancerHelper {
            private final ChildLoadBalancerHelper delegate;
            private final ChildLbStatusListener listener;

            ChildPolicyReportingHelper(ChildLoadBalancerHelper.ChildLoadBalancerHelperProvider childHelperProvider, ChildLbStatusListener listener) {
                Preconditions.checkNotNull((Object)childHelperProvider, (Object)"childHelperProvider");
                this.delegate = childHelperProvider.forTarget(ChildPolicyWrapper.this.getTarget());
                this.listener = (ChildLbStatusListener)Preconditions.checkNotNull((Object)listener, (Object)"listener");
            }

            protected LoadBalancer.Helper delegate() {
                return this.delegate;
            }

            public void updateBalancingState(ConnectivityState newState, LoadBalancer.SubchannelPicker newPicker) {
                ChildPolicyWrapper.this.picker = newPicker;
                ChildPolicyWrapper.this.state = newState;
                super.updateBalancingState(newState, newPicker);
                this.listener.onStatusChanged(newState);
            }
        }
    }

    static final class RefCountedChildPolicyWrapperFactory {
        @VisibleForTesting
        final Map<String, RefCountedChildPolicyWrapper> childPolicyMap = new HashMap<String, RefCountedChildPolicyWrapper>();
        private final ChildLoadBalancerHelper.ChildLoadBalancerHelperProvider childLbHelperProvider;
        private final ChildLbStatusListener childLbStatusListener;
        private final ChildLoadBalancingPolicy childPolicy;
        private ResolvedAddressFactory childLbResolvedAddressFactory;

        public RefCountedChildPolicyWrapperFactory(ChildLoadBalancingPolicy childPolicy, ResolvedAddressFactory childLbResolvedAddressFactory, ChildLoadBalancerHelper.ChildLoadBalancerHelperProvider childLbHelperProvider, ChildLbStatusListener childLbStatusListener) {
            this.childPolicy = (ChildLoadBalancingPolicy)Preconditions.checkNotNull((Object)childPolicy, (Object)"childPolicy");
            this.childLbResolvedAddressFactory = (ResolvedAddressFactory)Preconditions.checkNotNull((Object)childLbResolvedAddressFactory, (Object)"childLbResolvedAddressFactory");
            this.childLbHelperProvider = (ChildLoadBalancerHelper.ChildLoadBalancerHelperProvider)Preconditions.checkNotNull((Object)childLbHelperProvider, (Object)"childLbHelperProvider");
            this.childLbStatusListener = (ChildLbStatusListener)Preconditions.checkNotNull((Object)childLbStatusListener, (Object)"childLbStatusListener");
        }

        void init() {
            this.childLbHelperProvider.init();
        }

        Status acceptResolvedAddressFactory(ResolvedAddressFactory childLbResolvedAddressFactory) {
            this.childLbResolvedAddressFactory = childLbResolvedAddressFactory;
            Status status = Status.OK;
            for (RefCountedChildPolicyWrapper wrapper : this.childPolicyMap.values()) {
                Status newStatus = wrapper.childPolicyWrapper.acceptResolvedAddressFactory(childLbResolvedAddressFactory);
                if (newStatus.isOk()) continue;
                status = newStatus;
            }
            return status;
        }

        ChildPolicyWrapper createOrGet(String target) {
            RefCountedChildPolicyWrapper pooledChildPolicyWrapper = this.childPolicyMap.get(target);
            if (pooledChildPolicyWrapper == null) {
                ChildPolicyWrapper childPolicyWrapper = new ChildPolicyWrapper(target, this.childPolicy, this.childLbResolvedAddressFactory, this.childLbHelperProvider, this.childLbStatusListener);
                pooledChildPolicyWrapper = RefCountedChildPolicyWrapper.of(childPolicyWrapper);
                this.childPolicyMap.put(target, pooledChildPolicyWrapper);
                return pooledChildPolicyWrapper.getObject();
            }
            ChildPolicyWrapper childPolicyWrapper = pooledChildPolicyWrapper.getObject();
            if (childPolicyWrapper.getPicker() != null) {
                childPolicyWrapper.refreshState();
            }
            return childPolicyWrapper;
        }

        List<ChildPolicyWrapper> createOrGet(List<String> targets) {
            ArrayList<ChildPolicyWrapper> retVal = new ArrayList<ChildPolicyWrapper>();
            for (String target : targets) {
                retVal.add(this.createOrGet(target));
            }
            return retVal;
        }

        void release(ChildPolicyWrapper childPolicyWrapper) {
            Preconditions.checkNotNull((Object)childPolicyWrapper, (Object)"childPolicyWrapper");
            String target = childPolicyWrapper.getTarget();
            RefCountedChildPolicyWrapper existing = this.childPolicyMap.get(target);
            Preconditions.checkState((existing != null ? 1 : 0) != 0, (Object)"Cannot access already released object");
            existing.returnObject(childPolicyWrapper);
            if (existing.isReleased()) {
                this.childPolicyMap.remove(target);
            }
        }
    }

    static final class ChildLoadBalancingPolicy {
        private final Map<String, Object> effectiveRawChildPolicy;
        private final LoadBalancerProvider effectiveLbProvider;
        private final String targetFieldName;

        @VisibleForTesting
        ChildLoadBalancingPolicy(String targetFieldName, Map<String, Object> effectiveRawChildPolicy, LoadBalancerProvider effectiveLbProvider) {
            Preconditions.checkArgument((targetFieldName != null && !targetFieldName.isEmpty() ? 1 : 0) != 0, (Object)"targetFieldName cannot be empty or null");
            this.targetFieldName = targetFieldName;
            this.effectiveRawChildPolicy = (Map)Preconditions.checkNotNull(effectiveRawChildPolicy, (Object)"effectiveRawChildPolicy");
            this.effectiveLbProvider = (LoadBalancerProvider)Preconditions.checkNotNull((Object)effectiveLbProvider, (Object)"effectiveLbProvider");
        }

        static ChildLoadBalancingPolicy create(String childPolicyConfigTargetFieldName, List<Map<String, ?>> childPolicies) throws InvalidChildPolicyConfigException {
            Map<String, ?> effectiveChildPolicy = null;
            LoadBalancerProvider effectiveLbProvider = null;
            ArrayList<String> policyTried = new ArrayList<String>();
            LoadBalancerRegistry lbRegistry = LoadBalancerRegistry.getDefaultRegistry();
            for (Map<String, ?> childPolicy : childPolicies) {
                if (childPolicy.isEmpty()) continue;
                if (childPolicy.size() != 1) {
                    throw new InvalidChildPolicyConfigException("childPolicy should have exactly one loadbalancing policy");
                }
                String policyName = childPolicy.keySet().iterator().next();
                LoadBalancerProvider provider = lbRegistry.getProvider(policyName);
                if (provider != null) {
                    effectiveLbProvider = provider;
                    effectiveChildPolicy = Collections.unmodifiableMap(childPolicy);
                    break;
                }
                policyTried.add(policyName);
            }
            if (effectiveChildPolicy == null) {
                throw new InvalidChildPolicyConfigException(String.format("no valid childPolicy found, policy tried: %s", policyTried));
            }
            return new ChildLoadBalancingPolicy(childPolicyConfigTargetFieldName, (Map)effectiveChildPolicy.values().iterator().next(), effectiveLbProvider);
        }

        Map<String, ?> getEffectiveChildPolicy(String target) {
            HashMap<String, Object> childPolicy = new HashMap<String, Object>(this.effectiveRawChildPolicy);
            childPolicy.put(this.targetFieldName, target);
            return childPolicy;
        }

        LoadBalancerProvider getEffectiveLbProvider() {
            return this.effectiveLbProvider;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChildLoadBalancingPolicy that = (ChildLoadBalancingPolicy)o;
            return Objects.equals(this.effectiveRawChildPolicy, that.effectiveRawChildPolicy) && Objects.equals(this.effectiveLbProvider, that.effectiveLbProvider) && Objects.equals(this.targetFieldName, that.targetFieldName);
        }

        public int hashCode() {
            return Objects.hash(this.effectiveRawChildPolicy, this.effectiveLbProvider, this.targetFieldName);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("effectiveRawChildPolicy", this.effectiveRawChildPolicy).add("effectiveLbProvider", (Object)this.effectiveLbProvider).add("childPolicyConfigTargetFieldName", (Object)this.targetFieldName).toString();
        }
    }
}

