/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.protobuf.lite;

import com.google.common.base.Preconditions;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import io.grpc.KnownLength;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.protobuf.lite.ProtoInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

public class ProtoLiteUtils {
    private static volatile ExtensionRegistryLite globalRegistry = ExtensionRegistryLite.getEmptyRegistry();
    private static final int BUF_SIZE = 8192;
    private static final ThreadLocal<Reference<byte[]>> bufs = new ThreadLocal<Reference<byte[]>>(){

        @Override
        protected Reference<byte[]> initialValue() {
            return new WeakReference<byte[]>(new byte[4096]);
        }
    };

    public static void setExtensionRegistry(ExtensionRegistryLite newRegistry) {
        globalRegistry = (ExtensionRegistryLite)Preconditions.checkNotNull((Object)newRegistry, (Object)"newRegistry");
    }

    public static <T extends MessageLite> MethodDescriptor.Marshaller<T> marshaller(final T defaultInstance) {
        final Parser parser = defaultInstance.getParserForType();
        return new MethodDescriptor.PrototypeMarshaller<T>(){

            public Class<T> getMessageClass() {
                return defaultInstance.getClass();
            }

            public T getMessagePrototype() {
                return defaultInstance;
            }

            public InputStream stream(T value) {
                return new ProtoInputStream((MessageLite)value, (Parser<?>)parser);
            }

            public T parse(InputStream stream) {
                ProtoInputStream protoStream;
                if (stream instanceof ProtoInputStream && (protoStream = (ProtoInputStream)stream).parser() == parser) {
                    try {
                        MessageLite message = ((ProtoInputStream)stream).message();
                        return message;
                    }
                    catch (IllegalStateException message) {
                        // empty catch block
                    }
                }
                CodedInputStream cis = null;
                try {
                    if (stream instanceof KnownLength) {
                        int size = stream.available();
                        if (size > 0 && size <= 0x400000) {
                            int position;
                            int remaining;
                            int count;
                            byte[] buf = (byte[])((Reference)bufs.get()).get();
                            if (buf == null || buf.length < size) {
                                buf = new byte[size];
                                bufs.set(new WeakReference<byte[]>(buf));
                            }
                            for (remaining = size; remaining > 0 && (count = stream.read(buf, position = size - remaining, remaining)) != -1; remaining -= count) {
                            }
                            if (remaining != 0) {
                                position = size - remaining;
                                throw new RuntimeException("size inaccurate: " + size + " != " + position);
                            }
                            cis = CodedInputStream.newInstance((byte[])buf, (int)0, (int)size);
                        } else if (size == 0) {
                            return defaultInstance;
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (cis == null) {
                    cis = CodedInputStream.newInstance((InputStream)stream);
                }
                cis.setSizeLimit(Integer.MAX_VALUE);
                try {
                    return this.parseFrom(cis);
                }
                catch (InvalidProtocolBufferException ipbe) {
                    throw Status.INTERNAL.withDescription("Invalid protobuf byte sequence").withCause((Throwable)ipbe).asRuntimeException();
                }
            }

            private T parseFrom(CodedInputStream stream) throws InvalidProtocolBufferException {
                MessageLite message = (MessageLite)parser.parseFrom(stream, globalRegistry);
                try {
                    stream.checkLastTagWas(0);
                    return message;
                }
                catch (InvalidProtocolBufferException e) {
                    e.setUnfinishedMessage(message);
                    throw e;
                }
            }
        };
    }

    public static <T extends MessageLite> Metadata.BinaryMarshaller<T> metadataMarshaller(final T instance) {
        return new Metadata.BinaryMarshaller<T>(){

            public byte[] toBytes(T value) {
                return value.toByteArray();
            }

            public T parseBytes(byte[] serialized) {
                try {
                    return (MessageLite)instance.getParserForType().parseFrom(serialized, globalRegistry);
                }
                catch (InvalidProtocolBufferException ipbe) {
                    throw new IllegalArgumentException(ipbe);
                }
            }
        };
    }

    static long copy(InputStream from, OutputStream to) throws IOException {
        int r;
        Preconditions.checkNotNull((Object)from);
        Preconditions.checkNotNull((Object)to);
        byte[] buf = new byte[8192];
        long total = 0L;
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
            total += (long)r;
        }
        return total;
    }

    private ProtoLiteUtils() {
    }
}

