/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.Compressor;
import io.grpc.DecompressorRegistry;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.internal.ClientStream;
import io.grpc.internal.ClientStreamListener;
import io.grpc.internal.NoopClientStream;
import io.grpc.internal.StreamListener;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

abstract class RetriableStream<ReqT>
implements ClientStream {
    private static final Status CANCELLED_BECAUSE_COMMITTED = Status.CANCELLED.withDescription("Stream thrown away because RetriableStream committed");
    private final MethodDescriptor<ReqT, ?> method;
    private final Object lock = new Object();
    private volatile State state = new State(new ArrayList<BufferEntry>(), Collections.<Substream>emptySet(), null, false, false);
    private ClientStreamListener masterListener;

    RetriableStream(MethodDescriptor<ReqT, ?> method) {
        this.method = method;
    }

    private boolean commit(Substream winningSubstream) {
        if (this.commit0(winningSubstream)) {
            this.postCommit();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean commit0(Substream winningSubstream) {
        Collection<Substream> savedDrainedSubstreams;
        Iterator<Substream> iterator = this.lock;
        synchronized (iterator) {
            if (this.state.winningSubstream != null) {
                return false;
            }
            savedDrainedSubstreams = this.state.drainedSubstreams;
            this.state = this.state.committed(winningSubstream);
        }
        for (Substream substream : savedDrainedSubstreams) {
            if (substream == winningSubstream) continue;
            substream.stream.cancel(CANCELLED_BECAUSE_COMMITTED);
        }
        return true;
    }

    abstract void postCommit();

    private void retry() {
        Substream substream = this.createSubstream();
        this.drain(substream);
    }

    private Substream createSubstream() {
        Substream sub = new Substream();
        sub.stream = this.newStream();
        return sub;
    }

    abstract ClientStream newStream();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void drain(Substream substream) {
        index = 0;
        chunk = 128;
        list = null;
        block3: while (true) {
            var6_6 = this.lock;
            synchronized (var6_6) {
                savedState = this.state;
                if (savedState.winningSubstream != null && savedState.winningSubstream != substream) {
                    break;
                }
                if (index == savedState.buffer.size()) {
                    this.state = savedState.substreamDrained(substream);
                    return;
                }
                if (substream.closed) {
                    return;
                }
                stop = Math.min(index + chunk, savedState.buffer.size());
                if (list == null) {
                    list = new ArrayList<BufferEntry>(stop - index);
                }
                list.clear();
                list.addAll(savedState.buffer.subList(index, stop));
                index = stop;
            }
            var6_6 = list.iterator();
            while (true) {
                if (!var6_6.hasNext()) continue block3;
                bufferEntry = (BufferEntry)var6_6.next();
                savedState = this.state;
                if (savedState.winningSubstream == null || savedState.winningSubstream == substream) ** break;
                continue block3;
                if (savedState.cancelled) {
                    Preconditions.checkState((boolean)(savedState.winningSubstream == substream), (Object)"substream should be CANCELLED_BECAUSE_COMMITTED already");
                    return;
                }
                bufferEntry.runWith(substream);
            }
            break;
        }
        substream.stream.cancel(RetriableStream.CANCELLED_BECAUSE_COMMITTED);
    }

    @CheckReturnValue
    @Nullable
    abstract Status prestart();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void start(ClientStreamListener listener) {
        this.masterListener = listener;
        Status shutdownStatus = this.prestart();
        if (shutdownStatus != null) {
            this.cancel(shutdownStatus);
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            class StartEntry
            implements BufferEntry {
                StartEntry() {
                }

                @Override
                public void runWith(Substream substream) {
                    substream.stream.start(new Sublistener(substream));
                }
            }
            this.state.buffer.add(new StartEntry());
        }
        Substream substream = this.createSubstream();
        this.drain(substream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void cancel(Status reason) {
        Substream noopSubstream = new Substream();
        noopSubstream.stream = new NoopClientStream();
        if (this.commit0(noopSubstream)) {
            this.masterListener.closed(reason, new Metadata());
            this.postCommit();
            return;
        }
        this.state.winningSubstream.stream.cancel(reason);
        Object object = this.lock;
        synchronized (object) {
            this.state = this.state.cancelled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delayOrExecute(BufferEntry bufferEntry) {
        Collection<Substream> savedDrainedSubstreams;
        Iterator<Substream> iterator = this.lock;
        synchronized (iterator) {
            if (!this.state.passThrough) {
                this.state.buffer.add(bufferEntry);
            }
            savedDrainedSubstreams = this.state.drainedSubstreams;
        }
        for (Substream substream : savedDrainedSubstreams) {
            bufferEntry.runWith(substream);
        }
    }

    @Override
    public final void writeMessage(InputStream message) {
        throw new IllegalStateException("RetriableStream.writeMessage() should not be called directly");
    }

    final void sendMessage(final ReqT message) {
        State savedState = this.state;
        if (savedState.passThrough) {
            savedState.winningSubstream.stream.writeMessage(this.method.streamRequest(message));
            return;
        }
        class SendMessageEntry
        implements BufferEntry {
            SendMessageEntry() {
            }

            @Override
            public void runWith(Substream substream) {
                substream.stream.writeMessage(RetriableStream.this.method.streamRequest(message));
            }
        }
        this.delayOrExecute(new SendMessageEntry());
    }

    @Override
    public final void request(final int numMessages) {
        State savedState = this.state;
        if (savedState.passThrough) {
            savedState.winningSubstream.stream.request(numMessages);
            return;
        }
        class RequestEntry
        implements BufferEntry {
            RequestEntry() {
            }

            @Override
            public void runWith(Substream substream) {
                substream.stream.request(numMessages);
            }
        }
        this.delayOrExecute(new RequestEntry());
    }

    @Override
    public final void flush() {
        State savedState = this.state;
        if (savedState.passThrough) {
            savedState.winningSubstream.stream.flush();
            return;
        }
        class FlushEntry
        implements BufferEntry {
            FlushEntry() {
            }

            @Override
            public void runWith(Substream substream) {
                substream.stream.flush();
            }
        }
        this.delayOrExecute(new FlushEntry());
    }

    @Override
    public final boolean isReady() {
        for (Substream substream : this.state.drainedSubstreams) {
            if (!substream.stream.isReady()) continue;
            return true;
        }
        return false;
    }

    @Override
    public final void setCompressor(final Compressor compressor) {
        class CompressorEntry
        implements BufferEntry {
            CompressorEntry() {
            }

            @Override
            public void runWith(Substream substream) {
                substream.stream.setCompressor(compressor);
            }
        }
        this.delayOrExecute(new CompressorEntry());
    }

    @Override
    public final void setFullStreamDecompression(final boolean fullStreamDecompression) {
        class FullStreamDecompressionEntry
        implements BufferEntry {
            FullStreamDecompressionEntry() {
            }

            @Override
            public void runWith(Substream substream) {
                substream.stream.setFullStreamDecompression(fullStreamDecompression);
            }
        }
        this.delayOrExecute(new FullStreamDecompressionEntry());
    }

    @Override
    public final void setMessageCompression(final boolean enable) {
        class MessageCompressionEntry
        implements BufferEntry {
            MessageCompressionEntry() {
            }

            @Override
            public void runWith(Substream substream) {
                substream.stream.setMessageCompression(enable);
            }
        }
        this.delayOrExecute(new MessageCompressionEntry());
    }

    @Override
    public final void halfClose() {
        class HalfCloseEntry
        implements BufferEntry {
            HalfCloseEntry() {
            }

            @Override
            public void runWith(Substream substream) {
                substream.stream.halfClose();
            }
        }
        this.delayOrExecute(new HalfCloseEntry());
    }

    @Override
    public final void setAuthority(final String authority) {
        class AuthorityEntry
        implements BufferEntry {
            AuthorityEntry() {
            }

            @Override
            public void runWith(Substream substream) {
                substream.stream.setAuthority(authority);
            }
        }
        this.delayOrExecute(new AuthorityEntry());
    }

    @Override
    public final void setDecompressorRegistry(final DecompressorRegistry decompressorRegistry) {
        class DecompressorRegistryEntry
        implements BufferEntry {
            DecompressorRegistryEntry() {
            }

            @Override
            public void runWith(Substream substream) {
                substream.stream.setDecompressorRegistry(decompressorRegistry);
            }
        }
        this.delayOrExecute(new DecompressorRegistryEntry());
    }

    @Override
    public final void setMaxInboundMessageSize(final int maxSize) {
        class MaxInboundMessageSizeEntry
        implements BufferEntry {
            MaxInboundMessageSizeEntry() {
            }

            @Override
            public void runWith(Substream substream) {
                substream.stream.setMaxInboundMessageSize(maxSize);
            }
        }
        this.delayOrExecute(new MaxInboundMessageSizeEntry());
    }

    @Override
    public final void setMaxOutboundMessageSize(final int maxSize) {
        class MaxOutboundMessageSizeEntry
        implements BufferEntry {
            MaxOutboundMessageSizeEntry() {
            }

            @Override
            public void runWith(Substream substream) {
                substream.stream.setMaxOutboundMessageSize(maxSize);
            }
        }
        this.delayOrExecute(new MaxOutboundMessageSizeEntry());
    }

    @Override
    public final Attributes getAttributes() {
        if (this.state.winningSubstream != null) {
            return this.state.winningSubstream.stream.getAttributes();
        }
        return Attributes.EMPTY;
    }

    boolean shouldRetry() {
        return false;
    }

    boolean hasHedging() {
        return false;
    }

    private static final class Substream {
        ClientStream stream;
        boolean closed;

        private Substream() {
        }
    }

    private static final class State {
        final boolean passThrough;
        @Nullable
        final List<BufferEntry> buffer;
        final Collection<Substream> drainedSubstreams;
        @Nullable
        final Substream winningSubstream;
        final boolean cancelled;

        State(@Nullable List<BufferEntry> buffer, Collection<Substream> drainedSubstreams, @Nullable Substream winningSubstream, boolean cancelled, boolean passThrough) {
            this.buffer = buffer;
            this.drainedSubstreams = Collections.unmodifiableCollection((Collection)Preconditions.checkNotNull(drainedSubstreams, (Object)"drainedSubstreams"));
            this.winningSubstream = winningSubstream;
            this.cancelled = cancelled;
            this.passThrough = passThrough;
            Preconditions.checkState((!passThrough || buffer == null ? 1 : 0) != 0, (Object)"passThrough should imply buffer is null");
            Preconditions.checkState((!passThrough || winningSubstream != null ? 1 : 0) != 0, (Object)"passThrough should imply winningSubstream != null");
            Preconditions.checkState((!passThrough || drainedSubstreams.size() == 1 && drainedSubstreams.contains(winningSubstream) || drainedSubstreams.size() == 0 && winningSubstream.closed ? 1 : 0) != 0, (Object)"passThrough should imply winningSubstream is drained");
            Preconditions.checkState((!cancelled || winningSubstream != null ? 1 : 0) != 0, (Object)"cancelled should imply committed");
        }

        @CheckReturnValue
        @GuardedBy(value="lock")
        State cancelled() {
            return new State(this.buffer, this.drainedSubstreams, this.winningSubstream, true, this.passThrough);
        }

        @CheckReturnValue
        @GuardedBy(value="lock")
        State substreamDrained(Substream substream) {
            Preconditions.checkState((!this.passThrough ? 1 : 0) != 0, (Object)"Already passThrough");
            HashSet<Substream> drainedSubstreams = new HashSet<Substream>(this.drainedSubstreams);
            if (!substream.closed) {
                drainedSubstreams.add(substream);
            }
            boolean passThrough = this.winningSubstream != null;
            List<BufferEntry> buffer = this.buffer;
            if (passThrough) {
                Preconditions.checkState((this.winningSubstream == substream ? 1 : 0) != 0, (Object)"Another RPC attempt has already committed");
                buffer = null;
            }
            return new State(buffer, drainedSubstreams, this.winningSubstream, this.cancelled, passThrough);
        }

        @CheckReturnValue
        @GuardedBy(value="lock")
        State substreamClosed(Substream substream) {
            substream.closed = true;
            if (this.drainedSubstreams.contains(substream)) {
                HashSet<Substream> drainedSubstreams = new HashSet<Substream>(this.drainedSubstreams);
                drainedSubstreams.remove(substream);
                return new State(this.buffer, drainedSubstreams, this.winningSubstream, this.cancelled, this.passThrough);
            }
            return this;
        }

        @CheckReturnValue
        @GuardedBy(value="lock")
        State committed(Substream winningSubstream) {
            Preconditions.checkState((this.winningSubstream == null ? 1 : 0) != 0, (Object)"Already committed");
            boolean passThrough = false;
            List<BufferEntry> buffer = this.buffer;
            Set<Substream> drainedSubstreams = Collections.emptySet();
            if (this.drainedSubstreams.contains(winningSubstream)) {
                passThrough = true;
                buffer = null;
                drainedSubstreams = Collections.singleton(winningSubstream);
            }
            return new State(buffer, drainedSubstreams, winningSubstream, this.cancelled, passThrough);
        }
    }

    private final class Sublistener
    implements ClientStreamListener {
        final Substream substream;

        Sublistener(Substream substream) {
            this.substream = substream;
        }

        @Override
        public void headersRead(Metadata headers) {
            if (RetriableStream.this.commit(this.substream)) {
                RetriableStream.this.masterListener.headersRead(headers);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void closed(Status status, Metadata trailers) {
            Object object = RetriableStream.this.lock;
            synchronized (object) {
                RetriableStream.this.state = RetriableStream.this.state.substreamClosed(this.substream);
            }
            if (((RetriableStream)RetriableStream.this).state.winningSubstream == null && RetriableStream.this.shouldRetry()) {
                RetriableStream.this.retry();
            } else if (!RetriableStream.this.hasHedging()) {
                RetriableStream.this.commit(this.substream);
                if (((RetriableStream)RetriableStream.this).state.winningSubstream == this.substream) {
                    RetriableStream.this.masterListener.closed(status, trailers);
                }
            }
        }

        @Override
        public void messagesAvailable(StreamListener.MessageProducer producer) {
            State savedState = RetriableStream.this.state;
            Preconditions.checkState((savedState.winningSubstream != null ? 1 : 0) != 0, (Object)"Headers should be received prior to messages.");
            if (savedState.winningSubstream != this.substream) {
                return;
            }
            RetriableStream.this.masterListener.messagesAvailable(producer);
        }

        @Override
        public void onReady() {
            if (((RetriableStream)RetriableStream.this).state.drainedSubstreams.contains(this.substream)) {
                RetriableStream.this.masterListener.onReady();
            }
        }
    }

    private static interface BufferEntry {
        public void runWith(Substream var1);
    }
}

