/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.internal.ConnectionClientTransport;
import io.grpc.internal.ProxyParameters;
import java.io.Closeable;
import java.net.SocketAddress;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;

public interface ClientTransportFactory
extends Closeable {
    public ConnectionClientTransport newClientTransport(SocketAddress var1, ClientTransportOptions var2);

    public ScheduledExecutorService getScheduledExecutorService();

    @Override
    public void close();

    public static final class ClientTransportOptions {
        private String authority = "unknown-authority";
        private Attributes eagAttributes = Attributes.EMPTY;
        @Nullable
        private String userAgent;
        @Nullable
        private ProxyParameters proxyParameters;

        public String getAuthority() {
            return this.authority;
        }

        public ClientTransportOptions setAuthority(String authority) {
            this.authority = (String)Preconditions.checkNotNull((Object)authority, (Object)"authority");
            return this;
        }

        public Attributes getEagAttributes() {
            return this.eagAttributes;
        }

        public ClientTransportOptions setEagAttributes(Attributes eagAttributes) {
            Preconditions.checkNotNull((Object)eagAttributes, (Object)"eagAttributes");
            this.eagAttributes = eagAttributes;
            return this;
        }

        @Nullable
        public String getUserAgent() {
            return this.userAgent;
        }

        public ClientTransportOptions setUserAgent(@Nullable String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        @Nullable
        public ProxyParameters getProxyParameters() {
            return this.proxyParameters;
        }

        public ClientTransportOptions setProxyParameters(@Nullable ProxyParameters proxyParameters) {
            this.proxyParameters = proxyParameters;
            return this;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.authority, this.eagAttributes, this.userAgent, this.proxyParameters});
        }

        public boolean equals(Object o) {
            if (!(o instanceof ClientTransportOptions)) {
                return false;
            }
            ClientTransportOptions that = (ClientTransportOptions)o;
            return this.authority.equals(that.authority) && this.eagAttributes.equals(that.eagAttributes) && Objects.equal((Object)this.userAgent, (Object)that.userAgent) && Objects.equal((Object)this.proxyParameters, (Object)that.proxyParameters);
        }
    }
}

