/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.grpc.ExperimentalApi;
import io.grpc.ProxiedSocketAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public final class HttpConnectProxiedSocketAddress
extends ProxiedSocketAddress {
    private static final long serialVersionUID = 0L;
    private final SocketAddress proxyAddress;
    private final InetSocketAddress targetAddress;
    private final Map<String, String> headers;
    @Nullable
    private final String username;
    @Nullable
    private final String password;

    private HttpConnectProxiedSocketAddress(SocketAddress proxyAddress, InetSocketAddress targetAddress, Map<String, String> headers, @Nullable String username, @Nullable String password) {
        Preconditions.checkNotNull((Object)proxyAddress, (Object)"proxyAddress");
        Preconditions.checkNotNull((Object)targetAddress, (Object)"targetAddress");
        if (proxyAddress instanceof InetSocketAddress) {
            Preconditions.checkState((!((InetSocketAddress)proxyAddress).isUnresolved() ? 1 : 0) != 0, (String)"The proxy address %s is not resolved", (Object)proxyAddress);
        }
        this.proxyAddress = proxyAddress;
        this.targetAddress = targetAddress;
        this.headers = headers;
        this.username = username;
        this.password = password;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    public SocketAddress getProxyAddress() {
        return this.proxyAddress;
    }

    public InetSocketAddress getTargetAddress() {
        return this.targetAddress;
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/12479")
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public boolean equals(Object o) {
        if (!(o instanceof HttpConnectProxiedSocketAddress)) {
            return false;
        }
        HttpConnectProxiedSocketAddress that = (HttpConnectProxiedSocketAddress)o;
        return Objects.equal((Object)this.proxyAddress, (Object)that.proxyAddress) && Objects.equal((Object)this.targetAddress, (Object)that.targetAddress) && Objects.equal(this.headers, that.headers) && Objects.equal((Object)this.username, (Object)that.username) && Objects.equal((Object)this.password, (Object)that.password);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.proxyAddress, this.targetAddress, this.username, this.password, this.headers});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("proxyAddr", (Object)this.proxyAddress).add("targetAddr", (Object)this.targetAddress).add("headers", this.headers).add("username", (Object)this.username).add("hasPassword", this.password != null).toString();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private SocketAddress proxyAddress;
        private InetSocketAddress targetAddress;
        private Map<String, String> headers = Collections.emptyMap();
        @Nullable
        private String username;
        @Nullable
        private String password;

        private Builder() {
        }

        public Builder setProxyAddress(SocketAddress proxyAddress) {
            this.proxyAddress = (SocketAddress)Preconditions.checkNotNull((Object)proxyAddress, (Object)"proxyAddress");
            return this;
        }

        public Builder setTargetAddress(InetSocketAddress targetAddress) {
            this.targetAddress = (InetSocketAddress)Preconditions.checkNotNull((Object)targetAddress, (Object)"targetAddress");
            return this;
        }

        @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/12479")
        public Builder setHeaders(Map<String, String> headers) {
            this.headers = Collections.unmodifiableMap(new HashMap((Map)Preconditions.checkNotNull(headers, (Object)"headers")));
            return this;
        }

        public Builder setUsername(@Nullable String username) {
            this.username = username;
            return this;
        }

        public Builder setPassword(@Nullable String password) {
            this.password = password;
            return this;
        }

        public HttpConnectProxiedSocketAddress build() {
            return new HttpConnectProxiedSocketAddress(this.proxyAddress, this.targetAddress, this.headers, this.username, this.password);
        }
    }
}

