/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts;

import io.grpc.ManagedChannel;
import io.grpc.internal.FixedObjectPool;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.nio.NioEventLoopGroup;
import io.grpc.netty.shaded.io.netty.util.concurrent.DefaultThreadFactory;
import java.util.concurrent.ThreadFactory;

final class HandshakerServiceChannel {
    static final SharedResourceHolder.Resource<ManagedChannel> SHARED_HANDSHAKER_CHANNEL = new SharedResourceHolder.Resource<ManagedChannel>(){
        private EventLoopGroup eventGroup = null;

        public ManagedChannel create() {
            if (this.eventGroup == null) {
                this.eventGroup = new NioEventLoopGroup(1, (ThreadFactory)new DefaultThreadFactory("handshaker pool", true));
            }
            return ((NettyChannelBuilder)NettyChannelBuilder.forTarget((String)"metadata.google.internal:8080").directExecutor()).eventLoopGroup(this.eventGroup).usePlaintext().build();
        }

        public void close(ManagedChannel instance) {
            instance.shutdownNow();
            if (this.eventGroup != null) {
                this.eventGroup.shutdownGracefully();
            }
        }

        public String toString() {
            return "grpc-alts-handshaker-service-channel";
        }
    };

    HandshakerServiceChannel() {
    }

    static FixedObjectPool<ManagedChannel> getHandshakerChannelPoolForTesting(String handshakerAddress) {
        DefaultThreadFactory clientThreadFactory = new DefaultThreadFactory("handshaker pool", true);
        ManagedChannel channel = ((NettyChannelBuilder)NettyChannelBuilder.forTarget((String)handshakerAddress).directExecutor()).eventLoopGroup((EventLoopGroup)new NioEventLoopGroup(1, (ThreadFactory)clientThreadFactory)).usePlaintext().build();
        return new FixedObjectPool((Object)channel);
    }
}

