/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.DetektVisitor;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.style.VarCouldBeVal;
import io.gitlab.arturbosch.detekt.rules.style.VarCouldBeValKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0011H\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/VarCouldBeVal;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "defaultRuleIdAliases", "", "", "getDefaultRuleIdAliases", "()Ljava/util/Set;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "isSomehowNested", "", "AssignmentVisitor", "detekt-rules-style"})
public final class VarCouldBeVal
extends Rule {
    @NotNull
    private final Set<String> defaultRuleIdAliases;
    @NotNull
    private final Issue issue;

    @NotNull
    public Set<String> getDefaultRuleIdAliases() {
        return this.defaultRuleIdAliases;
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        if (this.isSomehowNested(function)) {
            return;
        }
        AssignmentVisitor assignmentVisitor = new AssignmentVisitor();
        function.accept((PsiElementVisitor)assignmentVisitor);
        Iterable $this$forEach$iv = assignmentVisitor.getNonReAssignedDeclarations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtNamedDeclaration it = (KtNamedDeclaration)element$iv;
            boolean bl = false;
            Issue issue = this.getIssue();
            Entity entity = Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)it), (int)0, (int)2, null);
            StringBuilder stringBuilder = new StringBuilder().append("Variable '");
            Name name = it.getNameAsSafeName();
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"it.nameAsSafeName");
            this.report((Finding)new CodeSmell(issue, entity, stringBuilder.append(name.getIdentifier()).append("' could be val.").toString(), null, null, 24, null));
        }
        super.visitNamedFunction(function);
    }

    private final boolean isSomehowNested(KtNamedFunction $this$isSomehowNested) {
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)$this$isSomehowNested;
        boolean $i$f$getStrictParentOfType = false;
        return PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtNamedFunction.class, (boolean)true) != null;
    }

    public VarCouldBeVal(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.defaultRuleIdAliases = SetsKt.setOf((Object)"CanBeVal");
        this.issue = new Issue("VarCouldBeVal", Severity.Maintainability, "Var declaration could be val.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ VarCouldBeVal(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public VarCouldBeVal() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\rH\u0002J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u0019H\u0016R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/VarCouldBeVal$AssignmentVisitor;", "Lio/gitlab/arturbosch/detekt/api/DetektVisitor;", "()V", "assignments", "", "", "", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "contextsByDeclarationName", "declarations", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "extractAssignedName", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "getNonReAssignedDeclarations", "", "visitAssignment", "", "assignedName", "context", "visitBinaryExpression", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visitUnaryExpression", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "detekt-rules-style"})
    private static final class AssignmentVisitor
    extends DetektVisitor {
        private final Set<KtNamedDeclaration> declarations;
        private final Map<String, Set<PsiElement>> contextsByDeclarationName;
        private final Map<String, Set<PsiElement>> assignments;

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<KtNamedDeclaration> getNonReAssignedDeclarations() {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.declarations;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                KtNamedDeclaration declaration = (KtNamedDeclaration)element$iv$iv;
                boolean bl2 = false;
                Name name = declaration.getNameAsSafeName();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"declaration.nameAsSafeName");
                if (this.assignments.get(name.getIdentifier()) != null) {
                    Set<PsiElement> set;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    Set<PsiElement> it = set;
                    boolean bl5 = false;
                    bl = !it.contains(declaration.getParent());
                } else {
                    bl = true;
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public void visitProperty(@NotNull KtProperty property) {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            if (property.isVar()) {
                Set set;
                this.declarations.add((KtNamedDeclaration)property);
                Name name = property.getNameAsSafeName();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"property.nameAsSafeName");
                String string = name.getIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"property.nameAsSafeName.identifier");
                String identifier = string;
                Map<String, Set<PsiElement>> $this$getOrPut$iv = this.contextsByDeclarationName;
                boolean $i$f$getOrPut = false;
                Set value$iv = $this$getOrPut$iv.get(identifier);
                if (value$iv == null) {
                    boolean bl = false;
                    boolean bl2 = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(identifier, answer$iv);
                    set = answer$iv;
                } else {
                    set = value$iv;
                }
                Set contextsForName = set;
                PsiElement psiElement = property.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"property.parent");
                contextsForName.add((PsiElement)psiElement);
            }
            super.visitProperty(property);
        }

        public void visitUnaryExpression(@NotNull KtUnaryExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            if (CollectionsKt.contains((Iterable)VarCouldBeValKt.access$getUnaryAssignmentOperators$p(), (Object)expression.getOperationToken())) {
                KtExpression ktExpression = expression.getBaseExpression();
                if (ktExpression != null) {
                    KtExpression ktExpression2 = ktExpression;
                    boolean bl = false;
                    boolean bl2 = false;
                    KtExpression $this$run = ktExpression2;
                    boolean bl3 = false;
                    String string = $this$run.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
                    PsiElement psiElement = expression.getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"expression.parent");
                    this.visitAssignment(string, psiElement);
                }
            }
            super.visitUnaryExpression(expression);
        }

        public void visitBinaryExpression(@NotNull KtBinaryExpression expression) {
            String assignedName;
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            if (KtTokens.ALL_ASSIGNMENTS.contains(expression.getOperationToken()) && (assignedName = this.extractAssignedName(expression)) != null) {
                PsiElement psiElement = expression.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"expression.parent");
                this.visitAssignment(assignedName, psiElement);
            }
            super.visitBinaryExpression(expression);
        }

        private final String extractAssignedName(KtBinaryExpression expression) {
            KtExpression leftSide = expression.getLeft();
            if (leftSide instanceof KtDotQualifiedExpression && ((KtDotQualifiedExpression)leftSide).getReceiverExpression() instanceof KtThisExpression) {
                KtExpression ktExpression = ((KtDotQualifiedExpression)leftSide).getSelectorExpression();
                return ktExpression != null ? ktExpression.getText() : null;
            }
            KtExpression ktExpression = leftSide;
            return ktExpression != null ? ktExpression.getText() : null;
        }

        private final void visitAssignment(String assignedName, PsiElement context) {
            Set<PsiElement> potentialContexts = this.contextsByDeclarationName.get(assignedName);
            if (potentialContexts != null) {
                Object v0;
                block5: {
                    Sequence actualContextChain2;
                    Sequence $this$firstOrNull$iv = actualContextChain2 = SequencesKt.generateSequence((Object)context, (Function1)visitAssignment.actualContextChain.1.INSTANCE);
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        PsiElement it = (PsiElement)element$iv;
                        boolean bl = false;
                        if (!potentialContexts.contains(it)) continue;
                        v0 = element$iv;
                        break block5;
                    }
                    v0 = null;
                }
                PsiElement actualContext = v0;
                if (actualContext != null) {
                    Set set;
                    Map<String, Set<PsiElement>> $this$getOrPut$iv = this.assignments;
                    boolean $i$f$getOrPut = false;
                    Set value$iv = $this$getOrPut$iv.get(assignedName);
                    if (value$iv == null) {
                        boolean bl = false;
                        boolean bl2 = false;
                        Set answer$iv = new LinkedHashSet();
                        $this$getOrPut$iv.put(assignedName, answer$iv);
                        set = answer$iv;
                    } else {
                        set = value$iv;
                    }
                    Set nameAssignments = set;
                    nameAssignments.add((PsiElement)actualContext);
                }
            }
        }

        public AssignmentVisitor() {
            boolean bl = false;
            this.declarations = new LinkedHashSet();
            bl = false;
            this.contextsByDeclarationName = new LinkedHashMap();
            bl = false;
            this.assignments = new LinkedHashMap();
        }
    }
}

