/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementUtilsKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\n*\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\fH\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnnecessaryFilter;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "checkNextLeaf", "leafName", "Lorg/jetbrains/kotlin/name/FqName;", "correctOperator", "", "lambda", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "Companion", "detekt-rules-style"})
public final class UnnecessaryFilter
extends Rule {
    @NotNull
    private final Issue issue;
    private static final FqName sizeFqName;
    private static final FqName isEmptyFqName;
    private static final FqName isNotEmptyFqName;
    private static final FqName collectionCountFqName;
    private static final FqName sequencesCountFqName;
    private static final List<FqName> filterFqNames;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitCallExpression(@NotNull KtCallExpression expression) {
        KtExpression calleeExpression;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitCallExpression(expression);
        if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
            return;
        }
        KtExpression ktExpression = calleeExpression = expression.getCalleeExpression();
        if (Intrinsics.areEqual((Object)(ktExpression != null ? ktExpression.getText() : null), (Object)"filter") ^ true) {
            return;
        }
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression), (BindingContext)this.getBindingContext());
        if (resolvedCall == null) {
            return;
        }
        ResolvedCall resolvedCall2 = resolvedCall;
        if (!CollectionsKt.contains((Iterable)filterFqNames, (Object)DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)resolvedCall2.getResultingDescriptor())))) {
            return;
        }
        UnnecessaryFilter.checkNextLeaf$default(this, expression, sizeFqName, null, 2, null);
        UnnecessaryFilter.checkNextLeaf$default(this, expression, collectionCountFqName, null, 2, null);
        UnnecessaryFilter.checkNextLeaf$default(this, expression, sequencesCountFqName, null, 2, null);
        this.checkNextLeaf(expression, isEmptyFqName, "any");
        this.checkNextLeaf(expression, isNotEmptyFqName, "none");
    }

    private final void checkNextLeaf(KtCallExpression $this$checkNextLeaf, FqName leafName, String correctOperator) {
        String string = leafName.shortName().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"leafName.shortName().toString()");
        String shortName = string;
        PsiElement psiElement = PsiUtilsKt.nextLeaf((PsiElement)((PsiElement)$this$checkNextLeaf), (Function1)((Function1)new Function1<PsiElement, Boolean>(shortName){
            final /* synthetic */ String $shortName;

            public final boolean invoke(@NotNull PsiElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.getText(), (Object)this.$shortName);
            }
            {
                this.$shortName = string;
                super(1);
            }
        }));
        Object object = psiElement != null ? psiElement.getParent() : null;
        if (!(object instanceof KtElement)) {
            object = null;
        }
        KtElement ktElement = (KtElement)object;
        if (ktElement == null) {
            return;
        }
        KtElement nextLeaf2 = ktElement;
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)nextLeaf2, (BindingContext)this.getBindingContext());
        if (resolvedCall == null) {
            return;
        }
        ResolvedCall resolvedCall2 = resolvedCall;
        if (Intrinsics.areEqual((Object)DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)resolvedCall2.getResultingDescriptor())), (Object)leafName) ^ true) {
            return;
        }
        Issue issue = this.getIssue();
        Entity entity = Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)$this$checkNextLeaf), (int)0, (int)2, null);
        StringBuilder stringBuilder = new StringBuilder().append('\'').append($this$checkNextLeaf.getText()).append("' can be replaced by '");
        String string2 = correctOperator;
        if (string2 == null) {
            string2 = shortName;
        }
        KtLambdaExpression ktLambdaExpression = this.lambda($this$checkNextLeaf);
        this.report((Finding)new CodeSmell(issue, entity, stringBuilder.append(string2).append(' ').append(ktLambdaExpression != null ? ktLambdaExpression.getText() : null).append('\'').toString(), null, null, 24, null));
    }

    static /* synthetic */ void checkNextLeaf$default(UnnecessaryFilter unnecessaryFilter, KtCallExpression ktCallExpression, FqName fqName, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        unnecessaryFilter.checkNextLeaf(ktCallExpression, fqName, string);
    }

    private final KtLambdaExpression lambda(KtCallExpression $this$lambda) {
        KtValueArgument argument;
        KtValueArgument ktValueArgument;
        KtValueArgument ktValueArgument2;
        List list = $this$lambda.getLambdaArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"lambdaArguments");
        KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.singleOrNull((List)list);
        if (ktLambdaArgument != null) {
            ktValueArgument2 = (KtValueArgument)ktLambdaArgument;
        } else {
            List list2 = $this$lambda.getValueArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"valueArguments");
            ktValueArgument2 = (KtValueArgument)CollectionsKt.singleOrNull((List)list2);
        }
        return (ktValueArgument = (argument = ktValueArgument2)) != null && (ktValueArgument = ktValueArgument.getArgumentExpression()) != null ? KtElementUtilsKt.unpackFunctionLiteral$default((KtExpression)ktValueArgument, (boolean)false, (int)1, null) : null;
    }

    public UnnecessaryFilter(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("UnnecessaryFilter", Severity.Style, "filter() with other collection operations may be simplified.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ UnnecessaryFilter(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public UnnecessaryFilter() {
        this(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        sizeFqName = new FqName("kotlin.collections.List.size");
        isEmptyFqName = new FqName("kotlin.collections.List.isEmpty");
        isNotEmptyFqName = new FqName("kotlin.collections.isNotEmpty");
        collectionCountFqName = new FqName("kotlin.collections.count");
        sequencesCountFqName = new FqName("kotlin.sequences.count");
        filterFqNames = CollectionsKt.listOf((Object[])new FqName[]{new FqName("kotlin.collections.filter"), new FqName("kotlin.sequences.filter")});
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnnecessaryFilter$Companion;", "", "()V", "collectionCountFqName", "Lorg/jetbrains/kotlin/name/FqName;", "filterFqNames", "", "isEmptyFqName", "isNotEmptyFqName", "sequencesCountFqName", "sizeFqName", "detekt-rules-style"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

