/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/MultilineLambdaItParameter;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "getConfig", "()Lio/gitlab/arturbosch/detekt/api/Config;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitLambdaExpression", "", "lambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "hasImplicitParameter", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "detekt-rules-style"})
public final class MultilineLambdaItParameter
extends Rule {
    @NotNull
    private final Issue issue;
    @NotNull
    private final Config config;

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    /*
     * WARNING - void declaration
     */
    public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression) {
        block4: {
            List parameterNames;
            block3: {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)lambdaExpression, (String)"lambdaExpression");
                super.visitLambdaExpression(lambdaExpression);
                if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
                    return;
                }
                Object object = lambdaExpression.getBodyExpression();
                if ((object != null && (object = object.getStatements()) != null ? object.size() : 0) <= 1) {
                    return;
                }
                List list = lambdaExpression.getValueParameters();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"lambdaExpression.valueParameters");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    KtParameter ktParameter = (KtParameter)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    void v2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
                    String string = v2.getName();
                    collection.add(string);
                }
                parameterNames = (List)destination$iv$iv;
                if (!parameterNames.contains("it")) break block3;
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)lambdaExpression), (int)0, (int)2, null), "The parameter name in a multiline lambda should not be an explicit `it`. Consider giving your parameter a readable and descriptive name.", null, null, 24, null));
                break block4;
            }
            if (!parameterNames.isEmpty() || !this.hasImplicitParameter(lambdaExpression, this.getBindingContext())) break block4;
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)lambdaExpression), (int)0, (int)2, null), "The implicit `it` should be used in a multiline lambda. Consider giving your parameter a readable and descriptive name.", null, null, 24, null));
        }
    }

    private final boolean hasImplicitParameter(KtLambdaExpression $this$hasImplicitParameter, BindingContext bindingContext) {
        Object object = (SimpleFunctionDescriptor)bindingContext.get((ReadOnlySlice)BindingContext.FUNCTION, (Object)$this$hasImplicitParameter.getFunctionLiteral());
        return (object != null && (object = object.getValueParameters()) != null ? (ValueParameterDescriptor)CollectionsKt.singleOrNull((List)object) : null) != null;
    }

    @NotNull
    public final Config getConfig() {
        return this.config;
    }

    public MultilineLambdaItParameter(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.config = config;
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Multiline lambdas should not use `it` as a parameter name", Debt.Companion.getFIVE_MINS());
    }
}

