/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.DetektVisitor;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\f\u0010\u0012\u001a\u00020\n*\u00020\u0013H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/LoopWithTooManyJumpStatements;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "maxJumpCount", "", "countBreakAndReturnStatements", "body", "Lorg/jetbrains/kotlin/psi/KtExpression;", "visitLoopExpression", "", "loopExpression", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "countBreakAndReturnStatementsInLoop", "Lorg/jetbrains/kotlin/psi/KtElement;", "Companion", "detekt-rules-style"})
public final class LoopWithTooManyJumpStatements
extends Rule {
    @NotNull
    private final Issue issue;
    private final int maxJumpCount;
    @NotNull
    public static final String MAX_JUMP_COUNT = "maxJumpCount";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitLoopExpression(@NotNull KtLoopExpression loopExpression) {
        Intrinsics.checkNotNullParameter((Object)loopExpression, (String)"loopExpression");
        if (this.countBreakAndReturnStatements(loopExpression.getBody()) > this.maxJumpCount) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)loopExpression), (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
        }
        super.visitLoopExpression(loopExpression);
    }

    private final int countBreakAndReturnStatements(KtExpression body) {
        KtExpression ktExpression = body;
        return ktExpression != null ? this.countBreakAndReturnStatementsInLoop((KtElement)ktExpression) : 0;
    }

    /*
     * WARNING - void declaration
     */
    private final int countBreakAndReturnStatementsInLoop(KtElement $this$countBreakAndReturnStatementsInLoop) {
        void count;
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        $this$countBreakAndReturnStatementsInLoop.accept((PsiElementVisitor)new DetektVisitor((Ref.IntRef)count){
            final /* synthetic */ Ref.IntRef $count;

            public void visitKtElement(@NotNull KtElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtLoopExpression) {
                    return;
                }
                if (element instanceof KtBreakExpression || element instanceof KtContinueExpression) {
                    int n = this.$count.element;
                    this.$count.element = n + 1;
                }
                PsiElement[] psiElementArray = element.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"element.children");
                PsiElement[] $this$forEach$iv = psiElementArray;
                boolean $i$f$forEach = false;
                PsiElement[] psiElementArray2 = $this$forEach$iv;
                int n = psiElementArray2.length;
                for (int i = 0; i < n; ++i) {
                    PsiElement element$iv;
                    PsiElement it = element$iv = psiElementArray2[i];
                    boolean bl = false;
                    it.accept((PsiElementVisitor)this);
                }
            }
            {
                this.$count = $captured_local_variable$0;
            }
        });
        return count.element;
    }

    public LoopWithTooManyJumpStatements(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "The loop contains more than one break or continue statement. The code should be refactored to increase readability.", Debt.Companion.getTEN_MINS());
        this.maxJumpCount = ((Number)this.valueOrDefault(MAX_JUMP_COUNT, 1)).intValue();
    }

    public /* synthetic */ LoopWithTooManyJumpStatements(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public LoopWithTooManyJumpStatements() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/LoopWithTooManyJumpStatements$Companion;", "", "()V", "MAX_JUMP_COUNT", "", "detekt-rules-style"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

