/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.performance;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.JunkKt;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/gitlab/arturbosch/detekt/rules/performance/ForEachOnRange;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "minimumRangeSize", "", "rangeOperators", "", "", "hasCorrectLowerValue", "", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "isRangeOperator", "binaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "detekt-rules-performance"})
public final class ForEachOnRange
extends Rule {
    @NotNull
    private final Issue issue;
    private final int minimumRangeSize;
    private final Set<String> rangeOperators;

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitCallExpression(@NotNull KtCallExpression expression) {
        block4: {
            KtBinaryExpression binaryExpression;
            KtParenthesizedExpression parenthesizedExpression;
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            super.visitCallExpression(expression);
            KtSimpleNameExpression ktSimpleNameExpression = KtPsiUtilKt.getCallNameExpression((KtCallElement)((KtCallElement)expression));
            if (ktSimpleNameExpression == null) break block4;
            KtSimpleNameExpression ktSimpleNameExpression2 = ktSimpleNameExpression;
            boolean bl = false;
            boolean bl2 = false;
            KtSimpleNameExpression it = ktSimpleNameExpression2;
            boolean bl3 = false;
            if (!it.textMatches((CharSequence)"forEach")) {
                return;
            }
            KtExpression ktExpression = KtPsiUtilKt.getReceiverExpression((KtSimpleNameExpression)it);
            if (!(ktExpression instanceof KtParenthesizedExpression)) {
                ktExpression = null;
            }
            KtParenthesizedExpression ktParenthesizedExpression = parenthesizedExpression = (KtParenthesizedExpression)ktExpression;
            Object object = ktParenthesizedExpression != null ? ktParenthesizedExpression.getExpression() : null;
            if (!(object instanceof KtBinaryExpression)) {
                object = null;
            }
            if ((binaryExpression = (KtBinaryExpression)object) != null && this.isRangeOperator(binaryExpression)) {
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isRangeOperator(KtBinaryExpression binaryExpression) {
        PsiElement[] range = binaryExpression.getChildren();
        if (range.length < this.minimumRangeSize) return false;
        PsiElement psiElement = range[0];
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"range[0]");
        boolean hasCorrectLowerValue = this.hasCorrectLowerValue(psiElement);
        PsiElement psiElement2 = range[2];
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"range[2]");
        boolean hasCorrectUpperValue = JunkKt.getIntValueForPsiElement((PsiElement)psiElement2) != null;
        if (!hasCorrectLowerValue) return false;
        if (!hasCorrectUpperValue) return false;
        PsiElement psiElement3 = range[1];
        Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"range[1]");
        if (!this.rangeOperators.contains(psiElement3.getText())) return false;
        return true;
    }

    private final boolean hasCorrectLowerValue(PsiElement element) {
        boolean lowerValue;
        boolean bl = lowerValue = JunkKt.getIntValueForPsiElement((PsiElement)element) != null;
        if (!lowerValue) {
            KtBinaryExpression expression;
            PsiElement psiElement = element;
            if (!(psiElement instanceof KtBinaryExpression)) {
                psiElement = null;
            }
            if ((expression = (KtBinaryExpression)psiElement) != null) {
                lowerValue = this.isRangeOperator(expression);
            }
        }
        return lowerValue;
    }

    public ForEachOnRange(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("ForEachOnRange", Severity.Performance, "Using the forEach method on ranges has a heavy performance cost. Prefer using simple for loops.", Debt.Companion.getFIVE_MINS());
        this.minimumRangeSize = 3;
        this.rangeOperators = SetsKt.setOf((Object[])new String[]{"..", "downTo", "until", "step"});
    }

    public /* synthetic */ ForEachOnRange(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public ForEachOnRange() {
        this(null, 1, null);
    }
}

