/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.cfg.WhenMissingCase;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u000f\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/MissingWhenCase;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "allowElseExpression", "", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "checkMissingWhenExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "reportMissingCases", "missingCases", "", "Lorg/jetbrains/kotlin/cfg/WhenMissingCase;", "visitWhenExpression", "Companion", "detekt-rules-errorprone"})
public final class MissingWhenCase
extends Rule {
    @NotNull
    private final Issue issue;
    private final boolean allowElseExpression;
    @NotNull
    public static final String ALLOW_ELSE_EXPRESSION = "allowElseExpression";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitWhenExpression(@NotNull KtWhenExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitWhenExpression(expression);
        if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
            return;
        }
        if (this.allowElseExpression && expression.getElseExpression() != null) {
            return;
        }
        this.checkMissingWhenExpression(expression);
    }

    private final void checkMissingWhenExpression(KtWhenExpression expression) {
        if (BindingContextUtilsKt.isUsedAsExpression((KtExpression)((KtExpression)expression), (BindingContext)this.getBindingContext())) {
            return;
        }
        KtExpression ktExpression = expression.getSubjectExpression();
        if (ktExpression == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"expression.subjectExpression ?: return");
        KtExpression subjectExpression = ktExpression;
        KotlinType subjectType = CallUtilKt.getType((KtExpression)subjectExpression, (BindingContext)this.getBindingContext());
        ClassDescriptor enumClassDescriptor = WhenChecker.getClassDescriptorOfTypeIfEnum((KotlinType)subjectType);
        ClassDescriptor sealedClassDescriptor = WhenChecker.getClassDescriptorOfTypeIfSealed((KotlinType)subjectType);
        if (enumClassDescriptor != null || sealedClassDescriptor != null) {
            List missingCases = WhenChecker.INSTANCE.getMissingCases(expression, this.getBindingContext());
            this.reportMissingCases(missingCases, expression);
        }
    }

    private final void reportMissingCases(List<? extends WhenMissingCase> missingCases, KtWhenExpression expression) {
        Collection collection = missingCases;
        boolean bl = false;
        if (!collection.isEmpty()) {
            String message = "When expression is missing cases: " + CollectionsKt.joinToString$default((Iterable)missingCases, null, null, null, (int)0, null, null, (int)63, null) + '.';
            if (this.allowElseExpression) {
                message = message + " Either add missing cases or a default `else` case.";
            }
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), message, null, null, 24, null));
        }
    }

    public MissingWhenCase(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("MissingWhenCase", Severity.Defect, "Check usage of `when` used as a statement and don't compare all enum or sealed class cases.", Debt.Companion.getTWENTY_MINS());
        this.allowElseExpression = (Boolean)this.valueOrDefault(ALLOW_ELSE_EXPRESSION, true);
    }

    public /* synthetic */ MissingWhenCase(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public MissingWhenCase() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/MissingWhenCase$Companion;", "", "()V", "ALLOW_ELSE_EXPRESSION", "", "detekt-rules-errorprone"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

