/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\f\u0010\u000f\u001a\u00020\u0006*\u00020\u000eH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/ImplicitUnitReturnType;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "allowExplicitReturnType", "", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "hasImplicitUnitReturnType", "Companion", "detekt-rules-errorprone"})
public final class ImplicitUnitReturnType
extends Rule {
    @NotNull
    private final Issue issue;
    private final boolean allowExplicitReturnType;
    @NotNull
    public static final String ALLOW_EXPLICIT_RETURN_TYPE = "allowExplicitReturnType";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        boolean isExpressionBody;
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        super.visitNamedFunction(function);
        if (Intrinsics.areEqual((Object)BindingContext.EMPTY, (Object)this.getBindingContext())) {
            return;
        }
        if (this.allowExplicitReturnType && function.hasDeclaredReturnType()) {
            return;
        }
        boolean bl = isExpressionBody = function.getBodyExpression() != null;
        if (isExpressionBody && this.hasImplicitUnitReturnType(function)) {
            boolean bl2 = false;
            boolean bl3 = false;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl4 = false;
            boolean bl5 = false;
            StringBuilder $this$buildString = stringBuilder;
            boolean bl6 = false;
            $this$buildString.append('\'' + function.getName() + "'  has the implicit return type 'Unit'.");
            $this$buildString.append(" Prefer using a block statement");
            if (this.allowExplicitReturnType) {
                $this$buildString.append(" or specify the return type explicitly");
            }
            $this$buildString.append('.');
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            String message = string;
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)function), message, null, null, 24, null));
        }
    }

    private final boolean hasImplicitUnitReturnType(KtNamedFunction $this$hasImplicitUnitReturnType) {
        KotlinType returnType;
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)$this$hasImplicitUnitReturnType.getBodyExpression()), (BindingContext)this.getBindingContext());
        KotlinType kotlinType = returnType = resolvedCall != null && (resolvedCall = resolvedCall.getResultingDescriptor()) != null ? resolvedCall.getReturnType() : null;
        return Intrinsics.areEqual((Object)(kotlinType != null ? kotlinType.toString() : null), (Object)"Unit");
    }

    public ImplicitUnitReturnType(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Defect, "Functions using expression statements have an implicit return type.\nChanging the type of the expression accidentally, changes the function return type.\nThis may lead to backward incompatibility.\nUse a block statement to make clear this function will never return a value.", Debt.Companion.getFIVE_MINS());
        this.allowExplicitReturnType = (Boolean)this.valueOrDefault(ALLOW_EXPLICIT_RETURN_TYPE, true);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/ImplicitUnitReturnType$Companion;", "", "()V", "ALLOW_EXPLICIT_RETURN_TYPE", "", "detekt-rules-errorprone"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

