/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.SplitPatternKt;
import io.gitlab.arturbosch.detekt.api.internal.PathFiltersKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/IgnoredReturnValue;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "annotationsRegexes", "", "Lkotlin/text/Regex;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "restrictToAnnotatedMethods", "", "visitCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "Companion", "detekt-rules-errorprone"})
public final class IgnoredReturnValue
extends Rule {
    @NotNull
    private final Issue issue;
    private final List<Regex> annotationsRegexes;
    private final boolean restrictToAnnotatedMethods;
    @NotNull
    public static final String RESTRICT_TO_ANNOTATED_METHODS = "restrictToAnnotatedMethods";
    public static final boolean DEFAULT_RESTRICT_TO_ANNOTATED_METHODS = true;
    @NotNull
    public static final String RETURN_VALUE_ANNOTATIONS = "returnValueAnnotations";
    @NotNull
    private static final List<String> DEFAULT_RETURN_VALUE_ANNOTATIONS;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    /*
     * WARNING - void declaration
     */
    public void visitCallExpression(@NotNull KtCallExpression expression) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitCallExpression(expression);
        if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
            return;
        }
        if (BindingContextUtilsKt.isUsedAsExpression((KtExpression)((KtExpression)expression), (BindingContext)this.getBindingContext())) {
            return;
        }
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression), (BindingContext)this.getBindingContext());
        if (resolvedCall == null || (resolvedCall = resolvedCall.getResultingDescriptor()) == null) {
            return;
        }
        ResolvedCall resultingDescriptor = resolvedCall;
        KotlinType kotlinType = resultingDescriptor.getReturnType();
        if (kotlinType != null) {
            if (TypeUtilsKt.isUnit((KotlinType)kotlinType)) {
                return;
            }
        }
        if (this.restrictToAnnotatedMethods) {
            boolean bl;
            block16: {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = (Iterable)resultingDescriptor.getAnnotations();
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    String string;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl2 = false;
                    AnnotationDescriptor it = (AnnotationDescriptor)element$iv$iv;
                    boolean bl3 = false;
                    FqName fqName = it.getFqName();
                    if ((fqName != null ? fqName.asString() : null) == null) continue;
                    string = string;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    String it$iv$iv = string;
                    boolean bl6 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List annotations = (List)destination$iv$iv;
                Iterable $this$none$iv = annotations;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        boolean bl7;
                        block15: {
                            String annotation = (String)element$iv;
                            boolean bl8 = false;
                            Iterable $this$any$iv = this.annotationsRegexes;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl7 = false;
                            } else {
                                for (Object element$iv2 : $this$any$iv) {
                                    Regex it = (Regex)element$iv2;
                                    boolean bl9 = false;
                                    String string = annotation;
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"annotation");
                                    if (!it.matches((CharSequence)string)) continue;
                                    bl7 = true;
                                    break block15;
                                }
                                bl7 = false;
                            }
                        }
                        if (!bl7) continue;
                        bl = false;
                        break block16;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return;
            }
        }
        if ((object = expression.getCalleeExpression()) == null || (object = object.getText()) == null) {
            object = expression.getText();
        }
        Object messageText = object;
        this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), "The call " + (String)messageText + " is returning a value that is ignored.", null, null, 24, null));
    }

    /*
     * WARNING - void declaration
     */
    public IgnoredReturnValue(@NotNull Config config) {
        Collection<Regex> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("IgnoredReturnValue", Severity.Defect, "This call returns a value which is ignored", Debt.Companion.getTWENTY_MINS());
        Iterable iterable = CollectionsKt.distinct((Iterable)PathFiltersKt.valueOrDefaultCommaSeparated((Config)this, (String)RETURN_VALUE_ANNOTATIONS, DEFAULT_RETURN_VALUE_ANNOTATIONS));
        IgnoredReturnValue ignoredReturnValue = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Regex regex = SplitPatternKt.simplePatternToRegex((String)it);
            collection.add(regex);
        }
        collection = (List)destination$iv$iv;
        ignoredReturnValue.annotationsRegexes = collection;
        this.restrictToAnnotatedMethods = (Boolean)this.valueOrDefault(RESTRICT_TO_ANNOTATED_METHODS, true);
    }

    public /* synthetic */ IgnoredReturnValue(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public IgnoredReturnValue() {
        this(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        DEFAULT_RETURN_VALUE_ANNOTATIONS = CollectionsKt.listOf((Object[])new String[]{"*.CheckReturnValue", "*.CheckResult"});
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/IgnoredReturnValue$Companion;", "", "()V", "DEFAULT_RESTRICT_TO_ANNOTATED_METHODS", "", "DEFAULT_RETURN_VALUE_ANNOTATIONS", "", "", "getDEFAULT_RETURN_VALUE_ANNOTATIONS", "()Ljava/util/List;", "RESTRICT_TO_ANNOTATED_METHODS", "RETURN_VALUE_ANNOTATIONS", "detekt-rules-errorprone"})
    public static final class Companion {
        @NotNull
        public final List<String> getDEFAULT_RETURN_VALUE_ANNOTATIONS() {
            return DEFAULT_RETURN_VALUE_ANNOTATIONS;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

