/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/HasPlatformType;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitKtElement", "", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "hasImplicitPlatformType", "", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "detekt-rules-errorprone"})
public final class HasPlatformType
extends Rule {
    @NotNull
    private final Issue issue;

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitKtElement(@NotNull KtElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.visitKtElement(element);
        if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
            return;
        }
        if (element instanceof KtCallableDeclaration && this.hasImplicitPlatformType((KtCallableDeclaration)element)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)element), (int)0, (int)2, null), element + " has implicit platform type. Type must be declared explicitly.", null, null, 24, null));
        }
    }

    private final boolean hasImplicitPlatformType(KtCallableDeclaration $this$hasImplicitPlatformType) {
        Function0<Boolean> $fun$isPlatFormType$1 = new Function0<Boolean>(this, $this$hasImplicitPlatformType){
            final /* synthetic */ HasPlatformType this$0;
            final /* synthetic */ KtCallableDeclaration $this_hasImplicitPlatformType;

            public final boolean invoke() {
                Object object;
                KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)this.$this_hasImplicitPlatformType));
                if (ktClassOrObject != null) {
                    if (ktClassOrObject.isLocal()) {
                        return false;
                    }
                }
                if (!((object = this.this$0.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)this.$this_hasImplicitPlatformType)) instanceof CallableDescriptor)) {
                    object = null;
                }
                CallableDescriptor callableDescriptor = (CallableDescriptor)object;
                if (callableDescriptor == null) {
                    return false;
                }
                CallableDescriptor callable = callableDescriptor;
                boolean isPublicApi = callable.getVisibility().isPublicAPI();
                KotlinType kotlinType = callable.getReturnType();
                Boolean isReturnTypeFlexible = kotlinType != null ? Boolean.valueOf(FlexibleTypesKt.isFlexible((KotlinType)kotlinType)) : null;
                return isPublicApi && Intrinsics.areEqual((Object)isReturnTypeFlexible, (Object)true);
            }
            {
                this.this$0 = hasPlatformType;
                this.$this_hasImplicitPlatformType = ktCallableDeclaration;
                super(0);
            }
        };
        KtCallableDeclaration ktCallableDeclaration = $this$hasImplicitPlatformType;
        return ktCallableDeclaration instanceof KtFunction ? !((KtFunction)$this$hasImplicitPlatformType).isLocal() && !((KtFunction)$this$hasImplicitPlatformType).hasDeclaredReturnType() && $fun$isPlatFormType$1.invoke() : (ktCallableDeclaration instanceof KtProperty ? !((KtProperty)$this$hasImplicitPlatformType).isLocal() && ((KtProperty)$this$hasImplicitPlatformType).getTypeReference() == null && $fun$isPlatFormType$1.invoke() : false);
    }

    public HasPlatformType(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("HasPlatformType", Severity.Maintainability, "Platform types must be declared explicitly in public APIs.", Debt.Companion.getFIVE_MINS());
    }
}

