/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.complexity;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.DetektVisitor;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.LazyRegex;
import io.gitlab.arturbosch.detekt.api.Metric;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.ThresholdRule;
import io.gitlab.arturbosch.detekt.api.ThresholdedCodeSmell;
import io.gitlab.arturbosch.detekt.rules.complexity.StringLiteralDuplication;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0002\u0018\u0019B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/StringLiteralDuplication;", "Lio/gitlab/arturbosch/detekt/api/ThresholdRule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "threshold", "", "(Lio/gitlab/arturbosch/detekt/api/Config;I)V", "excludeStringsWithLessThan5Characters", "", "ignoreAnnotation", "ignoreStringsRegex", "Lkotlin/text/Regex;", "getIgnoreStringsRegex", "()Lkotlin/text/Regex;", "ignoreStringsRegex$delegate", "Lio/gitlab/arturbosch/detekt/api/LazyRegex;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitKtFile", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "StringLiteralVisitor", "detekt-rules-complexity"})
public final class StringLiteralDuplication
extends ThresholdRule {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    private final boolean ignoreAnnotation;
    private final boolean excludeStringsWithLessThan5Characters;
    private final LazyRegex ignoreStringsRegex$delegate;
    public static final int DEFAULT_DUPLICATION = 3;
    public static final int STRING_EXCLUSION_LENGTH = 5;
    @NotNull
    public static final String IGNORE_ANNOTATION = "ignoreAnnotation";
    @NotNull
    public static final String EXCLUDE_SHORT_STRING = "excludeStringsWithLessThan5Characters";
    @NotNull
    public static final String IGNORE_STRINGS_REGEX = "ignoreStringsRegex";
    @NotNull
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl(StringLiteralDuplication.class, IGNORE_STRINGS_REGEX, "getIgnoreStringsRegex()Lkotlin/text/Regex;", 0))};
        Companion = new Companion(null);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final Regex getIgnoreStringsRegex() {
        return this.ignoreStringsRegex$delegate.getValue((Rule)this, $$delegatedProperties[0]);
    }

    /*
     * WARNING - void declaration
     */
    public void visitKtFile(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        StringLiteralVisitor visitor = new StringLiteralVisitor();
        file.accept((PsiElementVisitor)visitor);
        String type = "SIZE: ";
        Object object = visitor.getLiteralsOverThreshold();
        boolean bl = false;
        Iterator<Map.Entry<String, Integer>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void main;
            void name;
            Entity entity;
            Entity entity2 = entity = iterator.next();
            boolean bl2 = false;
            object = entity2.getKey();
            entity2 = entity;
            bl2 = false;
            int value = ((Number)entity2.getValue()).intValue();
            Pair<Entity, List<Entity>> pair = visitor.entitiesForLiteral((String)name);
            entity2 = (Entity)pair.component1();
            List references = (List)pair.component2();
            this.report((Finding)new ThresholdedCodeSmell(this.getIssue(), (Entity)main, new Metric(type + (String)name, value, this.getThreshold(), false, 0, 24, null), this.getIssue().getDescription(), references));
        }
    }

    public StringLiteralDuplication(@NotNull Config config, int threshold) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, threshold);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Maintainability, "Multiple occurrences of the same string literal within a single file detected.", Debt.Companion.getFIVE_MINS());
        this.ignoreAnnotation = (Boolean)this.valueOrDefault(IGNORE_ANNOTATION, true);
        this.excludeStringsWithLessThan5Characters = (Boolean)this.valueOrDefault(EXCLUDE_SHORT_STRING, true);
        this.ignoreStringsRegex$delegate = new LazyRegex(IGNORE_STRINGS_REGEX, "$^");
    }

    public /* synthetic */ StringLiteralDuplication(Config config, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        if ((n2 & 2) != 0) {
            n = 3;
        }
        this(config, n);
    }

    public StringLiteralDuplication() {
        this(null, 0, 3, null);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J \u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00130\u00112\u0006\u0010\u0014\u001a\u00020\u0005J\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\u0016J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0007H\u0016R6\u0010\u0003\u001a*\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004j\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006`\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n`\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0019"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/StringLiteralDuplication$StringLiteralVisitor;", "Lio/gitlab/arturbosch/detekt/api/DetektVisitor;", "(Lio/gitlab/arturbosch/detekt/rules/complexity/StringLiteralDuplication;)V", "literalReferences", "Ljava/util/HashMap;", "", "", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "Lkotlin/collections/HashMap;", "literals", "", "pass", "", "Lkotlin/Unit;", "add", "str", "entitiesForLiteral", "Lkotlin/Pair;", "Lio/gitlab/arturbosch/detekt/api/Entity;", "", "literal", "getLiteralsOverThreshold", "", "visitStringTemplateExpression", "expression", "detekt-rules-complexity"})
    public final class StringLiteralVisitor
    extends DetektVisitor {
        private HashMap<String, Integer> literals = new HashMap();
        private HashMap<String, List<KtStringTemplateExpression>> literalReferences = new HashMap();
        private final Unit pass = Unit.INSTANCE;

        @NotNull
        public final Map<String, Integer> getLiteralsOverThreshold() {
            Map $this$filterValues$iv = this.literals;
            boolean $i$f$filterValues = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            Map map = $this$filterValues$iv;
            boolean bl = false;
            for (Map.Entry entry$iv : map.entrySet()) {
                int it = ((Number)entry$iv.getValue()).intValue();
                boolean bl2 = false;
                if (!(it >= StringLiteralDuplication.this.getThreshold())) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            return result$iv;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Pair<Entity, List<Entity>> entitiesForLiteral(@NotNull String literal) {
            boolean bl;
            Object object;
            Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
            List<KtStringTemplateExpression> references = this.literalReferences.get(literal);
            if (references != null) {
                object = references;
                bl = false;
                if (!object.isEmpty()) {
                    Collection<Entity> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    KtStringTemplateExpression mainEntity = references.get(0);
                    List<KtStringTemplateExpression> referenceEntities = references.subList(1, references.size());
                    Iterable iterable = referenceEntities;
                    Entity entity = Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)mainEntity), (int)0, (int)2, null);
                    boolean $i$f$map = false;
                    void var7_9 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        KtStringTemplateExpression ktStringTemplateExpression = (KtStringTemplateExpression)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl2 = false;
                        Entity entity2 = Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)it), (int)0, (int)2, null);
                        collection.add(entity2);
                    }
                    collection = (List)destination$iv$iv;
                    return TuplesKt.to((Object)entity, (Object)collection);
                }
            }
            object = "No KtElements for literal '" + literal + "' found!";
            bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }

        /*
         * Enabled aggressive block sorting
         */
        public void visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            String text = KtPsiUtilKt.getPlainContent((KtStringTemplateExpression)expression);
            if (StringLiteralDuplication.this.ignoreAnnotation) {
                PsiElement $this$isPartOf$iv = (PsiElement)expression;
                boolean $i$f$isPartOf = false;
                PsiElement $this$getNonStrictParentOfType$iv$iv = $this$isPartOf$iv;
                boolean $i$f$getNonStrictParentOfType = false;
                if (PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv$iv, KtAnnotationEntry.class, (boolean)false) != null) {
                    return;
                }
                boolean bl = false;
                if (bl) {
                    return;
                }
            }
            if (StringLiteralDuplication.this.excludeStringsWithLessThan5Characters && text.length() < 5) {
                return;
            }
            CharSequence charSequence = text;
            Regex regex = StringLiteralDuplication.this.getIgnoreStringsRegex();
            boolean bl = false;
            if (regex.matches(charSequence)) {
                return;
            }
            this.add(expression);
        }

        private final void add(KtStringTemplateExpression str) {
            String text = KtPsiUtilKt.getPlainContent((KtStringTemplateExpression)str);
            this.literals.compute(text, add.1.INSTANCE);
            this.literalReferences.compute(text, new BiFunction<String, List<KtStringTemplateExpression>, List<KtStringTemplateExpression>>(str){
                final /* synthetic */ KtStringTemplateExpression $str;

                @Nullable
                public final List<KtStringTemplateExpression> apply(@NotNull String $noName_0, @Nullable List<KtStringTemplateExpression> entries) {
                    List list;
                    Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"<anonymous parameter 0>");
                    List list2 = entries;
                    if (list2 != null) {
                        list2.add((KtStringTemplateExpression)this.$str);
                    }
                    if ((list = entries) == null) {
                        list = CollectionsKt.mutableListOf((Object[])new KtStringTemplateExpression[]{this.$str});
                    }
                    return list;
                }
                {
                    this.$str = ktStringTemplateExpression;
                }
            });
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/StringLiteralDuplication$Companion;", "", "()V", "DEFAULT_DUPLICATION", "", "EXCLUDE_SHORT_STRING", "", "IGNORE_ANNOTATION", "IGNORE_STRINGS_REGEX", "STRING_EXCLUSION_LENGTH", "detekt-rules-complexity"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

