/*
 * Decompiled with CFR 0.152.
 */
package io.github.detekt.sarif4j;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.github.detekt.sarif4j.Message;
import io.github.detekt.sarif4j.PropertyBag;
import io.github.detekt.sarif4j.StackFrame;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder(value={"message", "frames", "properties"})
public class Stack {
    @JsonProperty(value="message")
    @JsonPropertyDescription(value="Encapsulates a message intended to be read by the end user.")
    private Message message;
    @JsonProperty(value="frames")
    @JsonPropertyDescription(value="An array of stack frames that represents a sequence of calls, rendered in reverse chronological order, that comprise the call stack.")
    private List<StackFrame> frames = null;
    @JsonProperty(value="properties")
    @JsonPropertyDescription(value="Key/value pairs that provide additional information about the object.")
    private PropertyBag properties;

    @JsonProperty(value="message")
    public Message getMessage() {
        return this.message;
    }

    @JsonProperty(value="message")
    public void setMessage(Message message) {
        this.message = message;
    }

    public Stack withMessage(Message message) {
        this.message = message;
        return this;
    }

    @JsonProperty(value="frames")
    public List<StackFrame> getFrames() {
        return this.frames;
    }

    @JsonProperty(value="frames")
    public void setFrames(List<StackFrame> frames) {
        this.frames = frames;
    }

    public Stack withFrames(List<StackFrame> frames) {
        this.frames = frames;
        return this;
    }

    @JsonProperty(value="properties")
    public PropertyBag getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    public void setProperties(PropertyBag properties) {
        this.properties = properties;
    }

    public Stack withProperties(PropertyBag properties) {
        this.properties = properties;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Stack.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("message");
        sb.append('=');
        sb.append(this.message == null ? "<null>" : this.message);
        sb.append(',');
        sb.append("frames");
        sb.append('=');
        sb.append(this.frames == null ? "<null>" : this.frames);
        sb.append(',');
        sb.append("properties");
        sb.append('=');
        sb.append(this.properties == null ? "<null>" : this.properties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.message == null ? 0 : this.message.hashCode());
        result = result * 31 + (this.frames == null ? 0 : this.frames.hashCode());
        result = result * 31 + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Stack)) {
            return false;
        }
        Stack rhs = (Stack)other;
        return (this.message == rhs.message || this.message != null && this.message.equals(rhs.message)) && (this.frames == rhs.frames || this.frames != null && this.frames.equals(rhs.frames)) && (this.properties == rhs.properties || this.properties != null && this.properties.equals(rhs.properties));
    }
}

