/*
 * Decompiled with CFR 0.152.
 */
package io.github.detekt.sarif4j;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.github.detekt.sarif4j.Exception;
import io.github.detekt.sarif4j.Location;
import io.github.detekt.sarif4j.Message;
import io.github.detekt.sarif4j.PropertyBag;
import io.github.detekt.sarif4j.ReportingDescriptorReference;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder(value={"locations", "message", "level", "threadId", "timeUtc", "exception", "descriptor", "associatedRule", "properties"})
public class Notification {
    @JsonProperty(value="locations")
    @JsonDeserialize(as=LinkedHashSet.class)
    @JsonPropertyDescription(value="The locations relevant to this notification.")
    private Set<Location> locations = null;
    @JsonProperty(value="message")
    @JsonPropertyDescription(value="Encapsulates a message intended to be read by the end user.")
    private Message message;
    @JsonProperty(value="level")
    @JsonPropertyDescription(value="A value specifying the severity level of the notification.")
    private Level level = Level.fromValue("warning");
    @JsonProperty(value="threadId")
    @JsonPropertyDescription(value="The thread identifier of the code that generated the notification.")
    private Integer threadId;
    @JsonProperty(value="timeUtc")
    @JsonPropertyDescription(value="The Coordinated Universal Time (UTC) date and time at which the analysis tool generated the notification.")
    private Date timeUtc;
    @JsonProperty(value="exception")
    @JsonPropertyDescription(value="Describes a runtime exception encountered during the execution of an analysis tool.")
    private Exception exception;
    @JsonProperty(value="descriptor")
    @JsonPropertyDescription(value="Information about how to locate a relevant reporting descriptor.")
    private ReportingDescriptorReference descriptor;
    @JsonProperty(value="associatedRule")
    @JsonPropertyDescription(value="Information about how to locate a relevant reporting descriptor.")
    private ReportingDescriptorReference associatedRule;
    @JsonProperty(value="properties")
    @JsonPropertyDescription(value="Key/value pairs that provide additional information about the object.")
    private PropertyBag properties;

    @JsonProperty(value="locations")
    public Set<Location> getLocations() {
        return this.locations;
    }

    @JsonProperty(value="locations")
    public void setLocations(Set<Location> locations) {
        this.locations = locations;
    }

    public Notification withLocations(Set<Location> locations) {
        this.locations = locations;
        return this;
    }

    @JsonProperty(value="message")
    public Message getMessage() {
        return this.message;
    }

    @JsonProperty(value="message")
    public void setMessage(Message message) {
        this.message = message;
    }

    public Notification withMessage(Message message) {
        this.message = message;
        return this;
    }

    @JsonProperty(value="level")
    public Level getLevel() {
        return this.level;
    }

    @JsonProperty(value="level")
    public void setLevel(Level level) {
        this.level = level;
    }

    public Notification withLevel(Level level) {
        this.level = level;
        return this;
    }

    @JsonProperty(value="threadId")
    public Integer getThreadId() {
        return this.threadId;
    }

    @JsonProperty(value="threadId")
    public void setThreadId(Integer threadId) {
        this.threadId = threadId;
    }

    public Notification withThreadId(Integer threadId) {
        this.threadId = threadId;
        return this;
    }

    @JsonProperty(value="timeUtc")
    public Date getTimeUtc() {
        return this.timeUtc;
    }

    @JsonProperty(value="timeUtc")
    public void setTimeUtc(Date timeUtc) {
        this.timeUtc = timeUtc;
    }

    public Notification withTimeUtc(Date timeUtc) {
        this.timeUtc = timeUtc;
        return this;
    }

    @JsonProperty(value="exception")
    public Exception getException() {
        return this.exception;
    }

    @JsonProperty(value="exception")
    public void setException(Exception exception) {
        this.exception = exception;
    }

    public Notification withException(Exception exception) {
        this.exception = exception;
        return this;
    }

    @JsonProperty(value="descriptor")
    public ReportingDescriptorReference getDescriptor() {
        return this.descriptor;
    }

    @JsonProperty(value="descriptor")
    public void setDescriptor(ReportingDescriptorReference descriptor) {
        this.descriptor = descriptor;
    }

    public Notification withDescriptor(ReportingDescriptorReference descriptor) {
        this.descriptor = descriptor;
        return this;
    }

    @JsonProperty(value="associatedRule")
    public ReportingDescriptorReference getAssociatedRule() {
        return this.associatedRule;
    }

    @JsonProperty(value="associatedRule")
    public void setAssociatedRule(ReportingDescriptorReference associatedRule) {
        this.associatedRule = associatedRule;
    }

    public Notification withAssociatedRule(ReportingDescriptorReference associatedRule) {
        this.associatedRule = associatedRule;
        return this;
    }

    @JsonProperty(value="properties")
    public PropertyBag getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    public void setProperties(PropertyBag properties) {
        this.properties = properties;
    }

    public Notification withProperties(PropertyBag properties) {
        this.properties = properties;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Notification.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("locations");
        sb.append('=');
        sb.append(this.locations == null ? "<null>" : this.locations);
        sb.append(',');
        sb.append("message");
        sb.append('=');
        sb.append(this.message == null ? "<null>" : this.message);
        sb.append(',');
        sb.append("level");
        sb.append('=');
        sb.append(this.level == null ? "<null>" : this.level);
        sb.append(',');
        sb.append("threadId");
        sb.append('=');
        sb.append(this.threadId == null ? "<null>" : this.threadId);
        sb.append(',');
        sb.append("timeUtc");
        sb.append('=');
        sb.append(this.timeUtc == null ? "<null>" : this.timeUtc);
        sb.append(',');
        sb.append("exception");
        sb.append('=');
        sb.append(this.exception == null ? "<null>" : this.exception);
        sb.append(',');
        sb.append("descriptor");
        sb.append('=');
        sb.append(this.descriptor == null ? "<null>" : this.descriptor);
        sb.append(',');
        sb.append("associatedRule");
        sb.append('=');
        sb.append(this.associatedRule == null ? "<null>" : this.associatedRule);
        sb.append(',');
        sb.append("properties");
        sb.append('=');
        sb.append(this.properties == null ? "<null>" : this.properties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.threadId == null ? 0 : this.threadId.hashCode());
        result = result * 31 + (this.exception == null ? 0 : this.exception.hashCode());
        result = result * 31 + (this.level == null ? 0 : this.level.hashCode());
        result = result * 31 + (this.associatedRule == null ? 0 : this.associatedRule.hashCode());
        result = result * 31 + (this.timeUtc == null ? 0 : this.timeUtc.hashCode());
        result = result * 31 + (this.locations == null ? 0 : this.locations.hashCode());
        result = result * 31 + (this.descriptor == null ? 0 : this.descriptor.hashCode());
        result = result * 31 + (this.message == null ? 0 : this.message.hashCode());
        result = result * 31 + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Notification)) {
            return false;
        }
        Notification rhs = (Notification)other;
        return (this.threadId == rhs.threadId || this.threadId != null && this.threadId.equals(rhs.threadId)) && (this.exception == rhs.exception || this.exception != null && this.exception.equals(rhs.exception)) && (this.level == rhs.level || this.level != null && this.level.equals((Object)rhs.level)) && (this.associatedRule == rhs.associatedRule || this.associatedRule != null && this.associatedRule.equals(rhs.associatedRule)) && (this.timeUtc == rhs.timeUtc || this.timeUtc != null && this.timeUtc.equals(rhs.timeUtc)) && (this.locations == rhs.locations || this.locations != null && this.locations.equals(rhs.locations)) && (this.descriptor == rhs.descriptor || this.descriptor != null && this.descriptor.equals(rhs.descriptor)) && (this.message == rhs.message || this.message != null && this.message.equals(rhs.message)) && (this.properties == rhs.properties || this.properties != null && this.properties.equals(rhs.properties));
    }

    public static enum Level {
        NONE("none"),
        NOTE("note"),
        WARNING("warning"),
        ERROR("error");

        private final String value;
        private static final Map<String, Level> CONSTANTS;

        private Level(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Level fromValue(String value) {
            Level constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Level>();
            for (Level c : Level.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

