/*
 * Decompiled with CFR 0.152.
 */
package io.github.detekt.sarif4j;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.github.detekt.sarif4j.SarifJsonWriter;
import io.github.detekt.sarif4j.SarifSchema210;
import java.io.UncheckedIOException;

public class JacksonSarifWriter
implements SarifJsonWriter {
    private final ObjectMapper mapper;

    public JacksonSarifWriter() {
        this(new ObjectMapper());
    }

    public JacksonSarifWriter(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public String toMinifiedJson(SarifSchema210 sarif) {
        try {
            this.mapper.disable(SerializationFeature.INDENT_OUTPUT);
            return this.mapper.writeValueAsString(sarif);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public String toJson(SarifSchema210 sarif) {
        try {
            this.mapper.enable(SerializationFeature.INDENT_OUTPUT);
            return this.mapper.writeValueAsString(sarif);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException(e);
        }
    }
}

