/*
 * Decompiled with CFR 0.152.
 */
package io.github.detekt.sarif4j;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum Content {
    LOCALIZED_DATA("localizedData"),
    NON_LOCALIZED_DATA("nonLocalizedData");

    private final String value;
    private static final Map<String, Content> CONSTANTS;

    private Content(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static Content fromValue(String value) {
        Content constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, Content>();
        for (Content c : Content.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

