/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt;

import io.gitlab.arturbosch.detekt.Detekt;
import io.gitlab.arturbosch.detekt.DetektCreateBaselineTask;
import io.gitlab.arturbosch.detekt.DetektGenerateConfigTask;
import io.gitlab.arturbosch.detekt.extensions.DetektExtension;
import io.gitlab.arturbosch.detekt.internal.DetektAndroid;
import io.gitlab.arturbosch.detekt.internal.DetektJvm;
import io.gitlab.arturbosch.detekt.internal.DetektMultiplatform;
import io.gitlab.arturbosch.detekt.internal.DetektPlain;
import io.gitlab.arturbosch.detekt.internal.GradleCompatKt;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.plugins.ReportingBasePlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.services.BuildServiceSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0014\u0010\b\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0014\u0010\u000b\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0014\u0010\f\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0014\u0010\r\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0014\u0010\u000e\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u00a8\u0006\u0012"}, d2={"Lio/gitlab/arturbosch/detekt/DetektPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "<init>", "()V", "apply", "", "project", "registerDetektJvmTasks", "extension", "Lio/gitlab/arturbosch/detekt/extensions/DetektExtension;", "registerDetektMultiplatformTasks", "registerDetektAndroidTasks", "registerDetektPlainTask", "registerGenerateConfigTask", "configurePluginDependencies", "setTaskDefaults", "Companion", "detekt-gradle-plugin"})
public final class DetektPlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String DETEKT_TASK_NAME = "detekt";
    @NotNull
    public static final String BASELINE_TASK_NAME = "detektBaseline";
    @NotNull
    public static final String DETEKT_EXTENSION = "detekt";
    @NotNull
    private static final String GENERATE_CONFIG = "detektGenerateConfig";
    @NotNull
    private static final List<String> defaultExcludes = CollectionsKt.listOf((Object)"build/");
    @NotNull
    private static final List<String> defaultIncludes;
    @NotNull
    public static final String CONFIG_DIR_NAME = "config/detekt";
    @NotNull
    public static final String CONFIG_FILE = "detekt.yml";
    @NotNull
    public static final String DETEKT_ANDROID_DISABLED_PROPERTY = "detekt.android.disabled";
    @NotNull
    public static final String DETEKT_MULTIPLATFORM_DISABLED_PROPERTY = "detekt.multiplatform.disabled";

    public void apply(@NotNull Project project) {
        boolean enableMppTasks;
        boolean enableAndroidTasks;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        project.getPluginManager().apply(ReportingBasePlugin.class);
        DetektExtension detektExtension = (DetektExtension)((Object)project.getExtensions().findByType(DetektExtension.class));
        if (detektExtension == null) {
            detektExtension = (DetektExtension)((Object)project.getExtensions().create("detekt", DetektExtension.class, new Object[0]));
        }
        DetektExtension extension = detektExtension;
        extension.setReportsDir(((ReportingExtension)project.getExtensions().getByType(ReportingExtension.class)).file("detekt"));
        File defaultConfigFile = project.file((Object)(GradleCompatKt.rootProjectDirectoryCompat(project).dir(CONFIG_DIR_NAME) + "/detekt.yml"));
        if (defaultConfigFile.exists()) {
            Object[] objectArray = new Object[]{defaultConfigFile};
            extension.getConfig().setFrom((Iterable)project.files(objectArray));
        }
        Intrinsics.checkNotNull((Object)((Object)extension));
        this.configurePluginDependencies(project, extension);
        this.setTaskDefaults(project);
        this.registerDetektPlainTask(project, extension);
        this.registerDetektJvmTasks(project, extension);
        ProviderFactory providerFactory = project.getProviders();
        Intrinsics.checkNotNullExpressionValue((Object)providerFactory, (String)"getProviders(...)");
        boolean bl = enableAndroidTasks = !Boolean.parseBoolean((String)GradleCompatKt.gradlePropertyAtConfigTimeCompat(providerFactory, DETEKT_ANDROID_DISABLED_PROPERTY).getOrElse((Object)"false"));
        if (enableAndroidTasks) {
            this.registerDetektAndroidTasks(project, extension);
        }
        ProviderFactory providerFactory2 = project.getProviders();
        Intrinsics.checkNotNullExpressionValue((Object)providerFactory2, (String)"getProviders(...)");
        boolean bl2 = enableMppTasks = !Boolean.parseBoolean((String)GradleCompatKt.gradlePropertyAtConfigTimeCompat(providerFactory2, DETEKT_MULTIPLATFORM_DISABLED_PROPERTY).getOrElse((Object)"false"));
        if (enableMppTasks) {
            this.registerDetektMultiplatformTasks(project, extension);
        }
        this.registerGenerateConfigTask(project, extension);
    }

    private final void registerDetektJvmTasks(Project $this$registerDetektJvmTasks, DetektExtension extension) {
        $this$registerDetektJvmTasks.getPlugins().withId("org.jetbrains.kotlin.jvm", arg_0 -> DetektPlugin.registerDetektJvmTasks$lambda$1(arg_0 -> DetektPlugin.registerDetektJvmTasks$lambda$0($this$registerDetektJvmTasks, extension, arg_0), arg_0));
    }

    private final void registerDetektMultiplatformTasks(Project $this$registerDetektMultiplatformTasks, DetektExtension extension) {
        $this$registerDetektMultiplatformTasks.getPlugins().withId("org.jetbrains.kotlin.multiplatform", arg_0 -> DetektPlugin.registerDetektMultiplatformTasks$lambda$3(arg_0 -> DetektPlugin.registerDetektMultiplatformTasks$lambda$2($this$registerDetektMultiplatformTasks, extension, arg_0), arg_0));
    }

    private final void registerDetektAndroidTasks(Project $this$registerDetektAndroidTasks, DetektExtension extension) {
        $this$registerDetektAndroidTasks.getPlugins().withId("kotlin-android", arg_0 -> DetektPlugin.registerDetektAndroidTasks$lambda$5(arg_0 -> DetektPlugin.registerDetektAndroidTasks$lambda$4($this$registerDetektAndroidTasks, extension, arg_0), arg_0));
    }

    private final void registerDetektPlainTask(Project $this$registerDetektPlainTask, DetektExtension extension) {
        new DetektPlain($this$registerDetektPlainTask).registerTasks(extension);
    }

    private final void registerGenerateConfigTask(Project $this$registerGenerateConfigTask, DetektExtension extension) {
        Provider detektGenerateConfigSingleExecution = $this$registerGenerateConfigTask.getProject().getGradle().getSharedServices().registerIfAbsent("DetektGenerateConfigSingleExecution", DetektGenerateConfigTask.SingleExecutionBuildService.class, arg_0 -> DetektPlugin.registerGenerateConfigTask$lambda$7(DetektPlugin::registerGenerateConfigTask$lambda$6, arg_0));
        $this$registerGenerateConfigTask.getTasks().register(GENERATE_CONFIG, DetektGenerateConfigTask.class, arg_0 -> DetektPlugin.registerGenerateConfigTask$lambda$10(arg_0 -> DetektPlugin.registerGenerateConfigTask$lambda$9($this$registerGenerateConfigTask, detektGenerateConfigSingleExecution, extension, arg_0), arg_0));
    }

    private final void configurePluginDependencies(Project project, DetektExtension extension) {
        Configuration configuration = (Configuration)project.getConfigurations().maybeCreate("detektPlugins");
        boolean bl = false;
        configuration.setVisible(false);
        configuration.setTransitive(true);
        configuration.setDescription("The detektPlugins libraries to be used for this project.");
        configuration.setCanBeResolved(true);
        configuration.setCanBeConsumed(false);
        project.getConfigurations().create("detekt", arg_0 -> DetektPlugin.configurePluginDependencies$lambda$15(arg_0 -> DetektPlugin.configurePluginDependencies$lambda$14(extension, project, arg_0), arg_0));
    }

    private final void setTaskDefaults(Project project) {
        project.getTasks().withType(Detekt.class).configureEach(arg_0 -> DetektPlugin.setTaskDefaults$lambda$17(arg_0 -> DetektPlugin.setTaskDefaults$lambda$16(project, arg_0), arg_0));
        project.getTasks().withType(DetektCreateBaselineTask.class).configureEach(arg_0 -> DetektPlugin.setTaskDefaults$lambda$19(arg_0 -> DetektPlugin.setTaskDefaults$lambda$18(project, arg_0), arg_0));
        project.getTasks().withType(DetektGenerateConfigTask.class).configureEach(arg_0 -> DetektPlugin.setTaskDefaults$lambda$21(arg_0 -> DetektPlugin.setTaskDefaults$lambda$20(project, arg_0), arg_0));
    }

    private static final Unit registerDetektJvmTasks$lambda$0(Project $this_registerDetektJvmTasks, DetektExtension $extension, Plugin it) {
        new DetektJvm($this_registerDetektJvmTasks).registerTasks($extension);
        return Unit.INSTANCE;
    }

    private static final void registerDetektJvmTasks$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit registerDetektMultiplatformTasks$lambda$2(Project $this_registerDetektMultiplatformTasks, DetektExtension $extension, Plugin it) {
        new DetektMultiplatform($this_registerDetektMultiplatformTasks).registerTasks($extension);
        return Unit.INSTANCE;
    }

    private static final void registerDetektMultiplatformTasks$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit registerDetektAndroidTasks$lambda$4(Project $this_registerDetektAndroidTasks, DetektExtension $extension, Plugin it) {
        new DetektAndroid($this_registerDetektAndroidTasks).registerTasks($extension);
        return Unit.INSTANCE;
    }

    private static final void registerDetektAndroidTasks$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit registerGenerateConfigTask$lambda$6(BuildServiceSpec spec) {
        spec.getMaxParallelUsages().set((Object)1);
        return Unit.INSTANCE;
    }

    private static final void registerGenerateConfigTask$lambda$7(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final ConfigurableFileCollection registerGenerateConfigTask$lambda$9$lambda$8(DetektExtension $extension) {
        return $extension.getConfig();
    }

    private static final Unit registerGenerateConfigTask$lambda$9(Project $this_registerGenerateConfigTask, Provider $detektGenerateConfigSingleExecution, DetektExtension $extension, DetektGenerateConfigTask it) {
        Object[] objectArray = new Object[]{$this_registerGenerateConfigTask.getProject().provider(() -> DetektPlugin.registerGenerateConfigTask$lambda$9$lambda$8($extension))};
        it.getConfig().setFrom(objectArray);
        it.usesService($detektGenerateConfigSingleExecution);
        return Unit.INSTANCE;
    }

    private static final void registerGenerateConfigTask$lambda$10(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit configurePluginDependencies$lambda$14$lambda$12(DetektExtension $extension, Project $project, DependencySet dependencySet) {
        String version = $extension.getToolVersion();
        dependencySet.add((Object)$project.getDependencies().create((Object)("io.gitlab.arturbosch.detekt:detekt-cli:" + version)));
        return Unit.INSTANCE;
    }

    private static final void configurePluginDependencies$lambda$14$lambda$13(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit configurePluginDependencies$lambda$14(DetektExtension $extension, Project $project, Configuration configuration) {
        configuration.setVisible(false);
        configuration.setTransitive(true);
        configuration.setDescription("The detekt dependencies to be used for this project.");
        configuration.setCanBeResolved(true);
        configuration.setCanBeConsumed(false);
        configuration.defaultDependencies(arg_0 -> DetektPlugin.configurePluginDependencies$lambda$14$lambda$13(arg_0 -> DetektPlugin.configurePluginDependencies$lambda$14$lambda$12($extension, $project, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final void configurePluginDependencies$lambda$15(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit setTaskDefaults$lambda$16(Project $project, Detekt it) {
        it.getDetektClasspath().setFrom((Iterable)$project.getConfigurations().getAt("detekt"));
        it.getPluginClasspath().setFrom((Iterable)$project.getConfigurations().getAt("detektPlugins"));
        return Unit.INSTANCE;
    }

    private static final void setTaskDefaults$lambda$17(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit setTaskDefaults$lambda$18(Project $project, DetektCreateBaselineTask it) {
        it.getDetektClasspath().setFrom((Iterable)$project.getConfigurations().getAt("detekt"));
        it.getPluginClasspath().setFrom((Iterable)$project.getConfigurations().getAt("detektPlugins"));
        return Unit.INSTANCE;
    }

    private static final void setTaskDefaults$lambda$19(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit setTaskDefaults$lambda$20(Project $project, DetektGenerateConfigTask it) {
        it.getDetektClasspath().setFrom((Iterable)$project.getConfigurations().getAt("detekt"));
        it.getPluginClasspath().setFrom((Iterable)$project.getConfigurations().getAt("detektPlugins"));
        return Unit.INSTANCE;
    }

    private static final void setTaskDefaults$lambda$21(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    static {
        Object[] objectArray = new String[]{"**/*.kt", "**/*.kts"};
        defaultIncludes = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u000e\u0010\u000f\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/gitlab/arturbosch/detekt/DetektPlugin$Companion;", "", "<init>", "()V", "DETEKT_TASK_NAME", "", "BASELINE_TASK_NAME", "DETEKT_EXTENSION", "GENERATE_CONFIG", "defaultExcludes", "", "getDefaultExcludes$detekt_gradle_plugin", "()Ljava/util/List;", "defaultIncludes", "getDefaultIncludes$detekt_gradle_plugin", "CONFIG_DIR_NAME", "CONFIG_FILE", "DETEKT_ANDROID_DISABLED_PROPERTY", "DETEKT_MULTIPLATFORM_DISABLED_PROPERTY", "detekt-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getDefaultExcludes$detekt_gradle_plugin() {
            return defaultExcludes;
        }

        @NotNull
        public final List<String> getDefaultIncludes$detekt_gradle_plugin() {
            return defaultIncludes;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

