/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt;

import io.gitlab.arturbosch.detekt.invoke.CliArgument;
import io.gitlab.arturbosch.detekt.invoke.ConfigArgument;
import io.gitlab.arturbosch.detekt.invoke.DetektInvoker;
import io.gitlab.arturbosch.detekt.invoke.GenerateConfigArgument;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0007R\u0013\u0010\u0005\u001a\u00020\u00068G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00020\u00068G\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\bR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/gitlab/arturbosch/detekt/DetektGenerateConfigTask;", "Lorg/gradle/api/DefaultTask;", "objects", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "config", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getConfig", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "defaultConfigPath", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "detektClasspath", "getDetektClasspath", "invoker", "Lio/gitlab/arturbosch/detekt/invoke/DetektInvoker;", "generateConfig", "", "detekt-gradle-plugin"})
public class DetektGenerateConfigTask
extends DefaultTask {
    @NotNull
    private final ConfigurableFileCollection detektClasspath;
    @NotNull
    private final ConfigurableFileCollection config;
    private final DetektInvoker invoker;
    private final Path defaultConfigPath;
    private final ObjectFactory objects;

    @Classpath
    @NotNull
    public final ConfigurableFileCollection getDetektClasspath() {
        return this.detektClasspath;
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final ConfigurableFileCollection getConfig() {
        return this.config;
    }

    @TaskAction
    public final void generateConfig() {
        ConfigurableFileCollection configurationToUse;
        ConfigurableFileCollection configurableFileCollection = configurationToUse = this.config.isEmpty() ? this.objects.fileCollection().from(new Object[]{this.defaultConfigPath}) : this.config;
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"configurationToUse");
        if (((File)CollectionsKt.last((Iterable)((Iterable)configurableFileCollection))).exists()) {
            this.getLogger().warn("Skipping config file generation; file already exists at " + (File)CollectionsKt.last((Iterable)((Iterable)configurationToUse)));
            return;
        }
        Object object = CollectionsKt.last((Iterable)((Iterable)configurationToUse));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"configurationToUse.last()");
        Files.createDirectories(((File)object).getParentFile().toPath(), new FileAttribute[0]);
        Object[] objectArray = new CliArgument[2];
        objectArray[0] = GenerateConfigArgument.INSTANCE;
        Object object2 = CollectionsKt.last((Iterable)((Iterable)configurationToUse));
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"configurationToUse.last()");
        objectArray[1] = new ConfigArgument((File)object2);
        List arguments = CollectionsKt.mutableListOf((Object[])objectArray);
        List list = CollectionsKt.toList((Iterable)arguments);
        FileCollection fileCollection = (FileCollection)this.detektClasspath;
        String string = this.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        DetektInvoker.DefaultImpls.invokeCli$default(this.invoker, list, fileCollection, string, false, 8, null);
    }

    @Inject
    public DetektGenerateConfigTask(@NotNull ObjectFactory objects) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        this.objects = objects;
        this.setDescription("Generate a detekt configuration file inside your project.");
        this.setGroup("verification");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        ConfigurableFileCollection configurableFileCollection = project.getObjects().fileCollection();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"project.objects.fileCollection()");
        this.detektClasspath = configurableFileCollection;
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        ConfigurableFileCollection configurableFileCollection2 = project2.getObjects().fileCollection();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection2, (String)"project.objects.fileCollection()");
        this.config = configurableFileCollection2;
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        this.invoker = DetektInvoker.Companion.create(project3);
        Project project4 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"project");
        this.defaultConfigPath = project4.getRootDir().toPath().resolve("config/detekt").resolve("detekt.yml");
    }
}

