/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm.function.catalog;

import io.github.toolfactory.jvm.function.catalog.ConsulterSupplier;
import io.github.toolfactory.jvm.function.catalog.SetAccessibleFunction;
import io.github.toolfactory.jvm.function.template.ThrowingBiConsumer;
import io.github.toolfactory.jvm.util.ObjectProvider;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Map;

public interface StopThreadFunction
extends ThrowingBiConsumer<Thread, Throwable, Throwable> {

    public static class ForJava20
    extends ForJava7 {
        public ForJava20(Map<Object, Object> context) throws Throwable {
            super(context);
        }

        @Override
        protected Method retrieveStopThreadMethod() throws NoSuchMethodException, SecurityException {
            return Thread.class.getDeclaredMethod("interrupt0", new Class[0]);
        }

        @Override
        public void accept(Thread thread, Throwable threadDeath) throws Throwable {
            this.methodHandle.invokeWithArguments(thread);
        }
    }

    public static class ForJava7
    extends Abst {
        public ForJava7(Map<Object, Object> context) throws Throwable {
            Method stopThreadMethod = this.retrieveStopThreadMethod();
            ObjectProvider functionProvider = ObjectProvider.get(context);
            functionProvider.getOrBuildObject(SetAccessibleFunction.class, context).accept(stopThreadMethod, true);
            this.methodHandle = ((MethodHandles.Lookup)functionProvider.getOrBuildObject(ConsulterSupplier.class, context).get()).unreflect(stopThreadMethod);
        }

        protected Method retrieveStopThreadMethod() throws NoSuchMethodException, SecurityException {
            return Thread.class.getDeclaredMethod("stop0", Object.class);
        }

        public static class ForSemeru
        extends ForJava7 {
            public ForSemeru(Map<Object, Object> context) throws Throwable {
                super(context);
            }

            @Override
            protected Method retrieveStopThreadMethod() throws NoSuchMethodException, SecurityException {
                return Thread.class.getDeclaredMethod("stopImpl", Throwable.class);
            }
        }
    }

    public static abstract class Abst
    implements StopThreadFunction {
        protected MethodHandle methodHandle;

        @Override
        public void accept(Thread thread, Throwable threadDeath) throws Throwable {
            this.methodHandle.invokeWithArguments(thread, threadDeath);
        }
    }
}

