/*
 * Decompiled with CFR 0.152.
 */
package io.github.t12y.ssim.matlab;

import io.github.t12y.ssim.Math;
import io.github.t12y.ssim.matlab.Ones;
import io.github.t12y.ssim.matlab.Sub;
import io.github.t12y.ssim.matlab.Zeros;
import io.github.t12y.ssim.models.Matrix;
import io.github.t12y.ssim.models.Shape;

public class Conv2 {
    private static Matrix mxConv2(Matrix ref, Matrix b, Shape shape) {
        int cWidth = ref.width + b.width - 1;
        int cHeight = ref.height + b.height - 1;
        double[] data = Zeros.zeros((int)cHeight, (int)cWidth).data;
        for (int r1 = 0; r1 < b.height; ++r1) {
            for (int c1 = 0; c1 < b.width; ++c1) {
                double br1c1 = b.data[r1 * b.width + c1];
                if (br1c1 == 0.0) continue;
                for (int i = 0; i < ref.height; ++i) {
                    for (int j = 0; j < ref.width; ++j) {
                        int n = (i + r1) * cWidth + j + c1;
                        data[n] = data[n] + ref.data[i * ref.width + j] * br1c1;
                    }
                }
            }
        }
        Matrix c = new Matrix(cHeight, cWidth, data);
        return Conv2.reshape(c, shape, ref.height, b.height, ref.width, b.width);
    }

    private static Matrix boxConv(Matrix a, Matrix m, Shape shape) {
        Matrix b1 = Ones.ones(m.height, 1);
        Matrix b2 = Ones.ones(1, m.width);
        Matrix out = Conv2.convn(a, b1, b2, shape);
        return Math.multiply2d(out, m.data[0]);
    }

    private static boolean isBoxKernel(Matrix m) {
        double expected = m.data[0];
        for (int i = 1; i < m.data.length; ++i) {
            if (m.data[i] == expected) continue;
            return false;
        }
        return true;
    }

    private static Matrix convn(Matrix a, Matrix b1, Matrix b2, Shape shape) {
        int mb = java.lang.Math.max(b1.height, b1.width);
        int nb = java.lang.Math.max(b2.height, b2.width);
        Matrix temp = Conv2.mxConv2(a, b1, Shape.FULL);
        Matrix c = Conv2.mxConv2(temp, b2, Shape.FULL);
        return Conv2.reshape(c, shape, a.height, mb, a.width, nb);
    }

    private static Matrix reshape(Matrix c, Shape shape, int ma, int mb, int na, int nb) {
        if (shape == Shape.FULL) {
            return c;
        }
        if (shape == Shape.SAME) {
            int rowStart = (int)java.lang.Math.ceil((double)(c.height - ma) / 2.0);
            int colStart = (int)java.lang.Math.ceil((double)(c.width - na) / 2.0);
            return Sub.sub(c, rowStart, ma, colStart, na);
        }
        return Sub.sub(c, mb - 1, ma - mb + 1, nb - 1, na - nb + 1);
    }

    public static Matrix conv2(Matrix a, Matrix b, Shape shape) {
        if (Conv2.isBoxKernel(b)) {
            return Conv2.boxConv(a, b, shape);
        }
        return Conv2.mxConv2(a, b, shape);
    }

    public static Matrix conv2(Matrix a, Matrix b1, Matrix b2, Shape shape) {
        return Conv2.convn(a, b1, b2, shape);
    }
}

