/*
 * Decompiled with CFR 0.152.
 */
package io.github.sukgu.support;

import io.github.sukgu.support.FindByCssSelector;
import io.github.sukgu.support.FindByXPath;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.HashSet;
import org.openqa.selenium.By;
import org.openqa.selenium.support.AbstractFindByBuilder;
import org.openqa.selenium.support.PageFactoryFinder;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.TYPE})
@PageFactoryFinder(value=FindByBuilder.class)
public @interface FindElementBy {
    public String css() default "";

    public String xpath() default "";

    public static class FindByBuilder
    extends AbstractFindByBuilder {
        public By buildIt(Object annotation, Field field) {
            FindElementBy findElementBy = (FindElementBy)annotation;
            this.assertValidFindBy(findElementBy);
            By ans = this.buildByFromFindElementBy(findElementBy);
            return ans;
        }

        private By buildByFromFindElementBy(FindElementBy findBy) {
            if (!"".equals(findBy.css())) {
                return new FindByCssSelector(findBy.css(), SelectorType.CSS_SELECTOR.toString());
            }
            if (!"".equals(findBy.xpath())) {
                return new FindByXPath(findBy.xpath(), SelectorType.XPATH.toString());
            }
            return null;
        }

        private void assertValidFindBy(FindElementBy findBy) {
            HashSet<String> finders = new HashSet<String>();
            if (!"".equals(findBy.css())) {
                finders.add("css:" + findBy.css());
            }
            if (!"".equals(findBy.xpath())) {
                finders.add("xpath: " + findBy.xpath());
            }
            if (finders.size() > 1) {
                throw new IllegalArgumentException(String.format("You must specify at most one location strategy. Number found: %d (%s)", finders.size(), ((Object)finders).toString()));
            }
        }

        static enum SelectorType {
            CSS_SELECTOR("css"),
            XPATH("xpath");

            private final String type;

            private SelectorType(String type) {
                this.type = type;
            }

            public String toString() {
                return this.type;
            }
        }
    }
}

