/*
 * Decompiled with CFR 0.152.
 */
package io.github.spark_redshift_community.spark.redshift;

import io.github.spark_redshift_community.spark.redshift.Utils$;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.package$;
import org.apache.spark.sql.execution.datasources.jdbc.DriverRegistry$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005ec!B\b\u0011\u0001AQ\u0002\"B\u0011\u0001\t\u0003\u0019\u0003b\u0002\u0014\u0001\u0005\u0004%Ia\n\u0005\u0007a\u0001\u0001\u000b\u0011\u0002\u0015\t\u000fE\u0002!\u0019!C\u0005e!1\u0011\b\u0001Q\u0001\nMBQA\u000f\u0001\u0005\nmBQA\u0014\u0001\u0005\u0002=CQ!\u0018\u0001\u0005\u0002yCQA\u0014\u0001\u0005\n\rDQA\u001e\u0001\u0005\u0002]Dq!a\u0005\u0001\t\u0003\t)\u0002C\u0004\u0002*\u0001!\t!a\u000b\t\u000f\u0005E\u0002\u0001\"\u0001\u00024!9\u0011\u0011\b\u0001\u0005\n\u0005m\"a\u0003&E\u0005\u000e;&/\u00199qKJT!!\u0005\n\u0002\u0011I,Gm\u001d5jMRT!a\u0005\u000b\u0002\u000bM\u0004\u0018M]6\u000b\u0005U1\u0012\u0001G:qCJ\\wL]3eg\"Lg\r^0d_6lWO\\5us*\u0011q\u0003G\u0001\u0007O&$\b.\u001e2\u000b\u0003e\t!![8\u0014\u0005\u0001Y\u0002C\u0001\u000f \u001b\u0005i\"\"\u0001\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001j\"AB!osJ+g-\u0001\u0004=S:LGOP\u0002\u0001)\u0005!\u0003CA\u0013\u0001\u001b\u0005\u0001\u0012a\u00017pOV\t\u0001\u0006\u0005\u0002*]5\t!F\u0003\u0002,Y\u0005)1\u000f\u001c45U*\tQ&A\u0002pe\u001eL!a\f\u0016\u0003\r1{wmZ3s\u0003\u0011awn\u001a\u0011\u0002\u0005\u0015\u001cW#A\u001a\u0011\u0005Q:T\"A\u001b\u000b\u0005Yj\u0012AC2p]\u000e,(O]3oi&\u0011\u0001(\u000e\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\f1!Z2!\u000399W\r\u001e#sSZ,'o\u00117bgN$2\u0001P$J!\tiDI\u0004\u0002?\u0005B\u0011q(H\u0007\u0002\u0001*\u0011\u0011II\u0001\u0007yI|w\u000e\u001e \n\u0005\rk\u0012A\u0002)sK\u0012,g-\u0003\u0002F\r\n11\u000b\u001e:j]\u001eT!aQ\u000f\t\u000b!3\u0001\u0019\u0001\u001f\u0002\u001f)$'mY*vEB\u0014x\u000e^8d_2DQA\u0013\u0004A\u0002-\u000bq#^:feB\u0013xN^5eK\u0012$%/\u001b<fe\u000ec\u0017m]:\u0011\u0007qaE(\u0003\u0002N;\t1q\n\u001d;j_:\fA#\u001a=fGV$X-\u00138uKJ\u0014X\u000f\u001d;jE2LHC\u0001)T!\ta\u0012+\u0003\u0002S;\t9!i\\8mK\u0006t\u0007\"\u0002+\b\u0001\u0004)\u0016!C:uCR,W.\u001a8u!\t16,D\u0001X\u0015\tA\u0016,A\u0002tc2T\u0011AW\u0001\u0005U\u00064\u0018-\u0003\u0002]/\n\t\u0002K]3qCJ,Gm\u0015;bi\u0016lWM\u001c;\u00023\u0015DXmY;uKF+XM]=J]R,'O];qi&\u0014G.\u001f\u000b\u0003?\n\u0004\"A\u00161\n\u0005\u0005<&!\u0003*fgVdGoU3u\u0011\u0015!\u0006\u00021\u0001V+\t!w\rF\u0002faF\u0004\"AZ4\r\u0001\u0011)\u0001.\u0003b\u0001S\n\tA+\u0005\u0002k[B\u0011Ad[\u0005\u0003Yv\u0011qAT8uQ&tw\r\u0005\u0002\u001d]&\u0011q.\b\u0002\u0004\u0003:L\b\"\u0002+\n\u0001\u0004)\u0006\"\u0002:\n\u0001\u0004\u0019\u0018AA8q!\u0011aB/V3\n\u0005Ul\"!\u0003$v]\u000e$\u0018n\u001c82\u00031\u0011Xm]8mm\u0016$\u0016M\u00197f)\u0015A\u0018QAA\b!\rI\u0018\u0011A\u0007\u0002u*\u00111\u0010`\u0001\u0006if\u0004Xm\u001d\u0006\u00031vT!a\u0005@\u000b\u0005}d\u0013AB1qC\u000eDW-C\u0002\u0002\u0004i\u0014!b\u0015;sk\u000e$H+\u001f9f\u0011\u001d\t9A\u0003a\u0001\u0003\u0013\tAaY8o]B\u0019a+a\u0003\n\u0007\u00055qK\u0001\u0006D_:tWm\u0019;j_:Da!!\u0005\u000b\u0001\u0004a\u0014!\u0002;bE2,\u0017\u0001D4fi\u000e{gN\\3di>\u0014H\u0003CA\u0005\u0003/\tI\"!\b\t\u000b)[\u0001\u0019A&\t\r\u0005m1\u00021\u0001=\u0003\r)(\u000f\u001c\u0005\b\u0003?Y\u0001\u0019AA\u0011\u0003-\u0019'/\u001a3f]RL\u0017\r\\:\u0011\tqa\u00151\u0005\t\u00069\u0005\u0015B\bP\u0005\u0004\u0003Oi\"A\u0002+va2,''\u0001\u0007tG\",W.Y*ue&tw\rF\u0002=\u0003[Aa!a\f\r\u0001\u0004A\u0018AB:dQ\u0016l\u0017-A\u0006uC\ndW-\u0012=jgR\u001cH#\u0002)\u00026\u0005]\u0002bBA\u0004\u001b\u0001\u0007\u0011\u0011\u0002\u0005\u0007\u0003#i\u0001\u0019\u0001\u001f\u0002\u001f\u001d,GoQ1uC2L8\u000f\u001e+za\u0016$\"\"!\u0010\u0002D\u00055\u0013\u0011KA+!\rI\u0018qH\u0005\u0004\u0003\u0003R(\u0001\u0003#bi\u0006$\u0016\u0010]3\t\u000f\u0005\u0015c\u00021\u0001\u0002H\u000591/\u001d7UsB,\u0007c\u0001\u000f\u0002J%\u0019\u00111J\u000f\u0003\u0007%sG\u000fC\u0004\u0002P9\u0001\r!a\u0012\u0002\u0013A\u0014XmY5tS>t\u0007bBA*\u001d\u0001\u0007\u0011qI\u0001\u0006g\u000e\fG.\u001a\u0005\u0007\u0003/r\u0001\u0019\u0001)\u0002\rMLwM\\3e\u0001")
public class JDBCWrapper {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ExecutionContext ec;

    private Logger log() {
        return this.log;
    }

    private ExecutionContext ec() {
        return this.ec;
    }

    private String getDriverClass(String jdbcSubprotocol, Option<String> userProvidedDriverClass) {
        return (String)userProvidedDriverClass.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            String string;
            String string2 = jdbcSubprotocol;
            if ("redshift".equals(string2)) {
                String string3;
                try {
                    string3 = Utils$.MODULE$.classForName("com.amazon.redshift.jdbc42.Driver").getName();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    try {
                        string3 = Utils$.MODULE$.classForName("com.amazon.redshift.jdbc41.Driver").getName();
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        try {
                            string3 = Utils$.MODULE$.classForName("com.amazon.redshift.jdbc4.Driver").getName();
                        }
                        catch (ClassNotFoundException e) {
                            throw new ClassNotFoundException("Could not load an Amazon Redshift JDBC driver; see the README for instructions on downloading and configuring the official Amazon driver.", e);
                        }
                    }
                }
                string = string3;
            } else if ("postgresql".equals(string2)) {
                string = "org.postgresql.Driver";
            } else {
                throw new IllegalArgumentException(new java.lang.StringBuilder(29).append("Unsupported JDBC protocol: '").append(string2).append("'").toString());
            }
            return string;
        });
    }

    public boolean executeInterruptibly(PreparedStatement statement) {
        return BoxesRunTime.unboxToBoolean(this.executeInterruptibly(statement, (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.execute())));
    }

    public ResultSet executeQueryInterruptibly(PreparedStatement statement) {
        return (ResultSet)this.executeInterruptibly(statement, (Function1 & Serializable & scala.Serializable)x$2 -> x$2.executeQuery());
    }

    private <T> T executeInterruptibly(PreparedStatement statement, Function1<PreparedStatement, T> op) {
        Object object;
        try {
            Future future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> op.apply((Object)statement), this.ec());
            try {
                object = Await$.MODULE$.result((Awaitable)future, (Duration)Duration$.MODULE$.Inf());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof SQLException) {
                    SQLException sQLException = (SQLException)throwable2;
                    throw new SQLException("Exception thrown in awaitResult: ", sQLException);
                }
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable t = (Throwable)option.get();
                    throw new Exception("Exception thrown in awaitResult: ", t);
                }
                throw throwable;
            }
        }
        catch (InterruptedException e) {
            try {
                statement.cancel();
                throw e;
            }
            catch (SQLException s) {
                this.log().error("Exception occurred while cancelling query", (Throwable)s);
                throw e;
            }
        }
        return (T)object;
    }

    public StructType resolveTable(Connection conn, String table) {
        StructType structType;
        try (PreparedStatement ps = conn.prepareStatement(new java.lang.StringBuilder(22).append("SELECT * FROM ").append(table).append(" LIMIT 1").toString());){
            ResultSetMetaData rsmd = (ResultSetMetaData)this.executeInterruptibly(ps, (Function1 & Serializable & scala.Serializable)x$3 -> x$3.getMetaData());
            int ncols = rsmd.getColumnCount();
            StructField[] fields = new StructField[ncols];
            for (int i = 0; i < ncols; ++i) {
                String columnName = rsmd.getColumnLabel(i + 1);
                int dataType = rsmd.getColumnType(i + 1);
                int fieldSize = rsmd.getPrecision(i + 1);
                int fieldScale = rsmd.getScale(i + 1);
                boolean isSigned = rsmd.isSigned(i + 1);
                boolean nullable = rsmd.isNullable(i + 1) != 0;
                DataType columnType = this.getCatalystType(dataType, fieldSize, fieldScale, isSigned);
                fields[i] = new StructField(columnName, columnType, nullable, StructField$.MODULE$.apply$default$4());
            }
            structType = new StructType(fields);
        }
        return structType;
    }

    public Connection getConnector(Option<String> userProvidedDriverClass, String url, Option<Tuple2<String, String>> credentials) {
        String subprotocol = new StringOps(Predef$.MODULE$.augmentString(url)).stripPrefix("jdbc:").split(":")[0];
        String driverClass = this.getDriverClass(subprotocol, userProvidedDriverClass);
        DriverRegistry$.MODULE$.register(driverClass);
        Class<?> driverWrapperClass = package$.MODULE$.SPARK_VERSION().startsWith("1.4") ? Utils$.MODULE$.classForName("org.apache.spark.sql.jdbc.package$DriverWrapper") : Utils$.MODULE$.classForName("org.apache.spark.sql.execution.datasources.jdbc.DriverWrapper");
        Driver driver = (Driver)((TraversableOnce)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(DriverManager.getDrivers()).asScala()).collectFirst((PartialFunction)new scala.Serializable(this, driverWrapperClass, driverClass){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JDBCWrapper $outer;
            private final Class driverWrapperClass$1;
            private final String driverClass$1;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final <A1 extends Driver, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                void var3_8;
                A1 A1 = x1;
                if (this.driverWrapperClass$1.isAssignableFrom(A1.getClass())) {
                    String string = JDBCWrapper.io$github$spark_redshift_community$spark$redshift$JDBCWrapper$$getWrapped$1(A1, this.driverWrapperClass$1).getClass().getCanonicalName();
                    String string2 = this.driverClass$1;
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        A1 A12 = A1;
                        return var3_8;
                    }
                }
                String string = A1.getClass().getCanonicalName();
                String string3 = this.driverClass$1;
                if (!(string != null ? !string.equals(string3) : string3 != null)) {
                    A1 A13 = A1;
                    return var3_8;
                }
                Object object = function1.apply(x1);
                return var3_8;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Driver x1) {
                Driver driver = x1;
                if (this.driverWrapperClass$1.isAssignableFrom(driver.getClass())) {
                    String string = JDBCWrapper.io$github$spark_redshift_community$spark$redshift$JDBCWrapper$$getWrapped$1(driver, this.driverWrapperClass$1).getClass().getCanonicalName();
                    String string2 = this.driverClass$1;
                    if (string == null) {
                        if (string2 == null) return true;
                    } else if (string.equals(string2)) {
                        return true;
                    }
                }
                String string = driver.getClass().getCanonicalName();
                String string3 = this.driverClass$1;
                if (string != null) {
                    if (!string.equals(string3)) return false;
                    return true;
                }
                if (string3 == null) return true;
                return false;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.driverWrapperClass$1 = driverWrapperClass$1;
                this.driverClass$1 = driverClass$1;
            }
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new java.lang.StringBuilder(42).append("Did not find registered driver with class ").append(driverClass).toString());
        });
        Properties properties = new Properties();
        credentials.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String user = (String)tuple2._1();
            String password = (String)tuple2._2();
            properties.setProperty("user", user);
            Object object = properties.setProperty("password", password);
            return object;
        });
        return driver.connect(url, properties);
    }

    public String schemaString(StructType schema) {
        StringBuilder sb = new StringBuilder();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).foreach((Function1 & Serializable & scala.Serializable)field -> {
            String string;
            String name = field.name();
            if (field.metadata().contains("redshift_type")) {
                string = field.metadata().getString("redshift_type");
            } else {
                String string2;
                DataType dataType = field.dataType();
                if (IntegerType$.MODULE$.equals(dataType)) {
                    string2 = "INTEGER";
                } else if (LongType$.MODULE$.equals(dataType)) {
                    string2 = "BIGINT";
                } else if (DoubleType$.MODULE$.equals(dataType)) {
                    string2 = "DOUBLE PRECISION";
                } else if (FloatType$.MODULE$.equals(dataType)) {
                    string2 = "REAL";
                } else if (ShortType$.MODULE$.equals(dataType)) {
                    string2 = "INTEGER";
                } else if (ByteType$.MODULE$.equals(dataType)) {
                    string2 = "SMALLINT";
                } else if (BooleanType$.MODULE$.equals(dataType)) {
                    string2 = "BOOLEAN";
                } else if (StringType$.MODULE$.equals(dataType)) {
                    string2 = field.metadata().contains("maxlength") ? new java.lang.StringBuilder(9).append("VARCHAR(").append(field.metadata().getLong("maxlength")).append(")").toString() : "TEXT";
                } else if (TimestampType$.MODULE$.equals(dataType)) {
                    string2 = "TIMESTAMP";
                } else if (DateType$.MODULE$.equals(dataType)) {
                    string2 = "DATE";
                } else if (dataType instanceof DecimalType) {
                    DecimalType decimalType = (DecimalType)dataType;
                    string2 = new java.lang.StringBuilder(10).append("DECIMAL(").append(decimalType.precision()).append(",").append(decimalType.scale()).append(")").toString();
                } else {
                    throw new IllegalArgumentException(new java.lang.StringBuilder(31).append("Don't know how to save ").append(field).append(" to JDBC").toString());
                }
                string = string2;
            }
            String typ = string;
            String nullable = field.nullable() ? "" : "NOT NULL";
            String encoding = field.metadata().contains("encoding") ? new java.lang.StringBuilder(7).append("ENCODE ").append(field.metadata().getString("encoding")).toString() : "";
            return sb.append(new java.lang.StringBuilder(7).append(", \"").append(name.replace("\"", "\\\"")).append("\" ").append(typ).append(" ").append(nullable).append(" ").append(encoding).toString().trim());
        });
        return sb.length() < 2 ? "" : sb.substring(2);
    }

    public boolean tableExists(Connection conn, String table) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            PreparedStatement stmt = conn.prepareStatement(new java.lang.StringBuilder(22).append("SELECT 1 FROM ").append(table).append(" LIMIT 1").toString());
            return ((ResultSetMetaData)this.executeInterruptibly(stmt, (Function1 & Serializable & scala.Serializable)x$4 -> x$4.getMetaData())).getColumnCount();
        }).isSuccess();
    }

    private DataType getCatalystType(int sqlType, int precision, int scale, boolean signed) {
        StringType$ stringType$;
        int n = sqlType;
        switch (n) {
            case 0: {
                stringType$ = null;
                break;
            }
            case 1: {
                stringType$ = StringType$.MODULE$;
                break;
            }
            case -15: {
                stringType$ = StringType$.MODULE$;
                break;
            }
            case -9: {
                stringType$ = StringType$.MODULE$;
                break;
            }
            case 12: {
                stringType$ = StringType$.MODULE$;
                break;
            }
            case -1: {
                stringType$ = StringType$.MODULE$;
                break;
            }
            case 91: {
                stringType$ = DateType$.MODULE$;
                break;
            }
            case 92: {
                stringType$ = TimestampType$.MODULE$;
                break;
            }
            case 93: {
                stringType$ = TimestampType$.MODULE$;
                break;
            }
            case -7: {
                stringType$ = BooleanType$.MODULE$;
                break;
            }
            case 16: {
                stringType$ = BooleanType$.MODULE$;
                break;
            }
            case -5: {
                if (signed) {
                    stringType$ = LongType$.MODULE$;
                    break;
                }
                stringType$ = new DecimalType(20, 0);
                break;
            }
            case 3: {
                if (precision != 0 || scale != 0) {
                    stringType$ = new DecimalType(precision, scale);
                    break;
                }
                stringType$ = new DecimalType(38, 18);
                break;
            }
            case 8: {
                stringType$ = DoubleType$.MODULE$;
                break;
            }
            case 6: {
                stringType$ = FloatType$.MODULE$;
                break;
            }
            case 4: {
                if (signed) {
                    stringType$ = IntegerType$.MODULE$;
                    break;
                }
                stringType$ = LongType$.MODULE$;
                break;
            }
            case 2: {
                if (precision != 0 || scale != 0) {
                    stringType$ = new DecimalType(precision, scale);
                    break;
                }
                stringType$ = new DecimalType(38, 18);
                break;
            }
            case 7: {
                stringType$ = FloatType$.MODULE$;
                break;
            }
            case 5: {
                stringType$ = IntegerType$.MODULE$;
                break;
            }
            case -6: {
                stringType$ = IntegerType$.MODULE$;
                break;
            }
            default: {
                stringType$ = null;
                break;
            }
        }
        StringType$ answer = stringType$;
        if (answer == null) {
            throw new SQLException(new java.lang.StringBuilder(17).append("Unsupported type ").append(sqlType).toString());
        }
        return answer;
    }

    public static final Driver io$github$spark_redshift_community$spark$redshift$JDBCWrapper$$getWrapped$1(Driver d, Class driverWrapperClass$1) {
        Predef$.MODULE$.require(driverWrapperClass$1.isAssignableFrom(d.getClass()));
        return (Driver)driverWrapperClass$1.getDeclaredMethod("wrapped", new Class[0]).invoke((Object)d, new Object[0]);
    }

    public JDBCWrapper() {
        ThreadFactory threadFactory = new ThreadFactory(null){
            private final AtomicInteger count;

            /*
             * WARNING - void declaration
             */
            public Thread newThread(Runnable r) {
                void var2_2;
                Thread thread = new Thread(r);
                thread.setName(new java.lang.StringBuilder(27).append("spark-redshift-JDBCWrapper-").append(this.count.incrementAndGet()).toString());
                thread.setDaemon(true);
                return var2_2;
            }
            {
                this.count = new AtomicInteger();
            }
        };
        this.ec = ExecutionContext$.MODULE$.fromExecutorService(Executors.newCachedThreadPool(threadFactory));
    }
}

