/*
 * Decompiled with CFR 0.152.
 */
package io.github.spark_redshift_community.spark.redshift;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;

public final class FilterPushdown$ {
    public static FilterPushdown$ MODULE$;

    static {
        new FilterPushdown$();
    }

    public String buildWhereClause(StructType schema, Seq<Filter> filters) {
        String filterExpressions = ((TraversableOnce)filters.flatMap((Function1 & Serializable & scala.Serializable)f -> Option$.MODULE$.option2Iterable(MODULE$.buildFilterExpression(schema, (Filter)f)), Seq$.MODULE$.canBuildFrom())).mkString(" AND ");
        return filterExpressions.isEmpty() ? "" : new StringBuilder(6).append("WHERE ").append(filterExpressions).toString();
    }

    public Option<String> buildFilterExpression(StructType schema, Filter filter) {
        Option option;
        Filter filter2 = filter;
        if (filter2 instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)filter2;
            String attr = equalTo.attribute();
            Object value = equalTo.value();
            option = this.buildComparison$1(attr, value, "=", schema);
        } else if (filter2 instanceof LessThan) {
            LessThan lessThan = (LessThan)filter2;
            String attr = lessThan.attribute();
            Object value = lessThan.value();
            option = this.buildComparison$1(attr, value, "<", schema);
        } else if (filter2 instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)filter2;
            String attr = greaterThan.attribute();
            Object value = greaterThan.value();
            option = this.buildComparison$1(attr, value, ">", schema);
        } else if (filter2 instanceof LessThanOrEqual) {
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter2;
            String attr = lessThanOrEqual.attribute();
            Object value = lessThanOrEqual.value();
            option = this.buildComparison$1(attr, value, "<=", schema);
        } else if (filter2 instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter2;
            String attr = greaterThanOrEqual.attribute();
            Object value = greaterThanOrEqual.value();
            option = this.buildComparison$1(attr, value, ">=", schema);
        } else if (filter2 instanceof IsNotNull) {
            IsNotNull isNotNull = (IsNotNull)filter2;
            String attr = isNotNull.attribute();
            option = this.getTypeForAttribute(schema, attr).map((Function1 & Serializable & scala.Serializable)dataType -> new StringBuilder(14).append("\"").append(attr).append("\" IS NOT NULL").toString());
        } else if (filter2 instanceof IsNull) {
            IsNull isNull = (IsNull)filter2;
            String attr = isNull.attribute();
            option = this.getTypeForAttribute(schema, attr).map((Function1 & Serializable & scala.Serializable)dataType -> new StringBuilder(10).append("\"").append(attr).append("\" IS NULL").toString());
        } else {
            option = None$.MODULE$;
        }
        return option;
    }

    private Option<DataType> getTypeForAttribute(StructType schema, String attribute) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fieldNames())).contains((Object)attribute) ? new Some((Object)schema.apply(attribute).dataType()) : None$.MODULE$;
    }

    private final Option buildComparison$1(String attr, Object value, String comparisonOp, StructType schema$2) {
        return this.getTypeForAttribute(schema$2, attr).map((Function1 & Serializable & scala.Serializable)dataType -> {
            DataType dataType2 = dataType;
            String string = StringType$.MODULE$.equals(dataType2) ? new StringBuilder(4).append("\\'").append(value.toString().replace("'", "\\'\\'")).append("\\'").toString() : (DateType$.MODULE$.equals(dataType2) ? new StringBuilder(4).append("\\'").append((Date)value).append("\\'").toString() : (TimestampType$.MODULE$.equals(dataType2) ? new StringBuilder(4).append("\\'").append((Timestamp)value).append("\\'").toString() : value.toString()));
            String sqlEscapedValue = string;
            return new StringBuilder(4).append("\"").append(attr).append("\" ").append(comparisonOp).append(" ").append(sqlEscapedValue).toString();
        });
    }

    private FilterPushdown$() {
        MODULE$ = this;
    }
}

