/*
 * Decompiled with CFR 0.152.
 */
package io.github.spark_redshift_community.spark.redshift;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import io.github.spark_redshift_community.spark.redshift.Parameters;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.SeqLike;

public final class AWSCredentialsUtils$ {
    public static AWSCredentialsUtils$ MODULE$;

    static {
        new AWSCredentialsUtils$();
    }

    public String getRedshiftCredentialsString(Parameters.MergedParameters params, AWSCredentials sparkAwsCredentials) {
        String string;
        if (params.iamRole().isDefined()) {
            string = new StringBuilder(13).append("aws_iam_role=").append(params.iamRole().get()).toString();
        } else if (params.temporaryAWSCredentials().isDefined()) {
            string = AWSCredentialsUtils$.awsCredsToString$1(((AWSCredentialsProvider)params.temporaryAWSCredentials().get()).getCredentials());
        } else if (params.forwardSparkS3Credentials()) {
            string = AWSCredentialsUtils$.awsCredsToString$1(sparkAwsCredentials);
        } else {
            throw new IllegalStateException("No Redshift S3 authentication mechanism was specified");
        }
        return string;
    }

    public AWSCredentialsProvider staticCredentialsProvider(AWSCredentials credentials) {
        return new AWSCredentialsProvider(credentials){
            private final AWSCredentials credentials$1;

            public AWSCredentials getCredentials() {
                return this.credentials$1;
            }

            public void refresh() {
            }
            {
                this.credentials$1 = credentials$1;
            }
        };
    }

    public AWSCredentialsProvider load(Parameters.MergedParameters params, Configuration hadoopConfiguration) {
        return (AWSCredentialsProvider)params.temporaryAWSCredentials().getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.loadFromURI(params.rootTempDir(), hadoopConfiguration));
    }

    private AWSCredentialsProvider loadFromURI(String tempPath, Configuration hadoopConfiguration) {
        URI uri = new URI(tempPath);
        String uriScheme = uri.getScheme();
        String string = uriScheme;
        boolean bl = "s3".equals(string) ? true : ("s3n".equals(string) ? true : "s3a".equals(string));
        if (!bl) {
            throw new IllegalArgumentException(new StringBuilder(46).append("Unrecognized scheme ").append(string).append("; expected s3, s3n, or s3a").toString());
        }
        AWSCredentialsProvider aWSCredentialsProvider = (AWSCredentialsProvider)Option$.MODULE$.apply((Object)uri.getUserInfo()).flatMap((Function1 & Serializable & scala.Serializable)userInfo -> {
            None$ none$;
            if (userInfo.contains(":")) {
                String[] stringArray = userInfo.split(":");
                Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) {
                    throw new MatchError((Object)stringArray);
                }
                String accessKey = (String)((SeqLike)option.get()).apply(0);
                String secretKey = (String)((SeqLike)option.get()).apply(1);
                Tuple2 tuple2 = new Tuple2((Object)accessKey, (Object)secretKey);
                Tuple2 tuple22 = tuple2;
                String accessKey2 = (String)tuple22._1();
                String secretKey2 = (String)tuple22._2();
                none$ = new Some((Object)MODULE$.staticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(accessKey2, secretKey2)));
            } else {
                none$ = None$.MODULE$;
            }
            return none$;
        }).orElse((Function0 & Serializable & scala.Serializable)() -> {
            String string = uriScheme;
            String string2 = "s3a";
            String accessKeyConfig = !(string != null ? !string.equals(string2) : string2 != null) ? "access.key" : "awsAccessKeyId";
            String string3 = uriScheme;
            String string4 = "s3a";
            String secretKeyConfig = !(string3 != null ? !string3.equals(string4) : string4 != null) ? "secret.key" : "awsSecretAccessKey";
            String accessKey = hadoopConfiguration.get(new StringBuilder(4).append("fs.").append(uriScheme).append(".").append(accessKeyConfig).toString(), null);
            String secretKey = hadoopConfiguration.get(new StringBuilder(4).append("fs.").append(uriScheme).append(".").append(secretKeyConfig).toString(), null);
            return accessKey != null && secretKey != null ? new Some((Object)MODULE$.staticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(accessKey, secretKey))) : None$.MODULE$;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> new DefaultAWSCredentialsProviderChain());
        return aWSCredentialsProvider;
    }

    private static final String awsCredsToString$1(AWSCredentials credentials) {
        String string;
        AWSCredentials aWSCredentials = credentials;
        if (aWSCredentials instanceof AWSSessionCredentials) {
            AWSSessionCredentials aWSSessionCredentials = (AWSSessionCredentials)aWSCredentials;
            string = new StringBuilder(48).append("aws_access_key_id=").append(aWSSessionCredentials.getAWSAccessKeyId()).append(";").append("aws_secret_access_key=").append(aWSSessionCredentials.getAWSSecretKey()).append(";token=").append(aWSSessionCredentials.getSessionToken()).toString();
        } else {
            string = new StringBuilder(41).append("aws_access_key_id=").append(aWSCredentials.getAWSAccessKeyId()).append(";").append("aws_secret_access_key=").append(aWSCredentials.getAWSSecretKey()).toString();
        }
        return string;
    }

    private AWSCredentialsUtils$() {
        MODULE$ = this;
    }
}

