/*
 * Decompiled with CFR 0.152.
 */
package com.power.common.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class StringEscapeUtil {
    public static final Map<CharSequence, CharSequence> JAVA_CTRL_CHARS_ESCAPE;
    private static final Map<String, String> lookupMap;
    public static final Map<CharSequence, CharSequence> JAVA_CTRL_CHARS_UNESCAPE;
    private static final Map<String, String> unescapeLookupMap;

    public static String escapeJava(String content) {
        return StringEscapeUtil.escapeJava(content, Boolean.FALSE);
    }

    public static String escapeJavaIgnoreChinese(String content) {
        return StringEscapeUtil.escapeJava(content, Boolean.TRUE);
    }

    public static String escapeJava(String content, Boolean ignoreChinese) {
        if (Objects.isNull(content)) {
            return null;
        }
        StringBuilder tmp = new StringBuilder(content.length() * 6);
        for (int i = 0; i < content.length(); ++i) {
            char j = content.charAt(i);
            String index = Integer.toHexString(j);
            if (lookupMap.containsKey(index)) {
                tmp.append(lookupMap.get(index));
                continue;
            }
            if (j >= '\u4e00' && j <= '\u9fbb' && ignoreChinese.booleanValue()) {
                tmp.append(j);
                continue;
            }
            if (j >= ' ' && j <= '\u00f7') {
                tmp.append(j);
                continue;
            }
            tmp.append("\\u");
            tmp.append(Character.toUpperCase(Character.forDigit(j >>> 12 & 0xF, 16)));
            tmp.append(Character.toUpperCase(Character.forDigit(j >>> 8 & 0xF, 16)));
            tmp.append(Character.toUpperCase(Character.forDigit(j >>> 4 & 0xF, 16)));
            tmp.append(Character.toUpperCase(Character.forDigit(j & 0xF, 16)));
        }
        return tmp.toString();
    }

    public static Map<CharSequence, CharSequence> invert(Map<CharSequence, CharSequence> map) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }

    private static boolean isOctalDigit(char ch) {
        return ch >= '0' && ch <= '7';
    }

    private static boolean isZeroToThree(char ch) {
        return ch >= '0' && ch <= '3';
    }

    public static String unescapeJava(String content) {
        if (Objects.isNull(content)) {
            return null;
        }
        StringBuilder tmp = new StringBuilder(content.length() * 6);
        int index = 0;
        int len = content.length();
        while (index < len) {
            char c2;
            int pt;
            int consumed;
            char j = content.charAt(index);
            String hexString = Integer.toHexString(j);
            if (content.charAt(index) == '\\' && content.length() - index - 1 > 0 && StringEscapeUtil.isOctalDigit(content.charAt(index + 1))) {
                consumed = StringEscapeUtil.octalUnescape(content, index, tmp);
                for (pt = 0; pt < consumed; ++pt) {
                    index += Character.charCount(Character.codePointAt(content, index));
                }
                continue;
            }
            if (content.charAt(index) == '\\' && index + 1 < content.length() && content.charAt(index + 1) == 'u') {
                consumed = StringEscapeUtil.unicodeUnescape(content, index, tmp);
                for (pt = 0; pt < consumed; ++pt) {
                    index += Character.charCount(Character.codePointAt(content, index));
                }
                continue;
            }
            if (unescapeLookupMap.containsKey(hexString)) {
                tmp.append(unescapeLookupMap.get(hexString));
                ++index;
                continue;
            }
            tmp.append(j);
            if (!Character.isHighSurrogate(j) || ++index >= len || !Character.isLowSurrogate(c2 = content.charAt(index))) continue;
            tmp.append(c2);
            ++index;
        }
        return tmp.toString();
    }

    private static int unicodeUnescape(String input, int index, StringBuilder tmp) {
        int i = 2;
        while (index + i < input.length() && input.charAt(index + i) == 'u') {
            ++i;
        }
        if (index + i < input.length() && input.charAt(index + i) == '+') {
            ++i;
        }
        if (index + i + 4 <= input.length()) {
            CharSequence unicode = input.subSequence(index + i, index + i + 4);
            try {
                int value = Integer.parseInt(unicode.toString(), 16);
                tmp.append((char)value);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Unable to parse unicode value: " + unicode, nfe);
            }
            return i + 4;
        }
        throw new IllegalArgumentException("Less than 4 hex digits in unicode value: '" + input.subSequence(index, input.length()) + "' due to end of CharSequence");
    }

    private static int octalUnescape(String content, int index, StringBuilder tmp) {
        int remaining = content.length() - index - 1;
        StringBuilder builder = new StringBuilder();
        int next = index + 1;
        int next2 = index + 2;
        int next3 = index + 3;
        builder.append(content.charAt(next));
        if (remaining > 1 && StringEscapeUtil.isOctalDigit(content.charAt(next2))) {
            builder.append(content.charAt(next2));
            if (remaining > 2 && StringEscapeUtil.isZeroToThree(content.charAt(next)) && StringEscapeUtil.isOctalDigit(content.charAt(next3))) {
                builder.append(content.charAt(next3));
            }
        }
        tmp.append(Integer.parseInt(builder.toString(), 8));
        return 1 + builder.length();
    }

    static {
        String index;
        char c;
        lookupMap = new HashMap<String, String>();
        HashMap<String, String> initialMap = new HashMap<String, String>();
        initialMap.put("\b", "\\b");
        initialMap.put("\n", "\\n");
        initialMap.put("\t", "\\t");
        initialMap.put("\f", "\\f");
        initialMap.put("\r", "\\r");
        initialMap.put("\"", "\\\"");
        initialMap.put("\\", "\\\\");
        JAVA_CTRL_CHARS_ESCAPE = Collections.unmodifiableMap(initialMap);
        for (Map.Entry<CharSequence, CharSequence> pair : JAVA_CTRL_CHARS_ESCAPE.entrySet()) {
            c = pair.getKey().charAt(0);
            index = Integer.toHexString(c);
            lookupMap.put(index, pair.getValue().toString());
        }
        unescapeLookupMap = new HashMap<String, String>();
        HashMap<String, String> unescapeJavaMap = new HashMap<String, String>();
        unescapeJavaMap.put("\\\\", "\\");
        unescapeJavaMap.put("\\\"", "\"");
        unescapeJavaMap.put("\\'", "'");
        unescapeJavaMap.put("\\", "");
        unescapeJavaMap.put("\\b", "\b");
        unescapeJavaMap.put("\\n", "\n");
        unescapeJavaMap.put("\\t", "\t");
        unescapeJavaMap.put("\\f", "\f");
        unescapeJavaMap.put("\\r", "\r");
        JAVA_CTRL_CHARS_UNESCAPE = Collections.unmodifiableMap(unescapeJavaMap);
        for (Map.Entry<CharSequence, CharSequence> pair : JAVA_CTRL_CHARS_UNESCAPE.entrySet()) {
            c = pair.getKey().charAt(0);
            index = Integer.toHexString(c);
            unescapeLookupMap.put(index, pair.getValue().toString());
        }
    }
}

