/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.netty.router;

import com.robothy.netty.http.HttpRequest;
import com.robothy.netty.http.HttpRequestHandler;
import com.robothy.netty.router.AbstractRouter;
import com.robothy.netty.router.Route;
import com.robothy.netty.router.Router;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

final class DefaultRouter
extends AbstractRouter {
    private final Set<Route> ruleSet = new HashSet<Route>();
    private final TreeNode root = new TreeNode();

    DefaultRouter() {
    }

    @Override
    public Router route(Route route) {
        String[] segments;
        if (this.ruleSet.contains(route)) {
            throw new IllegalArgumentException("The router already has a handler for route " + route);
        }
        this.ruleSet.add(route);
        TreeNode node = this.addNode(this.root, route.getMethod().name());
        for (String segment : segments = this.splitPath(route.getPath())) {
            node = this.addNode(node, segment);
        }
        node.routes.add(route);
        return this;
    }

    private TreeNode addNode(TreeNode parent, String path) {
        TreeNode child = new TreeNode();
        if (path.startsWith("{") && path.endsWith("}")) {
            if (path.length() == 2) {
                throw new IllegalArgumentException("The path variable name cannot be empty.");
            }
            if (parent.likeChild == null) {
                parent.likeChild = child;
            }
            return parent.likeChild;
        }
        if (!parent.exactChildren.containsKey(path)) {
            parent.exactChildren.put(path, child);
        }
        return (TreeNode)parent.exactChildren.get(path);
    }

    @Override
    public HttpRequestHandler match(HttpRequest request) {
        HttpRequestHandler handler = this.matchHandler(request);
        if (null != handler || null != (handler = super.staticResourceMatcher().match(request))) {
            return handler;
        }
        return super.notFoundHandler();
    }

    private HttpRequestHandler matchHandler(HttpRequest request) {
        TreeNode tmp;
        int idx;
        String[] segments = this.splitPath(request.getPath());
        TreeNode node = (TreeNode)this.root.exactChildren.get(request.getMethod().name());
        if (node == null) {
            return null;
        }
        for (idx = 0; idx < segments.length && (tmp = this.getNode(node, segments[idx])) != null; ++idx) {
            node = tmp;
        }
        if (idx != segments.length) {
            return null;
        }
        Route result = null;
        for (Route route : node.routes) {
            boolean paramMatched;
            boolean headerMatched = route.getHeaderMatcher() == null || route.getHeaderMatcher().apply(request.getHeaders()) != false;
            boolean bl = paramMatched = route.getParamMatcher() == null || route.getParamMatcher().apply(request.getParams()) != false;
            if (!headerMatched || !paramMatched) continue;
            result = route;
            break;
        }
        if (result == null) {
            return null;
        }
        request.getParams().putAll(this.parsePathParams(result.getPath(), request.getPath()));
        return result.getHandler();
    }

    private Map<String, List<String>> parsePathParams(String pattern, String path) {
        String[] patternSegments;
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        String[] pathSegments = this.splitPath(path);
        if (pathSegments.length != (patternSegments = this.splitPath(pattern)).length) {
            throw new IllegalArgumentException("'" + path + "' should not match '" + pattern + "'.");
        }
        for (int i = 0; i < pathSegments.length; ++i) {
            if (!patternSegments[i].startsWith("{") || !patternSegments[i].endsWith("}")) continue;
            String key = patternSegments[i].substring(1, patternSegments[i].length() - 1);
            result.putIfAbsent(key, new ArrayList());
            ((List)result.get(key)).add(pathSegments[i]);
        }
        return result;
    }

    TreeNode getNode(TreeNode parent, String segment) {
        return parent.exactChildren.getOrDefault(segment, parent.likeChild);
    }

    private String[] splitPath(String path) {
        Objects.requireNonNull(path, "The path cannot be null.");
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("The path must start with '/'.");
        }
        ArrayList<String> segments = new ArrayList<String>();
        StringBuilder seg = new StringBuilder();
        for (int i = 1; i < path.length(); ++i) {
            if (path.charAt(i) == '/') {
                if (seg.length() == 0) continue;
                segments.add(seg.toString());
                seg = new StringBuilder();
                continue;
            }
            seg.append(path.charAt(i));
        }
        if (seg.length() != 0) {
            segments.add(seg.toString());
        }
        return segments.toArray(new String[0]);
    }

    private static class TreeNode {
        private final Map<String, TreeNode> exactChildren = new HashMap<String, TreeNode>();
        private TreeNode likeChild;
        private final TreeSet<Route> routes = new TreeSet((r1, r2) -> {
            int score1 = 0;
            int score2 = 0;
            if (Objects.nonNull(r1.getHeaderMatcher())) {
                score1 |= 2;
            }
            if (Objects.nonNull(r1.getParamMatcher())) {
                score1 |= 1;
            }
            if (Objects.nonNull(r2.getHeaderMatcher())) {
                score2 |= 2;
            }
            if (Objects.nonNull(r2.getParamMatcher())) {
                score2 |= 1;
            }
            return score2 - score1;
        });

        private TreeNode() {
        }
    }
}

