/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.netty.router;

import com.robothy.netty.http.HttpRequestHandler;
import com.robothy.netty.router.ExceptionHandler;
import com.robothy.netty.router.Router;
import com.robothy.netty.router.StaticResourceMatcher;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractRouter
implements Router {
    private final Map<Class<? extends Throwable>, ExceptionHandler<?>> exceptionHandlerMap = new HashMap();
    private HttpRequestHandler notFoundHandler;
    private StaticResourceMatcher staticResourceMatcher;

    public AbstractRouter() {
        this.exceptionHandlerMap.put(Throwable.class, (cause, request, response) -> {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(out);
            cause.printStackTrace(printStream);
            response.write(out.toString()).putHeader(HttpHeaderNames.CONTENT_TYPE.toString(), HttpHeaderValues.TEXT_PLAIN).status(HttpResponseStatus.INTERNAL_SERVER_ERROR);
        });
        this.notFoundHandler = DEFAULT_NOT_FOUND_HANDLER;
        this.staticResourceMatcher = StaticResourceMatcher.create("classpath:static");
    }

    @Override
    public Router notFound(HttpRequestHandler handler) {
        this.notFoundHandler = handler;
        return this;
    }

    @Override
    public Router staticResource(String rootPath) {
        this.staticResourceMatcher = StaticResourceMatcher.create(rootPath);
        return this;
    }

    protected HttpRequestHandler notFoundHandler() {
        return this.notFoundHandler;
    }

    protected StaticResourceMatcher staticResourceMatcher() {
        return this.staticResourceMatcher;
    }

    @Override
    public <T extends Throwable> Router exceptionHandler(Class<T> exceptionType, ExceptionHandler<T> handler) {
        Objects.requireNonNull(handler, "The exception handler shouldn't be null.");
        this.exceptionHandlerMap.put(exceptionType, handler);
        return this;
    }

    @Override
    public ExceptionHandler<Throwable> findExceptionHandler(Class<? extends Throwable> exceptionType) {
        ExceptionHandler<Throwable> exceptionHandler = null;
        Class<? extends Throwable> type = exceptionType;
        while ((exceptionHandler = this.exceptionHandlerMap.get(type)) == null) {
            type = type.getSuperclass();
        }
        return exceptionHandler;
    }
}

