/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.netty.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class HttpResponse {
    private final Map<String, String> headers = new HashMap<String, String>();
    private HttpResponseStatus status;
    private final CompositeByteBuf body = Unpooled.compositeBuffer();

    public HttpResponse write(String content) {
        if (content != null) {
            this.write(content.getBytes(StandardCharsets.UTF_8));
        }
        return this;
    }

    public HttpResponse write(byte[] bytes) {
        this.body.addComponent(true, Unpooled.copiedBuffer((byte[])bytes));
        return this;
    }

    public HttpResponse write(ByteBuf buf) {
        this.body.addComponent(true, buf);
        return this;
    }

    public HttpResponse status(HttpResponseStatus status) {
        this.status = status;
        return this;
    }

    public HttpResponse putHeader(String key, Object value) {
        this.headers.put(key, String.valueOf(value));
        return this;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public HttpResponseStatus getStatus() {
        return this.status;
    }

    public CompositeByteBuf getBody() {
        return this.body;
    }
}

