/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.netty.codec;

import com.robothy.netty.http.HttpRequest;
import com.robothy.netty.http.HttpRequestHandler;
import com.robothy.netty.http.HttpResponse;
import com.robothy.netty.router.ExceptionHandler;
import com.robothy.netty.router.Router;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpMessageHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    private static final Logger log = LoggerFactory.getLogger(HttpMessageHandler.class);
    private final Router router;

    public HttpMessageHandler(Router router) {
        this.router = router;
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest request) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("{} {}", (Object)request.getMethod(), (Object)request.getUri());
            StringBuilder headers = new StringBuilder();
            request.getHeaders().forEach((name, value) -> headers.append("\n").append((CharSequence)name).append(": ").append((String)value));
            log.debug(headers.toString());
        }
        HttpRequestHandler handler = this.router.match(request);
        HttpResponse response = new HttpResponse();
        if (null == handler) {
            log.warn("No handler for {} {}", (Object)request.getMethod(), (Object)request.getUri());
            response.write("Not found " + request.getPath()).status(HttpResponseStatus.NOT_FOUND).putHeader(HttpHeaderNames.CONTENT_TYPE.toString(), HttpHeaderValues.TEXT_HTML);
        } else {
            try {
                handler.handle(request, response);
            }
            catch (Throwable e) {
                log.error("Failed to handle " + request.getMethod() + " " + request.getPath(), e);
                ExceptionHandler<Throwable> exceptionHandler = this.router.findExceptionHandler(e.getClass());
                response = new HttpResponse();
                exceptionHandler.handle(e, request, response);
            }
        }
        if (null == response.getStatus()) {
            response.status(HttpResponseStatus.OK);
        }
        boolean keepAlive = request.getHttpVersion().isKeepAliveDefault() || HttpHeaderValues.KEEP_ALIVE.contentEquals((CharSequence)request.header(HttpHeaderNames.CONNECTION.toString()).orElse(null));
        response.putHeader(HttpHeaderNames.CONNECTION.toString(), keepAlive ? HttpHeaderValues.KEEP_ALIVE : HttpHeaderValues.CLOSE);
        response.getHeaders().putIfAbsent(HttpHeaderNames.CONTENT_LENGTH.toString(), String.valueOf(response.getBody().readableBytes()));
        ChannelFuture channelFuture = ctx.writeAndFlush((Object)response);
        if (!keepAlive) {
            channelFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        log.info("Rendered {} to {} {}", new Object[]{response.getStatus().code(), request.getMethod(), request.getUri()});
        if (log.isDebugEnabled()) {
            StringBuilder headers = new StringBuilder();
            response.getHeaders().forEach((name, value) -> headers.append("\n").append((String)name).append(": ").append((String)value));
            log.debug(headers.toString());
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        log.error("Caught exception.", cause);
        HttpResponse response = new HttpResponse();
        response.status(HttpResponseStatus.INTERNAL_SERVER_ERROR).write("<h1>Internal Server Error.</h1>").write(cause.getMessage()).putHeader(HttpHeaderNames.CONTENT_TYPE.toString(), HttpHeaderValues.TEXT_HTML).putHeader(HttpHeaderNames.CONNECTION.toString(), HttpHeaderValues.CLOSE).putHeader(HttpHeaderNames.CONTENT_LENGTH.toString(), response.getBody().readableBytes());
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        log.info("Channel " + ctx.channel().id() + " active.");
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        Channel ch = ctx.channel();
        log.info("Channel " + ch.id() + " inactive.");
    }
}

